/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.CatalogName;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.ValidateStreamingAggregations;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateStreamingAggregations
extends BasePlanTest {
    private Metadata metadata;
    private TypeOperators typeOperators = new TypeOperators();
    private TypeAnalyzer typeAnalyzer;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.typeAnalyzer = new TypeAnalyzer(this.getQueryRunner().getSqlParser(), this.metadata);
        CatalogName catalogName = this.getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)new TpchTableHandle("nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.empty());
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))));
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("unique"), p.symbol("nationkey")).preGroupedSymbols(p.symbol("unique"), p.symbol("nationkey")).source((PlanNode)p.assignUniqueId(p.symbol("unique"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))))));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Streaming aggregation with input not grouped on the grouping keys")
    public void testValidateFailed() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).preGroupedSymbols(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))));
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder builder = new PlanBuilder(this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateStreamingAggregations().validate(planNode, session, this.metadata, this.typeOperators, this.typeAnalyzer, types, WarningCollector.NOOP);
            return null;
        });
    }
}

