/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this((QueryRunner)LocalQueryRunner.create((Session)session));
    }

    public QueryAssertions(QueryRunner runner) {
        this.runner = Objects.requireNonNull(runner, "runner is null");
    }

    public Session.SessionBuilder sessionBuilder() {
        return Session.builder((Session)this.runner.getDefaultSession());
    }

    public Session getDefaultSession() {
        return this.runner.getDefaultSession();
    }

    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query) {
        return this.query(this.runner.getDefaultSession(), query);
    }

    @Deprecated
    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query, Session session) {
        return this.query(session, query);
    }

    public AssertProvider<QueryAssert> query(Session session, @Language(value="SQL") String query) {
        return QueryAssert.newQueryAssert(query, this.runner, session);
    }

    public AssertProvider<ExpressionAssert> expression(@Language(value="SQL") String expression) {
        return this.expression(expression, this.runner.getDefaultSession());
    }

    public AssertProvider<ExpressionAssert> expression(@Language(value="SQL") String expression, Session session) {
        return ExpressionAssert.newExpressionAssert(expression, this.runner, session);
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern) {
        this.assertQuery(this.runner.getDefaultSession(), actual, expected, false);
        Plan plan = this.runner.executeWithPlan(this.runner.getDefaultSession(), actual, WarningCollector.NOOP).getQueryPlan();
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getMetadata(), this.runner.getStatsCalculator(), plan, pattern);
    }

    private void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(session, actual);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.execute(expected);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Assert.assertEquals((Collection)actualResults.getTypes(), (Collection)expectedResults.getTypes(), (String)("Types mismatch for query: \n " + actual + "\n:"));
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
        }
    }

    public void assertQueryReturnsEmptyResult(@Language(value="SQL") String actual) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(actual);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        List actualRows = actualResults.getMaterializedRows();
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    public MaterializedResult execute(@Language(value="SQL") String query) {
        return this.execute(this.runner.getDefaultSession(), query);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String query) {
        MaterializedResult actualResults = this.runner.execute(session, query).toTestTypes();
        return actualResults;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public QueryRunner getQueryRunner() {
        return this.runner;
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.runner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.runner.getExclusiveLock().unlock();
        }
    }

    public static class ExpressionAssert
    extends AbstractAssert<ExpressionAssert, Object> {
        private static final StandardRepresentation TYPE_RENDERER = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof SqlTimestamp) {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    return String.format("%s [p = %s, epochMicros = %s, fraction = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMicros(), timestamp.getPicosOfMicros());
                }
                if (object instanceof SqlTimestampWithTimeZone) {
                    SqlTimestampWithTimeZone timestamp = (SqlTimestampWithTimeZone)object;
                    return String.format("%s [p = %s, epochMillis = %s, fraction = %s, tz = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), timestamp.getTimeZoneKey());
                }
                if (object instanceof SqlTime) {
                    SqlTime time = (SqlTime)object;
                    return String.format("%s [picos = %s]", time, time.getPicos());
                }
                if (object instanceof SqlTimeWithTimeZone) {
                    SqlTimeWithTimeZone time = (SqlTimeWithTimeZone)object;
                    return String.format("%s [picos = %s, offset = %s]", time, time.getPicos(), time.getOffsetMinutes());
                }
                return Objects.toString(object);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final Type actualType;

        static AssertProvider<ExpressionAssert> newExpressionAssert(String expression, QueryRunner runner, Session session) {
            MaterializedResult result = runner.execute(session, "VALUES " + expression);
            Type type = (Type)result.getTypes().get(0);
            Object value = result.getOnlyColumnAsSet().iterator().next();
            return () -> (ExpressionAssert)new ExpressionAssert(runner, session, value, type).withRepresentation((Representation)TYPE_RENDERER);
        }

        public ExpressionAssert(QueryRunner runner, Session session, Object actual, Type actualType) {
            super(actual, Object.class);
            this.runner = runner;
            this.session = session;
            this.actualType = actualType;
        }

        public ExpressionAssert isEqualTo(BiFunction<Session, QueryRunner, Object> evaluator) {
            return (ExpressionAssert)this.isEqualTo(evaluator.apply(this.session, this.runner));
        }

        public ExpressionAssert matches(@Language(value="SQL") String expression) {
            MaterializedResult result = this.runner.execute(this.session, "VALUES " + expression);
            Type expectedType = (Type)result.getTypes().get(0);
            Object expectedValue = result.getOnlyColumnAsSet().iterator().next();
            return (ExpressionAssert)this.satisfies(actual -> {
                ((ObjectAssert)Assertions.assertThat((Object)this.actualType).as("Type", new Object[0])).isEqualTo((Object)expectedType);
                ((ObjectAssert)Assertions.assertThat((Object)actual).withRepresentation((Representation)TYPE_RENDERER)).isEqualTo(expectedValue);
            });
        }

        public ExpressionAssert hasType(Type type) {
            this.objects.assertEqual((AssertionInfo)this.info, (Object)this.actualType, (Object)type);
            return this;
        }
    }

    public static class QueryAssert
    extends AbstractAssert<QueryAssert, MaterializedResult> {
        private static final Representation ROWS_REPRESENTATION = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof List) {
                    List list = (List)object;
                    return list.stream().map(this::toStringOf).collect(Collectors.joining(", "));
                }
                if (object instanceof MaterializedRow) {
                    MaterializedRow row = (MaterializedRow)object;
                    return row.getFields().stream().map(this::formatRowElement).collect(Collectors.joining(", ", "(", ")"));
                }
                return super.toStringOf(object);
            }

            private String formatRowElement(Object value) {
                if (value == null) {
                    return "null";
                }
                if (value.getClass().isArray()) {
                    return this.formatArray(value);
                }
                return String.valueOf(value);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final String query;
        private boolean ordered;
        private boolean skipTypesCheck;
        private boolean skipResultsCorrectnessCheckForPushdown;

        static AssertProvider<QueryAssert> newQueryAssert(String query, QueryRunner runner, Session session) {
            MaterializedResult result = runner.execute(session, query);
            return () -> new QueryAssert(runner, session, query, result);
        }

        public QueryAssert(QueryRunner runner, Session session, String query, MaterializedResult actual) {
            super((Object)actual, Object.class);
            this.runner = Objects.requireNonNull(runner, "runner is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.query = Objects.requireNonNull(query, "query is null");
        }

        public QueryAssert projected(int ... columns) {
            return new QueryAssert(this.runner, this.session, String.format("%s projected with %s", this.query, Arrays.toString(columns)), new MaterializedResult((List)((MaterializedResult)this.actual).getMaterializedRows().stream().map(row -> new MaterializedRow(row.getPrecision(), IntStream.of(columns).mapToObj(arg_0 -> ((MaterializedRow)row).getField(arg_0)).collect(Collectors.toList()))).collect(ImmutableList.toImmutableList()), (List)IntStream.of(columns).mapToObj(((MaterializedResult)this.actual).getTypes()::get).collect(ImmutableList.toImmutableList())));
        }

        public QueryAssert matches(BiFunction<Session, QueryRunner, MaterializedResult> evaluator) {
            MaterializedResult expected = evaluator.apply(this.session, this.runner);
            return this.matches(expected);
        }

        public QueryAssert ordered() {
            this.ordered = true;
            return this;
        }

        public QueryAssert skippingTypesCheck() {
            this.skipTypesCheck = true;
            return this;
        }

        public QueryAssert skipResultsCorrectnessCheckForPushdown() {
            this.skipResultsCorrectnessCheckForPushdown = true;
            return this;
        }

        public QueryAssert matches(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.matches(expected);
        }

        public QueryAssert matches(MaterializedResult expected) {
            return (QueryAssert)this.satisfies(actual -> {
                if (!this.skipTypesCheck) {
                    QueryAssert.assertTypes(actual, expected.getTypes());
                }
                ListAssert assertion = (ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows", new Object[0])).withRepresentation(ROWS_REPRESENTATION);
                if (this.ordered) {
                    assertion.containsExactlyElementsOf((Iterable)expected.getMaterializedRows());
                } else {
                    assertion.containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
                }
            });
        }

        public QueryAssert containsAll(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.containsAll(expected);
        }

        public QueryAssert containsAll(MaterializedResult expected) {
            return (QueryAssert)this.satisfies(actual -> {
                if (!this.skipTypesCheck) {
                    QueryAssert.assertTypes(actual, expected.getTypes());
                }
                ((ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows", new Object[0])).withRepresentation(ROWS_REPRESENTATION)).containsAll((Iterable)expected.getMaterializedRows());
            });
        }

        public QueryAssert hasOutputTypes(List<Type> expectedTypes) {
            return (QueryAssert)this.satisfies(actual -> QueryAssert.assertTypes(actual, expectedTypes));
        }

        public QueryAssert outputHasType(int index, Type expectedType) {
            return (QueryAssert)this.satisfies(actual -> ((ObjectAssert)((ListAssert)Assertions.assertThat((List)actual.getTypes()).as("Output types", new Object[0])).element(index)).isEqualTo((Object)expectedType));
        }

        private static void assertTypes(MaterializedResult actual, List<Type> expectedTypes) {
            ((ListAssert)Assertions.assertThat((List)actual.getTypes()).as("Output types", new Object[0])).isEqualTo(expectedTypes);
        }

        public QueryAssert returnsEmptyResult() {
            return (QueryAssert)this.satisfies(actual -> ((AbstractIntegerAssert)Assertions.assertThat((int)actual.getRowCount()).as("row count", new Object[0])).isEqualTo(0));
        }

        public QueryAssert isFullyPushedDown() {
            Preconditions.checkState((!(this.runner instanceof LocalQueryRunner) ? 1 : 0) != 0, (Object)"isFullyPushedDown() currently does not work with LocalQueryRunner");
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                PlanAssert.assertPlan(session, this.runner.getMetadata(), StatsCalculator.noopStatsCalculator(), plan, PlanMatchPattern.output(PlanMatchPattern.exchange(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))));
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.verifyResultsWithPushdownDisabled();
            }
            return this;
        }

        @SafeVarargs
        public final QueryAssert isNotFullyPushedDown(Class<? extends PlanNode> ... retainedNodes) {
            Preconditions.checkArgument((retainedNodes.length > 0 ? 1 : 0) != 0, (Object)"No retainedNodes");
            PlanMatchPattern expectedPlan = PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]);
            for (Class retainedNode : ImmutableList.copyOf((Object[])retainedNodes).reverse()) {
                expectedPlan = PlanMatchPattern.node(retainedNode, expectedPlan);
            }
            return this.isNotFullyPushedDown(expectedPlan);
        }

        public final QueryAssert isNotFullyPushedDown(PlanMatchPattern retainedSubplan) {
            PlanMatchPattern expectedPlan = PlanMatchPattern.anyTree(retainedSubplan);
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                PlanAssert.assertPlan(session, this.runner.getMetadata(), StatsCalculator.noopStatsCalculator(), plan, expectedPlan);
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.verifyResultsWithPushdownDisabled();
            }
            return this;
        }

        private void verifyResultsWithPushdownDisabled() {
            Session withoutPushdown = Session.builder((Session)this.session).setSystemProperty("allow_pushdown_into_connectors", "false").build();
            this.matches(this.runner.execute(withoutPushdown, this.query));
        }
    }
}

