/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGroupingSets {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testPredicateOverGroupingKeysWithEmptyGroupingSet() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (    SELECT a    FROM (        VALUES 1, 2    ) AS u(a)    GROUP BY GROUPING SETS ((), (a)))SELECT * FROM t WHERE a IS NOT NULL")))).matches("VALUES 1, 2");
    }

    @Test
    public void testDistinctWithMixedReferences() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT ROLLUP(a, t.a)")))).matches("VALUES (1), (NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT GROUPING SETS ((a), (t.a))")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1) t(a) GROUP BY DISTINCT a, GROUPING SETS ((), (t.a))")))).matches("VALUES 1");
    }

    @Test
    public void testRollupAggregationWithOrderedLimit() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 3, 2, 1) t(a) GROUP BY ROLLUP (a) ORDER BY a LIMIT 2")))).matches("VALUES 1, 2");
    }
}

