/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestBigintOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("100000000037", (Type)BigintType.BIGINT, 100000000037L);
        this.assertFunction("100000000017", (Type)BigintType.BIGINT, 100000000017L);
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("BIGINT '9223372036854775807'", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        this.assertFunction("BIGINT '-9223372036854775807'", (Type)BigintType.BIGINT, -9223372036854775807L);
        this.assertFunction("BIGINT '+754'", (Type)BigintType.BIGINT, 754L);
    }

    @Test
    public void testUnaryPlus() {
        this.assertFunction("+100000000037", (Type)BigintType.BIGINT, 100000000037L);
        this.assertFunction("+100000000017", (Type)BigintType.BIGINT, 100000000017L);
    }

    @Test
    public void testUnaryMinus() {
        this.assertFunction("-100000000037", (Type)BigintType.BIGINT, -100000000037L);
        this.assertFunction("-100000000017", (Type)BigintType.BIGINT, -100000000017L);
    }

    @Test
    public void testAdd() {
        this.assertFunction("37 + 100000000037", (Type)BigintType.BIGINT, 100000000074L);
        this.assertFunction("37 + 100000000017", (Type)BigintType.BIGINT, 100000000054L);
        this.assertFunction("100000000017 + 37", (Type)BigintType.BIGINT, 100000000054L);
        this.assertFunction("100000000017 + 100000000017", (Type)BigintType.BIGINT, 200000000034L);
    }

    @Test
    public void testSubtract() {
        this.assertFunction("100000000037 - 37", (Type)BigintType.BIGINT, 100000000000L);
        this.assertFunction("37 - 100000000017", (Type)BigintType.BIGINT, -99999999980L);
        this.assertFunction("100000000017 - 37", (Type)BigintType.BIGINT, 99999999980L);
        this.assertFunction("100000000017 - 100000000017", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testMultiply() {
        this.assertFunction("100000000037 * 37", (Type)BigintType.BIGINT, 3700000001369L);
        this.assertFunction("37 * 100000000017", (Type)BigintType.BIGINT, 3700000000629L);
        this.assertFunction("100000000017 * 37", (Type)BigintType.BIGINT, 3700000000629L);
        this.assertFunction("100000000017 * 10000017", (Type)BigintType.BIGINT, 1000001700170000289L);
    }

    @Test
    public void testDivide() {
        this.assertFunction("100000000037 / 37", (Type)BigintType.BIGINT, 2702702703L);
        this.assertFunction("37 / 100000000017", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("100000000017 / 37", (Type)BigintType.BIGINT, 2702702703L);
        this.assertFunction("100000000017 / 100000000017", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testModulus() {
        this.assertFunction("100000000037 % 37", (Type)BigintType.BIGINT, 26L);
        this.assertFunction("37 % 100000000017", (Type)BigintType.BIGINT, 37L);
        this.assertFunction("100000000017 % 37", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("100000000017 % 100000000017", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(100000000037)", (Type)BigintType.BIGINT, -100000000037L);
        this.assertFunction("-(100000000017)", (Type)BigintType.BIGINT, -100000000017L);
    }

    @Test
    public void testEqual() {
        this.assertFunction("100000000037 = 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37 = 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 = 37", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 = 100000000017", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("100000000037 <> 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 <> 100000000017", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 <> 37", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 <> 100000000017", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("100000000037 < 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000037 < 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 < 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 < 100000000017", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("100000000037 <= 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000037 <= 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 <= 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 <= 100000000017", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("100000000037 > 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000037 > 100000000017", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 > 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 > 100000000017", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("100000000037 >= 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000037 >= 100000000017", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 >= 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 >= 100000000017", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("100000000037 BETWEEN 100000000037 AND 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000037 BETWEEN 100000000037 AND 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000037 BETWEEN 100000000017 AND 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000037 BETWEEN 100000000017 AND 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 BETWEEN 100000000037 AND 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 BETWEEN 100000000037 AND 100000000017", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000017 BETWEEN 100000000017 AND 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000017 BETWEEN 100000000017 AND 100000000017", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(100000000037 as bigint)", (Type)BigintType.BIGINT, 100000000037L);
        this.assertFunction("cast(100000000017 as bigint)", (Type)BigintType.BIGINT, 100000000017L);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(37 as varchar)", (Type)VarcharType.VARCHAR, "37");
        this.assertFunction("cast(100000000017 as varchar)", (Type)VarcharType.VARCHAR, "100000000017");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(37 as double)", (Type)DoubleType.DOUBLE, 37.0);
        this.assertFunction("cast(100000000017 as double)", (Type)DoubleType.DOUBLE, 1.00000000017E11);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast(37 as real)", (Type)RealType.REAL, Float.valueOf(37.0f));
        this.assertFunction("cast(-100000000017 as real)", (Type)RealType.REAL, Float.valueOf(-1.0E11f));
        this.assertFunction("cast(0 as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(37 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(100000000017 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(0 as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('100000000037' as bigint)", (Type)BigintType.BIGINT, 100000000037L);
        this.assertFunction("cast('100000000017' as bigint)", (Type)BigintType.BIGINT, 100000000017L);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS BIGINT) IS DISTINCT FROM CAST(NULL AS BIGINT)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000037 IS DISTINCT FROM 100000000037", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("100000000037 IS DISTINCT FROM 100000000038", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 100000000037", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("100000000037 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testOverflowAdd() {
        this.assertNumericOverflow(String.format("%s + BIGINT '1'", Long.MAX_VALUE), "bigint addition overflow: 9223372036854775807 + 1");
    }

    @Test
    public void testUnderflowSubtract() {
        this.assertNumericOverflow(String.format("%s - 1", Long.MIN_VALUE), "bigint subtraction overflow: -9223372036854775808 - 1");
    }

    @Test
    public void testOverflowMultiply() {
        this.assertNumericOverflow(String.format("%s * BIGINT '2'", Long.MAX_VALUE), "bigint multiplication overflow: 9223372036854775807 * 2");
        this.assertNumericOverflow(String.format("%s * -1", Long.MIN_VALUE), "bigint multiplication overflow: -9223372036854775808 * -1");
    }

    @Test
    public void testOverflowDivide() {
        this.assertNumericOverflow(String.format("%s / -1", Long.MIN_VALUE), "bigint division overflow: -9223372036854775808 / -1");
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as bigint)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1 as bigint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(4499999999 as bigint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "4499999999", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNegateOverflow() {
        this.assertNumericOverflow(String.format("-(%s)", Long.MIN_VALUE), "bigint negation overflow: -9223372036854775808");
    }
}

