/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.type.JsonType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowOperatorsLegacy
extends AbstractTestFunctions {
    public TestRowOperatorsLegacy() {
        super(new FeaturesConfig().setLegacyRowToJsonCast(true));
    }

    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testRowToJson() {
        this.assertFunction("cast(cast (null AS ROW(BIGINT, VARCHAR)) AS JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(ROW(null, null) AS json)", (Type)JsonType.JSON, "[null,null]");
        this.assertFunction("cast(ROW(true, false, null) AS JSON)", (Type)JsonType.JSON, "[true,false,null]");
        this.assertFunction("cast(cast(ROW(12, 12345, 123456789, 1234567890123456789, null, null, null, null) AS ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT)) AS JSON)", (Type)JsonType.JSON, "[12,12345,123456789,1234567890123456789,null,null,null,null]");
        this.assertFunction("CAST(ROW(CAST(3.14E0 AS REAL), 3.1415E0, 1e308, DECIMAL '3.14', DECIMAL '12345678901234567890.123456789012345678', CAST(null AS REAL), CAST(null AS DOUBLE), CAST(null AS DECIMAL)) AS JSON)", (Type)JsonType.JSON, "[3.14,3.1415,1.0E308,3.14,12345678901234567890.123456789012345678,null,null,null]");
        this.assertFunction("CAST(ROW('a', 'bb', CAST(null AS VARCHAR), JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', CAST(null AS JSON)) AS JSON)", (Type)JsonType.JSON, "[\"a\",\"bb\",null,123,3.14,false,\"abc\",[1,\"a\",null],{\"a\":1,\"b\":\"str\",\"c\":null},null,null]");
        this.assertFunction("CAST(ROW(DATE '2001-08-22', DATE '2001-08-23', null) AS JSON)", (Type)JsonType.JSON, "[\"2001-08-22\",\"2001-08-23\",null]");
        this.assertFunction("CAST(ROW(TIMESTAMP '1970-01-01 00:00:01', cast(null AS TIMESTAMP)) AS JSON)", (Type)JsonType.JSON, String.format("[\"%s\",null]", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        this.assertFunction("cast(ROW(ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], CAST(null AS ARRAY(BIGINT))) AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[],[null,null],null]");
        this.assertFunction("cast(ROW(MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), CAST(NULL AS MAP(VARCHAR, BIGINT))) AS JSON)", (Type)JsonType.JSON, "[{\"a\":1,\"b\":2},{\"none\":null,\"three\":3},{},{\"h1\":null,\"h2\":null},null]");
        this.assertFunction("cast(ROW(ROW(1, 2), ROW(3, CAST(null AS INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null) AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[null,null],null]");
        this.assertFunction("CAST(ROW(1, 2) AS JSON)", (Type)JsonType.JSON, "[1,2]");
        this.assertFunction("CAST(CAST(ROW(1, 2) AS ROW(a BIGINT, b BIGINT)) AS JSON)", (Type)JsonType.JSON, "[1,2]");
        this.assertFunction("CAST(ROW(1, NULL) AS JSON)", (Type)JsonType.JSON, "[1,null]");
        this.assertFunction("CAST(ROW(1, CAST(NULL AS INTEGER)) AS JSON)", (Type)JsonType.JSON, "[1,null]");
        this.assertFunction("CAST(ROW(1, 2.0E0) AS JSON)", (Type)JsonType.JSON, "[1,2.0]");
        this.assertFunction("CAST(ROW(1.0E0, 2.5E0) AS JSON)", (Type)JsonType.JSON, "[1.0,2.5]");
        this.assertFunction("CAST(ROW(1.0E0, 'kittens') AS JSON)", (Type)JsonType.JSON, "[1.0,\"kittens\"]");
        this.assertFunction("CAST(ROW(TRUE, FALSE) AS JSON)", (Type)JsonType.JSON, "[true,false]");
        this.assertFunction("CAST(ROW(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) AS JSON)", (Type)JsonType.JSON, "[false,[1,2],{\"1\":2.0,\"3\":4.0}]");
        this.assertFunction("CAST(row(1.0, 123123123456.6549876543) AS JSON)", (Type)JsonType.JSON, "[1.0,123123123456.6549876543]");
    }
}

