/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestSmallintOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)37);
        this.assertFunction("SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)17);
        this.assertInvalidCast("SMALLINT'32768'");
    }

    @Test
    public void testUnaryPlus() {
        this.assertFunction("+SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)37);
        this.assertFunction("+SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)17);
    }

    @Test
    public void testUnaryMinus() {
        this.assertFunction("SMALLINT'-37'", (Type)SmallintType.SMALLINT, (short)-37);
        this.assertFunction("SMALLINT'-17'", (Type)SmallintType.SMALLINT, (short)-17);
        this.assertInvalidFunction("SMALLINT'--32768'", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testAdd() {
        this.assertFunction("SMALLINT'37' + SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)74);
        this.assertFunction("SMALLINT'37' + SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)54);
        this.assertFunction("SMALLINT'17' + SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)54);
        this.assertFunction("SMALLINT'17' + SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)34);
        this.assertNumericOverflow(String.format("SMALLINT'%s' + SMALLINT'1'", (short)Short.MAX_VALUE), "smallint addition overflow: 32767 + 1");
    }

    @Test
    public void testSubtract() {
        this.assertFunction("SMALLINT'37' - SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("SMALLINT'37' - SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)20);
        this.assertFunction("SMALLINT'17' - SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)-20);
        this.assertFunction("SMALLINT'17' - SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)0);
        this.assertNumericOverflow(String.format("SMALLINT'%s' - SMALLINT'1'", (short)Short.MIN_VALUE), "smallint subtraction overflow: -32768 - 1");
    }

    @Test
    public void testMultiply() {
        this.assertFunction("SMALLINT'37' * SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)1369);
        this.assertFunction("SMALLINT'37' * SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)629);
        this.assertFunction("SMALLINT'17' * SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)629);
        this.assertFunction("SMALLINT'17' * SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)289);
        this.assertNumericOverflow(String.format("SMALLINT'%s' * SMALLINT'2'", (short)Short.MAX_VALUE), "smallint multiplication overflow: 32767 * 2");
    }

    @Test
    public void testDivide() {
        this.assertFunction("SMALLINT'37' / SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("SMALLINT'37' / SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)2);
        this.assertFunction("SMALLINT'17' / SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("SMALLINT'17' / SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)1);
        this.assertInvalidFunction("SMALLINT'17' / SMALLINT'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testModulus() {
        this.assertFunction("SMALLINT'37' % SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("SMALLINT'37' % SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("SMALLINT'17' % SMALLINT'37'", (Type)SmallintType.SMALLINT, (short)17);
        this.assertFunction("SMALLINT'17' % SMALLINT'17'", (Type)SmallintType.SMALLINT, (short)0);
        this.assertInvalidFunction("SMALLINT'17' % SMALLINT'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(SMALLINT'37')", (Type)SmallintType.SMALLINT, (short)-37);
        this.assertFunction("-(SMALLINT'17')", (Type)SmallintType.SMALLINT, (short)-17);
        this.assertFunction("-(SMALLINT'32767')", (Type)SmallintType.SMALLINT, (short)-32767);
        this.assertNumericOverflow(String.format("-(SMALLINT'%s')", (short)Short.MIN_VALUE), "smallint negation overflow: -32768");
    }

    @Test
    public void testEqual() {
        this.assertFunction("SMALLINT'37' = SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' = SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' = SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' = SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("SMALLINT'37' <> SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' <> SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' <> SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' <> SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("SMALLINT'37' < SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' < SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' < SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' < SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("SMALLINT'37' <= SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' <= SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' <= SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' <= SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("SMALLINT'37' > SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' > SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' > SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' > SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("SMALLINT'37' >= SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' >= SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' >= SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' >= SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("SMALLINT'37' BETWEEN SMALLINT'37' AND SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' BETWEEN SMALLINT'37' AND SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' BETWEEN SMALLINT'17' AND SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' BETWEEN SMALLINT'17' AND SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' BETWEEN SMALLINT'37' AND SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' BETWEEN SMALLINT'37' AND SMALLINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'17' BETWEEN SMALLINT'17' AND SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'17' BETWEEN SMALLINT'17' AND SMALLINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(SMALLINT'37' as bigint)", (Type)BigintType.BIGINT, 37L);
        this.assertFunction("cast(SMALLINT'17' as bigint)", (Type)BigintType.BIGINT, 17L);
    }

    @Test
    public void testCastToInteger() {
        this.assertFunction("cast(SMALLINT'37' as integer)", (Type)IntegerType.INTEGER, 37);
        this.assertFunction("cast(SMALLINT'17' as integer)", (Type)IntegerType.INTEGER, 17);
    }

    @Test
    public void testCastToTinyint() {
        this.assertFunction("cast(SMALLINT'37' as tinyint)", (Type)TinyintType.TINYINT, (byte)37);
        this.assertFunction("cast(SMALLINT'17' as tinyint)", (Type)TinyintType.TINYINT, (byte)17);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(SMALLINT'37' as varchar)", (Type)VarcharType.VARCHAR, "37");
        this.assertFunction("cast(SMALLINT'17' as varchar)", (Type)VarcharType.VARCHAR, "17");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(SMALLINT'37' as double)", (Type)DoubleType.DOUBLE, 37.0);
        this.assertFunction("cast(SMALLINT'17' as double)", (Type)DoubleType.DOUBLE, 17.0);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast(SMALLINT'37' as real)", (Type)RealType.REAL, Float.valueOf(37.0f));
        this.assertFunction("cast(SMALLINT'-32768' as real)", (Type)RealType.REAL, Float.valueOf(-32768.0f));
        this.assertFunction("cast(SMALLINT'0' as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(SMALLINT'37' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(SMALLINT'17' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(SMALLINT'0' as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('37' as smallint)", (Type)SmallintType.SMALLINT, (short)37);
        this.assertFunction("cast('17' as smallint)", (Type)SmallintType.SMALLINT, (short)17);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS SMALLINT) IS DISTINCT FROM CAST(NULL AS SMALLINT)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' IS DISTINCT FROM SMALLINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("SMALLINT'37' IS DISTINCT FROM SMALLINT'38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM SMALLINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("SMALLINT'37' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as smallint)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(12 as smallint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(0 as smallint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(-23 as smallint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.4 as smallint)", (Type)BooleanType.BOOLEAN, false);
    }
}

