/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingSession;
import io.trino.type.IntervalDayTimeType;
import io.trino.util.DateTimeZoneIndex;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestTime
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    public TestTime() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testSubtract() {
        this.functionAssertions.assertFunctionString("TIME '14:15:16.432' - TIME '03:04:05.321'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "0 11:11:11.111");
        this.functionAssertions.assertFunctionString("TIME '03:04:05.321' - TIME '14:15:16.432'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "-0 11:11:11.111");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.322' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.311' and TIME '03:04:05.312'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.333' and TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIME '03:04:05.321' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05.321");
        this.assertFunction("cast(TIME '03:04:05' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05");
        this.assertFunction("cast(TIME '03:04' as varchar)", (Type)VarcharType.VARCHAR, "03:04:00");
    }

    @Test
    public void testCastFromSlice() {
        this.assertFunction("cast('03:04:05.321' as time) = TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('03:04:05' as time) = TIME '03:04:05.000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('03:04' as time) = TIME '03:04:00.000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as TIME)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "TIME '00:00:00'", (Type)BooleanType.BOOLEAN, false);
    }
}

