/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestTinyintOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("TINYINT'37'", (Type)TinyintType.TINYINT, (byte)37);
        this.assertFunction("TINYINT'17'", (Type)TinyintType.TINYINT, (byte)17);
        this.assertInvalidCast("TINYINT'128'");
    }

    @Test
    public void testUnaryPlus() {
        this.assertFunction("+TINYINT'37'", (Type)TinyintType.TINYINT, (byte)37);
        this.assertFunction("+TINYINT'17'", (Type)TinyintType.TINYINT, (byte)17);
    }

    @Test
    public void testUnaryMinus() {
        this.assertFunction("TINYINT'-37'", (Type)TinyintType.TINYINT, (byte)-37);
        this.assertFunction("TINYINT'-17'", (Type)TinyintType.TINYINT, (byte)-17);
        this.assertInvalidFunction("TINYINT'--128'", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testAdd() {
        this.assertFunction("TINYINT'37' + TINYINT'37'", (Type)TinyintType.TINYINT, (byte)74);
        this.assertFunction("TINYINT'37' + TINYINT'17'", (Type)TinyintType.TINYINT, (byte)54);
        this.assertFunction("TINYINT'17' + TINYINT'37'", (Type)TinyintType.TINYINT, (byte)54);
        this.assertFunction("TINYINT'17' + TINYINT'17'", (Type)TinyintType.TINYINT, (byte)34);
        this.assertNumericOverflow(String.format("TINYINT'%s' + TINYINT'1'", (byte)127), "tinyint addition overflow: 127 + 1");
    }

    @Test
    public void testSubtract() {
        this.assertFunction("TINYINT'37' - TINYINT'37'", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("TINYINT'37' - TINYINT'17'", (Type)TinyintType.TINYINT, (byte)20);
        this.assertFunction("TINYINT'17' - TINYINT'37'", (Type)TinyintType.TINYINT, (byte)-20);
        this.assertFunction("TINYINT'17' - TINYINT'17'", (Type)TinyintType.TINYINT, (byte)0);
        this.assertNumericOverflow(String.format("TINYINT'%s' - TINYINT'1'", (byte)-128), "tinyint subtraction overflow: -128 - 1");
    }

    @Test
    public void testMultiply() {
        this.assertFunction("TINYINT'11' * TINYINT'11'", (Type)TinyintType.TINYINT, (byte)121);
        this.assertFunction("TINYINT'11' * TINYINT'9'", (Type)TinyintType.TINYINT, (byte)99);
        this.assertFunction("TINYINT'9' * TINYINT'11'", (Type)TinyintType.TINYINT, (byte)99);
        this.assertFunction("TINYINT'9' * TINYINT'9'", (Type)TinyintType.TINYINT, (byte)81);
        this.assertNumericOverflow(String.format("TINYINT'%s' * TINYINT'2'", (byte)127), "tinyint multiplication overflow: 127 * 2");
    }

    @Test
    public void testDivide() {
        this.assertFunction("TINYINT'37' / TINYINT'37'", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("TINYINT'37' / TINYINT'17'", (Type)TinyintType.TINYINT, (byte)2);
        this.assertFunction("TINYINT'17' / TINYINT'37'", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("TINYINT'17' / TINYINT'17'", (Type)TinyintType.TINYINT, (byte)1);
        this.assertInvalidFunction("TINYINT'17' / TINYINT'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testModulus() {
        this.assertFunction("TINYINT'37' % TINYINT'37'", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("TINYINT'37' % TINYINT'17'", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("TINYINT'17' % TINYINT'37'", (Type)TinyintType.TINYINT, (byte)17);
        this.assertFunction("TINYINT'17' % TINYINT'17'", (Type)TinyintType.TINYINT, (byte)0);
        this.assertInvalidFunction("TINYINT'17' % TINYINT'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(TINYINT'37')", (Type)TinyintType.TINYINT, (byte)-37);
        this.assertFunction("-(TINYINT'17')", (Type)TinyintType.TINYINT, (byte)-17);
        this.assertFunction("-(TINYINT'127')", (Type)TinyintType.TINYINT, (byte)-127);
        this.assertNumericOverflow(String.format("-(TINYINT'%s')", (byte)-128), "tinyint negation overflow: -128");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TINYINT'37' = TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' = TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' = TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' = TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TINYINT'37' <> TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' <> TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' <> TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' <> TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TINYINT'37' < TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' < TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' < TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' < TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TINYINT'37' <= TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' <= TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' <= TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' <= TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TINYINT'37' > TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' > TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' > TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' > TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TINYINT'37' >= TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' >= TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' >= TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' >= TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TINYINT'37' BETWEEN TINYINT'37' AND TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' BETWEEN TINYINT'37' AND TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' BETWEEN TINYINT'17' AND TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' BETWEEN TINYINT'17' AND TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' BETWEEN TINYINT'37' AND TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' BETWEEN TINYINT'37' AND TINYINT'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'17' BETWEEN TINYINT'17' AND TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'17' BETWEEN TINYINT'17' AND TINYINT'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(TINYINT'37' as bigint)", (Type)BigintType.BIGINT, 37L);
        this.assertFunction("cast(TINYINT'17' as bigint)", (Type)BigintType.BIGINT, 17L);
    }

    @Test
    public void testCastToInteger() {
        this.assertFunction("cast(TINYINT'37' as integer)", (Type)IntegerType.INTEGER, 37);
        this.assertFunction("cast(TINYINT'17' as integer)", (Type)IntegerType.INTEGER, 17);
    }

    @Test
    public void testCastToSmallint() {
        this.assertFunction("cast(TINYINT'37' as smallint)", (Type)SmallintType.SMALLINT, (short)37);
        this.assertFunction("cast(TINYINT'17' as smallint)", (Type)SmallintType.SMALLINT, (short)17);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(TINYINT'37' as varchar)", (Type)VarcharType.VARCHAR, "37");
        this.assertFunction("cast(TINYINT'17' as varchar)", (Type)VarcharType.VARCHAR, "17");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(TINYINT'37' as double)", (Type)DoubleType.DOUBLE, 37.0);
        this.assertFunction("cast(TINYINT'17' as double)", (Type)DoubleType.DOUBLE, 17.0);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast(TINYINT'37' as real)", (Type)RealType.REAL, Float.valueOf(37.0f));
        this.assertFunction("cast(TINYINT'-128' as real)", (Type)RealType.REAL, Float.valueOf(-128.0f));
        this.assertFunction("cast(TINYINT'0' as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(TINYINT'37' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(TINYINT'17' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(TINYINT'0' as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('37' as tinyint)", (Type)TinyintType.TINYINT, (byte)37);
        this.assertFunction("cast('17' as tinyint)", (Type)TinyintType.TINYINT, (byte)17);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS TINYINT) IS DISTINCT FROM CAST(NULL AS TINYINT)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' IS DISTINCT FROM TINYINT'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TINYINT'37' IS DISTINCT FROM TINYINT'38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM TINYINT'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TINYINT'37' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as tinyint)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(12 as tinyint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(0 as tinyint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(-23 as tinyint)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.4 as tinyint)", (Type)BooleanType.BOOLEAN, false);
    }
}

