/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableSet;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.Re2JRegexpType;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeCoercion {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final Type re2jType = this.metadata.getType(Re2JRegexpType.RE2J_REGEXP_SIGNATURE);
    private final TypeCoercion typeCoercion = new TypeCoercion(arg_0 -> ((Metadata)this.metadata).getType(arg_0));

    @Test
    public void testIsTypeOnlyCoercion() {
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)VarcharType.createVarcharType((int)42), (Type)VarcharType.createVarcharType((int)44)));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)VarcharType.createVarcharType((int)44), (Type)VarcharType.createVarcharType((int)42)));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)CharType.createCharType((long)42L), (Type)VarcharType.createVarcharType((int)42)));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)VarcharType.createVarcharType((int)42)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)44))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)VarcharType.createVarcharType((int)44)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)42))));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)DecimalType.createDecimalType((int)23, (int)1)));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1)));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)DecimalType.createDecimalType((int)23, (int)1), (Type)DecimalType.createDecimalType((int)22, (int)1)));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)22, (int)1)));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1))));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)1))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)1))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion((Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion(this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion(this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)23, (int)1))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion(this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)2))));
        Assert.assertTrue((boolean)this.typeCoercion.isTypeOnlyCoercion(this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), this.mapType((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1))));
        Assert.assertFalse((boolean)this.typeCoercion.isTypeOnlyCoercion(this.mapType((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1)), this.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1))));
    }

    private Type mapType(Type keyType, Type valueType) {
        return this.metadata.getType(TypeSignature.mapType((TypeSignature)keyType.getTypeSignature(), (TypeSignature)valueType.getTypeSignature()));
    }

    @Test
    public void testTypeCompatibility() {
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN).hasCommonSuperType((Type)UnknownType.UNKNOWN).canCoerceToEachOther();
        this.assertThat((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceToEachOther();
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.TIMESTAMP_MILLIS).hasCommonSuperType((Type)TimestampType.TIMESTAMP_MILLIS).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimeType.TIME, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).hasCommonSuperType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, this.re2jType).hasCommonSuperType(this.re2jType).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)TinyintType.TINYINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)SmallintType.SMALLINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)IntegerType.INTEGER).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)BigintType.BIGINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).isIncompatible();
        this.assertThat((Type)VarbinaryType.VARBINARY, (Type)VarcharType.VARCHAR).isIncompatible();
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)BigintType.BIGINT)).hasCommonSuperType((Type)new ArrayType((Type)BigintType.BIGINT)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DoubleType.DOUBLE)).hasCommonSuperType((Type)new ArrayType((Type)DoubleType.DOUBLE)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)UnknownType.UNKNOWN)).hasCommonSuperType((Type)new ArrayType((Type)BigintType.BIGINT)).canCoerceSecondToFirstOnly();
        this.assertThat(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).hasCommonSuperType(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).canCoerceToEachOther();
        this.assertThat(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), this.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).hasCommonSuperType(this.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)})).canCoerceToEachOther();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)18, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)19, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)19, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1))).canCoerceSecondToFirstOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).cannotCoerceToEachOther();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)3, (int)2), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)1), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)37), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)3, (int)2), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)37), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)10, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)10, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)10, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)2, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)3, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)9, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)2, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)4, (int)1)).cannotCoerceToEachOther();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)3, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)3, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)4, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)5, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)2, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)9, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)2, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)6, (int)1)).cannotCoerceToEachOther();
        this.assertThat((Type)CharType.createCharType((long)42L), (Type)CharType.createCharType((long)40L)).hasCommonSuperType((Type)CharType.createCharType((long)42L)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((long)42L), (Type)CharType.createCharType((long)44L)).hasCommonSuperType((Type)CharType.createCharType((long)44L)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.createVarcharType((int)42), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)VarcharType.createVarcharType((int)42)).canCoerceToEachOther();
        this.assertThat((Type)VarcharType.createVarcharType((int)42), (Type)VarcharType.createVarcharType((int)44)).hasCommonSuperType((Type)VarcharType.createVarcharType((int)44)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((long)40L), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((long)42L)).cannotCoerceToEachOther();
        this.assertThat((Type)CharType.createCharType((long)42L), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((long)42L)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((long)44L), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((long)44L)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((long)42L), (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((long)42L), (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((long)42L), this.re2jType).hasCommonSuperType(this.re2jType).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)2)}), (Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)5)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)5)})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT)})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)VarcharType.createVarcharType((int)2))})).isIncompatible();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))})).isIncompatible();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)BigintType.BIGINT), RowType.field((String)"d", (Type)VarcharType.createVarcharType((int)2))})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.createVarcharType((int)5)})).cannotCoerceToEachOther();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((Type)VarcharType.createVarcharType((int)5))}))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"d", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"e", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).canCoerceToEachOther();
    }

    @Test
    public void testCoerceTypeBase() {
        Assert.assertEquals((Object)this.typeCoercion.coerceTypeBase((Type)DecimalType.createDecimalType((int)21, (int)1), "decimal"), Optional.of(DecimalType.createDecimalType((int)21, (int)1)));
        Assert.assertEquals((Object)this.typeCoercion.coerceTypeBase((Type)BigintType.BIGINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)19, (int)0)));
        Assert.assertEquals((Object)this.typeCoercion.coerceTypeBase((Type)IntegerType.INTEGER, "decimal"), Optional.of(DecimalType.createDecimalType((int)10, (int)0)));
        Assert.assertEquals((Object)this.typeCoercion.coerceTypeBase((Type)TinyintType.TINYINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)3, (int)0)));
        Assert.assertEquals((Object)this.typeCoercion.coerceTypeBase((Type)SmallintType.SMALLINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)5, (int)0)));
    }

    @Test
    public void testCanCoerceIsTransitive() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type transitiveType : types) {
            for (Type resultType : types) {
                if (!this.typeCoercion.canCoerce(transitiveType, resultType)) continue;
                for (Type sourceType : types) {
                    if (!this.typeCoercion.canCoerce(sourceType, transitiveType) || this.typeCoercion.canCoerce(sourceType, resultType)) continue;
                    Assert.fail((String)String.format("'%s' -> '%s' coercion is missing when transitive coercion is possible: '%s' -> '%s' -> '%s'", sourceType, resultType, sourceType, transitiveType, resultType));
                }
            }
        }
    }

    @Test
    public void testCastOperatorsExistForCoercions() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type sourceType : types) {
            for (Type resultType : types) {
                if (!this.typeCoercion.canCoerce(sourceType, resultType) || sourceType == UnknownType.UNKNOWN || resultType == UnknownType.UNKNOWN) continue;
                try {
                    this.metadata.getCoercion(sourceType, resultType);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("'%s' -> '%s' coercion exists but there is no cast operator", sourceType, resultType), (Throwable)e);
                }
            }
        }
    }

    private Set<Type> getStandardPrimitiveTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.metadata.getTypes());
        builder.add((Object)DecimalType.createDecimalType((int)1, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)17));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)38));
        builder.add((Object)VarcharType.createVarcharType((int)0));
        builder.add((Object)VarcharType.createUnboundedVarcharType());
        builder.add((Object)CharType.createCharType((long)0L));
        builder.add((Object)CharType.createCharType((long)42L));
        return builder.build();
    }

    private CompatibilityAssertion assertThat(Type firstType, Type secondType) {
        Optional commonSuperType1 = this.typeCoercion.getCommonSuperType(firstType, secondType);
        Optional commonSuperType2 = this.typeCoercion.getCommonSuperType(secondType, firstType);
        Assert.assertEquals((Object)commonSuperType1, (Object)commonSuperType2, (String)"Expected getCommonSuperType to return the same result when invoked in either order");
        boolean canCoerceFirstToSecond = this.typeCoercion.canCoerce(firstType, secondType);
        boolean canCoerceSecondToFirst = this.typeCoercion.canCoerce(secondType, firstType);
        return new CompatibilityAssertion(commonSuperType1, canCoerceFirstToSecond, canCoerceSecondToFirst);
    }

    private static class CompatibilityAssertion {
        private final Optional<Type> commonSuperType;
        private final boolean canCoerceFirstToSecond;
        private final boolean canCoerceSecondToFirst;

        public CompatibilityAssertion(Optional<Type> commonSuperType, boolean canCoerceFirstToSecond, boolean canCoerceSecondToFirst) {
            this.commonSuperType = Objects.requireNonNull(commonSuperType, "commonSuperType is null");
            Assert.assertTrue((!canCoerceFirstToSecond && !canCoerceSecondToFirst || commonSuperType.isPresent() ? 1 : 0) != 0, (String)"Expected canCoercion to be false when there is no commonSuperType");
            this.canCoerceFirstToSecond = canCoerceFirstToSecond;
            this.canCoerceSecondToFirst = canCoerceSecondToFirst;
        }

        public void isIncompatible() {
            Assert.assertTrue((boolean)this.commonSuperType.isEmpty(), (String)"Expected to be incompatible");
        }

        public CompatibilityAssertion hasCommonSuperType(Type expected) {
            Assert.assertTrue((boolean)this.commonSuperType.isPresent(), (String)"Expected commonSuperType to be present");
            Assert.assertEquals((Object)this.commonSuperType.get(), (Object)expected, (String)"commonSuperType");
            return this;
        }

        public CompatibilityAssertion canCoerceToEachOther() {
            Assert.assertTrue((boolean)this.canCoerceFirstToSecond, (String)"Expected first be coercible to second");
            Assert.assertTrue((boolean)this.canCoerceSecondToFirst, (String)"Expected second be coercible to first");
            return this;
        }

        public CompatibilityAssertion canCoerceFirstToSecondOnly() {
            Assert.assertTrue((boolean)this.canCoerceFirstToSecond, (String)"Expected first be coercible to second");
            Assert.assertFalse((boolean)this.canCoerceSecondToFirst, (String)"Expected second NOT be coercible to first");
            return this;
        }

        public CompatibilityAssertion canCoerceSecondToFirstOnly() {
            Assert.assertFalse((boolean)this.canCoerceFirstToSecond, (String)"Expected first NOT be coercible to second");
            Assert.assertTrue((boolean)this.canCoerceSecondToFirst, (String)"Expected second be coercible to first");
            return this;
        }

        public CompatibilityAssertion cannotCoerceToEachOther() {
            Assert.assertFalse((boolean)this.canCoerceFirstToSecond, (String)"Expected first NOT be coercible to second");
            Assert.assertFalse((boolean)this.canCoerceSecondToFirst, (String)"Expected second NOT be coercible to first");
            return this;
        }
    }
}

