/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTypeRegistry {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testNonexistentType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.metadata.getType(new TypeSignature("not a real type", new TypeSignatureParameter[0]))).isInstanceOf(TypeNotFoundException.class)).hasMessage("Unknown type: not a real type");
    }

    @Test
    public void testOperatorsImplemented() {
        for (Type type : this.metadata.getTypes()) {
            if (type.isComparable()) {
                this.metadata.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
                this.metadata.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List)ImmutableList.of((Object)type, (Object)type));
                this.metadata.resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)type));
            }
            if (!type.isOrderable()) continue;
            this.metadata.resolveOperator(OperatorType.LESS_THAN, (List)ImmutableList.of((Object)type, (Object)type));
            this.metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
        }
    }
}

