/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.type.UuidOperators;
import io.trino.type.UuidType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUuidOperators
extends AbstractTestFunctions {
    @Test
    public void testRandomUuid() {
        this.tryEvaluateWithAll("uuid()", (Type)UuidType.UUID);
    }

    @Test
    public void testVarcharToUUIDCast() {
        this.assertFunction("CAST('00000000-0000-0000-0000-000000000000' AS UUID)", (Type)UuidType.UUID, "00000000-0000-0000-0000-000000000000");
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertFunction("CAST('300433ad-b0a1-3b53-a977-91cab582458e' AS UUID)", (Type)UuidType.UUID, "300433ad-b0a1-3b53-a977-91cab582458e");
        this.assertFunction("CAST('d3074e99-de12-4b8c-a2a1-b7faf79faba6' AS UUID)", (Type)UuidType.UUID, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        this.assertFunction("CAST('dfa7eaf8-6a26-5749-8d36-336025df74e8' AS UUID)", (Type)UuidType.UUID, "dfa7eaf8-6a26-5749-8d36-336025df74e8");
        this.assertFunction("CAST('12151FD2-7586-11E9-8F9E-2A86E4085A59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertInvalidCast("CAST('1-2-3-4-1' AS UUID)", "Invalid UUID string length: 9");
        this.assertInvalidCast("CAST('12151fd217586211e938f9e42a86e4085a59' AS UUID)", "Cannot cast value to UUID: 12151fd217586211e938f9e42a86e4085a59");
    }

    @Test
    public void testUUIDToVarcharCast() {
        this.assertFunction("CAST(UUID 'd3074e99-de12-4b8c-a2a1-b7faf79faba6' AS VARCHAR)", (Type)VarcharType.VARCHAR, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        this.assertFunction("CAST(CAST('d3074e99-de12-4b8c-a2a1-b7faf79faba6' AS UUID) AS VARCHAR)", (Type)VarcharType.VARCHAR, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
    }

    @Test
    public void testVarbinaryToUUIDCast() {
        this.assertFunction("CAST(x'00000000000000000000000000000000' AS UUID)", (Type)UuidType.UUID, "00000000-0000-0000-0000-000000000000");
        this.assertFunction("CAST(x'12151fd2758611e98f9e2a86e4085a59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertFunction("CAST(x'300433adb0a13b53a97791cab582458e' AS UUID)", (Type)UuidType.UUID, "300433ad-b0a1-3b53-a977-91cab582458e");
        this.assertFunction("CAST(x'd3074e99de124b8ca2a1b7faf79faba6' AS UUID)", (Type)UuidType.UUID, "d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        this.assertFunction("CAST(x'dfa7eaf86a2657498d36336025df74e8' AS UUID)", (Type)UuidType.UUID, "dfa7eaf8-6a26-5749-8d36-336025df74e8");
        this.assertFunction("CAST(x'12151fd2758611e98f9e2a86e4085a59' AS UUID)", (Type)UuidType.UUID, "12151fd2-7586-11e9-8f9e-2a86e4085a59");
        this.assertInvalidCast("CAST(x'f000001100' AS UUID)", "Invalid UUID binary length: 5");
    }

    @Test
    public void testUUIDToVarbinaryCast() {
        this.assertFunction("CAST(UUID '00000000-0000-0000-0000-000000000000' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000000000000000000000000000"));
        this.assertFunction("CAST(UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"6B5F5B6567E443B08EE3586CD49F58A0"));
    }

    @Test
    public void testEquals() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' = UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID) = CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS UUID) IS DISTINCT FROM CAST(NULL AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' IS DISTINCT FROM CAST(NULL AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS UUID) IS DISTINCT FROM UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' != UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID) != UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testOrderOperators() {
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a58' AS UUID) < CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS UUID) < CAST('12151fd2-7586-11e9-8f9e-2a86e4085a58' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('12151fd2-7586-11e9-8f9e-2a86e4085a58' AS UUID) < CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID) < CAST('12151fd2-7586-11e9-8f9e-2a86e4085a58' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('dfa7eaf8-6a26-5749-8d36-336025df74e8' AS UUID) > CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AS UUID) > CAST('dfa7eaf8-6a26-5749-8d36-336025df74e8' AS UUID)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52' BETWEEN UUID '12151fd2-7586-11e9-8f9e-2a86e4085a50' AND UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52' BETWEEN UUID '12151fd2-7586-11e9-8f9e-2a86e4085a54' AND UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' BETWEEN UUID '12151fd2-7586-11e9-8f9e-2a86e4085a50' AND UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52' BETWEEN UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0' AND UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((int)this.uuidCompare("12151fd2-7586-11e9-8f9e-2a86e4085a58", "12151fd2-7586-11e9-8f9e-2a86e4085a59"), (int)-1);
        Assert.assertEquals((int)this.uuidCompare("12151fd2-7586-11e9-8f9e-2a86e4085a58", "12151fd2-7586-11e9-8f9e-2a86e4085a58"), (int)0);
        Assert.assertEquals((int)this.uuidCompare("dfa7eaf8-6a26-5749-8d36-336025df74e8", "6b5f5b65-67e4-43b0-8ee3-586cd49f58a0"), (int)1);
        Assert.assertEquals((int)this.uuidCompare("12151fd2-7586-11e9-8f9e-2a86e4085a58", "dfa7eaf8-6a26-5749-8d36-336025df74e8"), (int)-1);
    }

    private int uuidCompare(String uuidLeft, String uuidRight) {
        return (int)this.functionAssertions.getBlockTypeOperators().getComparisonOperator((Type)UuidType.UUID).compare(TestUuidOperators.uuidBlock(uuidLeft), 0, TestUuidOperators.uuidBlock(uuidRight), 0);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "CAST(null AS UUID)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testHash() {
        this.assertOperator(OperatorType.HASH_CODE, "CAST(null AS UUID)", (Type)BigintType.BIGINT, null);
        this.assertOperator(OperatorType.HASH_CODE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", (Type)BigintType.BIGINT, this.hashFromType("12151fd2-7586-11e9-8f9e-2a86e4085a59"));
    }

    private long hashFromType(String uuidString) {
        return this.functionAssertions.getBlockTypeOperators().getHashCodeOperator((Type)UuidType.UUID).hashCode(TestUuidOperators.uuidBlock(uuidString), 0);
    }

    private static Block uuidBlock(String uuidString) {
        BlockBuilder blockBuilder = UuidType.UUID.createBlockBuilder(null, 1);
        UuidType.UUID.writeSlice(blockBuilder, UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)uuidString)));
        return blockBuilder.build();
    }
}

