/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.dispatcher.DispatchInfo;
import io.trino.dispatcher.DispatchQuery;
import io.trino.dispatcher.LocalCoordinatorLocation;
import io.trino.event.QueryMonitor;
import io.trino.execution.ClusterSizeMonitor;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.StateMachine;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.util.Failures;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class LocalDispatchQuery
implements DispatchQuery {
    private static final Logger log = Logger.get(LocalDispatchQuery.class);
    private final QueryStateMachine stateMachine;
    private final ListenableFuture<QueryExecution> queryExecutionFuture;
    private final QueryMonitor queryMonitor;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Executor queryExecutor;
    private final Consumer<QueryExecution> querySubmitter;
    private final SettableFuture<?> submitted = SettableFuture.create();
    private final AtomicBoolean notificationSentOrGuaranteed = new AtomicBoolean();

    public LocalDispatchQuery(QueryStateMachine stateMachine, ListenableFuture<QueryExecution> queryExecutionFuture, QueryMonitor queryMonitor, ClusterSizeMonitor clusterSizeMonitor, Executor queryExecutor, Consumer<QueryExecution> querySubmitter) {
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.queryExecutionFuture = Objects.requireNonNull(queryExecutionFuture, "queryExecutionFuture is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
        this.querySubmitter = Objects.requireNonNull(querySubmitter, "querySubmitter is null");
        MoreFutures.addExceptionCallback(queryExecutionFuture, throwable -> {
            if (!stateMachine.isDone()) {
                stateMachine.transitionToFailed((Throwable)throwable);
            }
        });
        stateMachine.addStateChangeListener(state -> {
            if (state == QueryState.FAILED && this.notificationSentOrGuaranteed.compareAndSet(false, true)) {
                queryMonitor.queryImmediateFailureEvent(this.getBasicQueryInfo(), this.getFullQueryInfo().getFailureInfo());
            }
            if (state.isDone()) {
                this.submitted.set(null);
                queryExecutionFuture.cancel(true);
            }
        });
    }

    @Override
    public void startWaitingForResources() {
        if (this.stateMachine.transitionToWaitingForResources()) {
            this.waitForMinimumWorkers();
        }
    }

    private void waitForMinimumWorkers() {
        MoreFutures.addSuccessCallback(this.queryExecutionFuture, queryExecution -> {
            Session session = this.stateMachine.getSession();
            int executionMinCount = 1;
            if (queryExecution.shouldWaitForMinWorkers()) {
                executionMinCount = SystemSessionProperties.getRequiredWorkers(session);
            }
            ListenableFuture<?> minimumWorkerFuture = this.clusterSizeMonitor.waitForMinimumWorkers(executionMinCount, SystemSessionProperties.getRequiredWorkersMaxWait(session));
            MoreFutures.addSuccessCallback(minimumWorkerFuture, () -> this.startExecution((QueryExecution)queryExecution));
            MoreFutures.addExceptionCallback(minimumWorkerFuture, throwable -> this.queryExecutor.execute(() -> this.stateMachine.transitionToFailed((Throwable)throwable)));
            this.stateMachine.addStateChangeListener(state -> {
                if (state.isDone()) {
                    minimumWorkerFuture.cancel(true);
                }
            });
        });
    }

    private void startExecution(QueryExecution queryExecution) {
        this.queryExecutor.execute(() -> {
            if (this.stateMachine.transitionToDispatching()) {
                try {
                    this.querySubmitter.accept(queryExecution);
                    if (this.notificationSentOrGuaranteed.compareAndSet(false, true)) {
                        queryExecution.addFinalQueryInfoListener(this.queryMonitor::queryCompletedEvent);
                    }
                }
                catch (Throwable t) {
                    this.stateMachine.transitionToFailed(t);
                    log.error(t, "query submitter threw exception");
                    throw t;
                }
                finally {
                    this.submitted.set(null);
                }
            }
        });
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.nonCancellationPropagating(this.submitted);
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        boolean dispatched = this.submitted.isDone();
        BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
        if (queryInfo.getState() == QueryState.FAILED) {
            ExecutionFailureInfo failureInfo = this.stateMachine.getFailureInfo().orElseGet(() -> Failures.toFailure(new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query failed for an unknown reason")));
            return DispatchInfo.failed(failureInfo, queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        if (dispatched) {
            return DispatchInfo.dispatched(new LocalCoordinatorLocation(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        return DispatchInfo.queued(queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public boolean isDone() {
        return this.stateMachine.getQueryState().isDone();
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public Optional<Duration> getPlanningTime() {
        return this.stateMachine.getPlanningTime();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalCpuTime).orElseGet(() -> new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalMemoryReservation).orElseGet(() -> DataSize.ofBytes((long)0L));
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getUserMemoryReservation).orElseGet(() -> DataSize.ofBytes((long)0L));
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.tryGetQueryExecution().map(QueryExecution::getBasicQueryInfo).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public QueryInfo getFullQueryInfo() {
        return this.tryGetQueryExecution().map(QueryExecution::getQueryInfo).orElseGet(() -> this.stateMachine.updateQueryInfo(Optional.empty()));
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void fail(Throwable throwable) {
        this.stateMachine.transitionToFailed(throwable);
    }

    @Override
    public void cancel() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    private Optional<QueryExecution> tryGetQueryExecution() {
        try {
            return MoreFutures.tryGetFutureValue(this.queryExecutionFuture);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
        catch (Error e) {
            log.error((Throwable)e, "Unhandled Error stored in queryExecutionFuture");
            return Optional.empty();
        }
    }
}

