/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Expression;
import io.trino.transaction.TransactionManager;
import java.util.List;

public class DeallocateTask
implements DataDefinitionTask<Deallocate> {
    @Override
    public String getName() {
        return "DEALLOCATE";
    }

    @Override
    public ListenableFuture<?> execute(Deallocate statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        String statementName = statement.getName().getValue();
        stateMachine.removePreparedStatement(statementName);
        return Futures.immediateFuture(null);
    }
}

