/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class DropColumnTask
implements DataDefinitionTask<DropColumn> {
    @Override
    public String getName() {
        return "DROP COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(DropColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandleOptional = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable()));
        if (tableHandleOptional.isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateFuture(null);
        }
        TableHandle tableHandle = tableHandleOptional.get();
        String column = statement.getColumn().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanDropColumn(session.toSecurityContext(), tableName);
        ColumnHandle columnHandle = metadata.getColumnHandles(session, tableHandle).get(column);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", column);
            }
            return Futures.immediateFuture(null);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop hidden column", new Object[0]);
        }
        if (metadata.getTableMetadata(session, tableHandle).getColumns().stream().filter(info -> !info.isHidden()).count() <= 1L) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop the only column in a table", new Object[0]);
        }
        metadata.dropColumn(session, tableHandle, columnHandle);
        return Futures.immediateFuture(null);
    }
}

