/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DropRoleTask
implements DataDefinitionTask<DropRole> {
    @Override
    public String getName() {
        return "DROP ROLE";
    }

    @Override
    public ListenableFuture<?> execute(DropRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanDropRole(session.toSecurityContext(), role, catalog);
        Set<String> existingRoles = metadata.listRoles(session, catalog);
        if (!existingRoles.contains(role)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", role);
        }
        metadata.dropRole(session, role, catalog);
        return Futures.immediateFuture(null);
    }
}

