/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class StartTransactionTask
implements DataDefinitionTask<StartTransaction> {
    @Override
    public String getName() {
        return "START TRANSACTION";
    }

    @Override
    public ListenableFuture<?> execute(StartTransaction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (!session.isClientTransactionSupport()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INCOMPATIBLE_CLIENT, "Client does not support transactions");
        }
        if (session.getTransactionId().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Nested transactions not supported");
        }
        Optional<IsolationLevel> isolationLevel = StartTransactionTask.extractIsolationLevel(statement);
        Optional<Boolean> readOnly = StartTransactionTask.extractReadOnly(statement);
        TransactionId transactionId = transactionManager.beginTransaction(isolationLevel.orElse(TransactionManager.DEFAULT_ISOLATION), readOnly.orElse(false), false);
        stateMachine.setStartedTransactionId(transactionId);
        transactionManager.trySetInactive(transactionId);
        return Futures.immediateFuture(null);
    }

    private static Optional<IsolationLevel> extractIsolationLevel(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).count() > 1L) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, (Node)startTransaction, "Multiple transaction isolation levels specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).map(Isolation.class::cast).map(Isolation::getLevel).map(StartTransactionTask::convertLevel).findFirst();
    }

    private static Optional<Boolean> extractReadOnly(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).count() > 1L) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, (Node)startTransaction, "Multiple transaction read modes specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).map(TransactionAccessMode.class::cast).map(TransactionAccessMode::isReadOnly).findFirst();
    }

    private static IsolationLevel convertLevel(Isolation.Level level) {
        switch (level) {
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
            case REPEATABLE_READ: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + level));
    }
}

