/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.OutputBufferManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class BroadcastOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.BROADCAST);

    public BroadcastOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
        outputBufferTarget.accept(this.outputBuffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputBuffers(List<OutputBuffers.OutputBufferId> newBuffers, boolean noMoreBuffers) {
        OutputBuffers newOutputBuffers;
        BroadcastOutputBufferManager broadcastOutputBufferManager = this;
        synchronized (broadcastOutputBufferManager) {
            if (this.outputBuffers.isNoMoreBufferIds()) {
                return;
            }
            OutputBuffers originalOutputBuffers = this.outputBuffers;
            for (OutputBuffers.OutputBufferId newBuffer : newBuffers) {
                this.outputBuffers = this.outputBuffers.withBuffer(newBuffer, 0);
            }
            if (noMoreBuffers) {
                this.outputBuffers = this.outputBuffers.withNoMoreBufferIds();
            }
            if (this.outputBuffers == originalOutputBuffers) {
                return;
            }
            newOutputBuffers = this.outputBuffers;
        }
        this.outputBufferTarget.accept(newOutputBuffers);
    }
}

