/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.trino.execution.RemoteTask;
import io.trino.execution.SqlStageExecution;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.metadata.InternalNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class FixedCountScheduler
implements StageScheduler {
    private final TaskScheduler taskScheduler;
    private final List<InternalNode> partitionToNode;

    public FixedCountScheduler(SqlStageExecution stage, List<InternalNode> partitionToNode) {
        Objects.requireNonNull(stage, "stage is null");
        this.taskScheduler = stage::scheduleTask;
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @VisibleForTesting
    public FixedCountScheduler(TaskScheduler taskScheduler, List<InternalNode> partitionToNode) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @Override
    public ScheduleResult schedule() {
        OptionalInt totalPartitions = OptionalInt.of(this.partitionToNode.size());
        List newTasks = (List)IntStream.range(0, this.partitionToNode.size()).mapToObj(partition -> this.taskScheduler.scheduleTask(this.partitionToNode.get(partition), partition, totalPartitions)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        return new ScheduleResult(true, newTasks, 0);
    }

    public static interface TaskScheduler {
        public Optional<RemoteTask> scheduleTask(InternalNode var1, int var2, OptionalInt var3);
    }
}

