/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.memory.MemoryPoolAssignment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MemoryPoolAssignmentsRequest {
    private final String coordinatorId;
    private final long version;
    private final List<MemoryPoolAssignment> assignments;

    @JsonCreator
    public MemoryPoolAssignmentsRequest(@JsonProperty(value="coordinatorId") String coordinatorId, @JsonProperty(value="version") long version, @JsonProperty(value="assignments") List<MemoryPoolAssignment> assignments) {
        this.coordinatorId = Objects.requireNonNull(coordinatorId, "coordinatorId is null");
        this.version = version;
        this.assignments = ImmutableList.copyOf((Collection)Objects.requireNonNull(assignments, "assignments is null"));
    }

    @JsonProperty
    public String getCoordinatorId() {
        return this.coordinatorId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public List<MemoryPoolAssignment> getAssignments() {
        return this.assignments;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("assignments", this.assignments).toString();
    }
}

