/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class GroupByIdBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupByIdBlock.class).instanceSize();
    private final long groupCount;
    private final Block block;

    public GroupByIdBlock(long groupCount, Block block) {
        Objects.requireNonNull(block, "block is null");
        this.groupCount = groupCount;
        this.block = block;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        return BigintType.BIGINT.getLong(this.block, position);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.block.getRegion(positionOffset, length);
    }

    public long getRegionSizeInBytes(int positionOffset, int length) {
        return this.block.getRegionSizeInBytes(positionOffset, length);
    }

    public long getPositionsSizeInBytes(boolean[] positions) {
        return this.block.getPositionsSizeInBytes(positions);
    }

    public Block copyRegion(int positionOffset, int length) {
        return this.block.copyRegion(positionOffset, length);
    }

    public int getSliceLength(int position) {
        return this.block.getSliceLength(position);
    }

    public byte getByte(int position, int offset) {
        return this.block.getByte(position, offset);
    }

    public short getShort(int position, int offset) {
        return this.block.getShort(position, offset);
    }

    public int getInt(int position, int offset) {
        return this.block.getInt(position, offset);
    }

    public long getLong(int position, int offset) {
        return this.block.getLong(position, offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.block.getSlice(position, offset, length);
    }

    public <T> T getObject(int position, Class<T> clazz) {
        return (T)this.block.getObject(position, clazz);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.block.bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.block.bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.block.writeBytesTo(position, offset, length, blockBuilder);
    }

    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.block.writePositionTo(position, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.block.equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    public long hash(int position, int offset, int length) {
        return this.block.hash(position, offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.block.compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        return this.block.getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.block.isNull(position);
    }

    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    public long getSizeInBytes() {
        return this.block.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.block.getRetainedSizeInBytes();
    }

    public long getEstimatedDataSizeForStats(int position) {
        return this.block.getEstimatedDataSizeForStats(position);
    }

    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.block, this.block.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String getEncodingName() {
        throw new UnsupportedOperationException("GroupByIdBlock does not support serialization");
    }

    public Block copyPositions(int[] positions, int offset, int length) {
        return this.block.copyPositions(positions, offset, length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupCount", this.groupCount).add("positionCount", this.getPositionCount()).toString();
    }

    public boolean isLoaded() {
        return this.block.isLoaded();
    }

    public Block getLoadedBlock() {
        return this.block.getLoadedBlock();
    }

    public final List<Block> getChildren() {
        return Collections.singletonList(this.block);
    }
}

