/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.TransformWork;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        this(session, types, channels, hashChannel, 10000, joinCompiler, blockTypeOperators, updateMemory);
    }

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, int expectedDistinctValues, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(types, channels, hashChannel, expectedDistinctValues, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, blockTypeOperators, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Work<Block> markDistinctRows(Page page) {
        return new TransformWork<GroupByIdBlock, Block>(this.groupByHash.getGroupIds(page), ids -> {
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, ids.getPositionCount());
            for (int i = 0; i < ids.getPositionCount(); ++i) {
                if (ids.getGroupId(i) == this.nextDistinctId) {
                    BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
                    ++this.nextDistinctId;
                    continue;
                }
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
            }
            return blockBuilder.build();
        });
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }
}

