/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class TrinoOperatorFactories
implements OperatorFactories {
    @Override
    public OperatorFactory innerJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, boolean outputSingleMatch, boolean waitForBuild, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(TrinoOperatorFactories.rangeList(probeTypes.size())), LookupJoinOperatorFactory.JoinType.INNER, outputSingleMatch, waitForBuild, totalOperatorsCount, partitioningSpillerFactory, blockTypeOperators);
    }

    @Override
    public OperatorFactory probeOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, boolean outputSingleMatch, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(TrinoOperatorFactories.rangeList(probeTypes.size())), LookupJoinOperatorFactory.JoinType.PROBE_OUTER, outputSingleMatch, false, totalOperatorsCount, partitioningSpillerFactory, blockTypeOperators);
    }

    @Override
    public OperatorFactory lookupOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, boolean waitForBuild, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(TrinoOperatorFactories.rangeList(probeTypes.size())), LookupJoinOperatorFactory.JoinType.LOOKUP_OUTER, false, waitForBuild, totalOperatorsCount, partitioningSpillerFactory, blockTypeOperators);
    }

    @Override
    public OperatorFactory fullOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(TrinoOperatorFactories.rangeList(probeTypes.size())), LookupJoinOperatorFactory.JoinType.FULL_OUTER, false, false, totalOperatorsCount, partitioningSpillerFactory, blockTypeOperators);
    }

    private static List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    private OperatorFactory createJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, List<Integer> probeOutputChannels, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        List probeOutputChannelTypes = (List)probeOutputChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
        return new LookupJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactoryManager, probeTypes, probeOutputChannelTypes, lookupSourceFactoryManager.getBuildOutputTypes(), joinType, outputSingleMatch, waitForBuild, new JoinProbe.JoinProbeFactory(probeOutputChannels.stream().mapToInt(i -> i).toArray(), probeJoinChannel, probeHashChannel), blockTypeOperators, totalOperatorsCount, probeJoinChannel, probeHashChannel, partitioningSpillerFactory);
    }
}

