/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.LambdaProvider;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WindowFunctionDefinition {
    private final WindowFunctionSupplier functionSupplier;
    private final Type type;
    private final FrameInfo frameInfo;
    private final List<Integer> argumentChannels;
    private final boolean ignoreNulls;
    private final List<LambdaProvider> lambdaProviders;

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, boolean ignoreNulls, List<LambdaProvider> lambdaProviders, List<Integer> inputs) {
        return new WindowFunctionDefinition(functionSupplier, type, frameInfo, ignoreNulls, lambdaProviders, inputs);
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, boolean ignoreNulls, List<LambdaProvider> lambdaProviders, Integer ... inputs) {
        return WindowFunctionDefinition.window(functionSupplier, type, frameInfo, ignoreNulls, lambdaProviders, Arrays.asList(inputs));
    }

    WindowFunctionDefinition(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, boolean ignoreNulls, List<LambdaProvider> lambdaProviders, List<Integer> argumentChannels) {
        Objects.requireNonNull(functionSupplier, "functionSupplier is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(frameInfo, "frameInfo is null");
        Objects.requireNonNull(lambdaProviders, "lambdaProviders is null");
        Objects.requireNonNull(argumentChannels, "argumentChannels is null");
        this.functionSupplier = functionSupplier;
        this.type = type;
        this.frameInfo = frameInfo;
        this.ignoreNulls = ignoreNulls;
        this.lambdaProviders = lambdaProviders;
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    public Type getType() {
        return this.type;
    }

    public WindowFunction createWindowFunction() {
        return this.functionSupplier.createWindowFunction(this.argumentChannels, this.ignoreNulls, this.lambdaProviders);
    }
}

