/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.slice.Slices;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChecksumAggregationFunction
extends SqlAggregationFunction {
    @VisibleForTesting
    public static final long PRIME64 = -7046029288634856825L;
    private static final String NAME = "checksum";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "output", NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "input", BlockTypeOperators.BlockPositionXxHash64.class, NullableLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ChecksumAggregationFunction.class, "combine", NullableLongState.class, NullableLongState.class);
    private final BlockTypeOperators blockTypeOperators;

    public ChecksumAggregationFunction(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), (List<LongVariableConstraint>)ImmutableList.of(), VarbinaryType.VARBINARY.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(true)), false, true, "Checksum of the given values", FunctionKind.AGGREGATE), true, false);
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        return ImmutableList.of((Object)StateCompiler.getSerializedType(NullableLongState.class).getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type valueType = functionBinding.getTypeVariable("T");
        BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator = this.blockTypeOperators.getXxHash64Operator(valueType);
        return ChecksumAggregationFunction.generateAggregation(valueType, xxHash64Operator);
    }

    private static InternalAggregationFunction generateAggregation(Type type, BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ChecksumAggregationFunction.class.getClassLoader());
        AccumulatorStateSerializer<NullableLongState> stateSerializer = StateCompiler.generateStateSerializer(NullableLongState.class, classLoader);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)type.getTypeSignature())), ChecksumAggregationFunction.createInputParameterMetadata(type), INPUT_FUNCTION.bindTo(xxHash64Operator), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(NullableLongState.class, stateSerializer, StateCompiler.generateStateFactory(NullableLongState.class, classLoader))), (Type)VarbinaryType.VARBINARY);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)type), (List<Type>)ImmutableList.of((Object)stateSerializer.getSerializedType()), (Type)VarbinaryType.VARBINARY, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator, NullableLongState state, Block block, int position) {
        state.setNull(false);
        if (block.isNull(position)) {
            state.setLong(state.getLong() + -7046029288634856825L);
        } else {
            state.setLong(state.getLong() + xxHash64Operator.xxHash64(block, position) * -7046029288634856825L);
        }
    }

    public static void combine(NullableLongState state, NullableLongState otherState) {
        state.setNull(state.isNull() && otherState.isNull());
        state.setLong(state.getLong() + otherState.getLong());
    }

    public static void output(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{state.getLong()}));
        }
    }
}

