/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count_if")
public final class CountIfAggregation {
    private CountIfAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setLong(state.getLong() + 1L);
        }
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setLong(state.getLong() - 1L);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getLong());
    }
}

