/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.NestedLoopJoinBridge;
import io.trino.operator.join.NestedLoopJoinPagesBuilder;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public class NestedLoopBuildOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final NestedLoopJoinBridge nestedLoopJoinBridge;
    private final NestedLoopJoinPagesBuilder nestedLoopJoinPagesBuilder;
    private final LocalMemoryContext localUserMemoryContext;
    private Optional<ListenableFuture<?>> probeDoneWithPages = Optional.empty();

    public NestedLoopBuildOperator(OperatorContext operatorContext, NestedLoopJoinBridge nestedLoopJoinBridge) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinBridge = Objects.requireNonNull(nestedLoopJoinBridge, "nestedLoopJoinBridge is null");
        this.nestedLoopJoinPagesBuilder = new NestedLoopJoinPagesBuilder(operatorContext);
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.probeDoneWithPages.isPresent()) {
            return;
        }
        this.probeDoneWithPages = Optional.of(this.nestedLoopJoinBridge.setPages(this.nestedLoopJoinPagesBuilder.build()));
    }

    @Override
    public boolean isFinished() {
        return this.probeDoneWithPages.map(Future::isDone).orElse(false);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.probeDoneWithPages.orElse(NOT_BLOCKED);
    }

    @Override
    public boolean needsInput() {
        return this.probeDoneWithPages.isEmpty();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.nestedLoopJoinPagesBuilder.addPage(page);
        if (!this.localUserMemoryContext.trySetBytes(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes())) {
            this.nestedLoopJoinPagesBuilder.compact();
            this.localUserMemoryContext.setBytes(this.nestedLoopJoinPagesBuilder.getEstimatedSize().toBytes());
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class NestedLoopBuildOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager;
        private boolean closed;

        public NestedLoopBuildOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.nestedLoopJoinBridgeManager = Objects.requireNonNull(nestedLoopJoinBridgeManager, "nestedLoopJoinBridgeManager is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NestedLoopBuildOperator.class.getSimpleName());
            return new NestedLoopBuildOperator(operatorContext, this.nestedLoopJoinBridgeManager.getJoinBridge(driverContext.getLifespan()));
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopBuildOperatorFactory(this.operatorId, this.planNodeId, this.nestedLoopJoinBridgeManager);
        }
    }
}

