/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PartitionedConsumption<T> {
    private final int consumersCount;
    private final AtomicInteger consumed = new AtomicInteger();
    @Nullable
    private List<Partition<T>> partitions;

    PartitionedConsumption(int consumersCount, Iterable<Integer> partitionNumbers, IntFunction<ListenableFuture<T>> loader, IntConsumer disposer) {
        this(consumersCount, Futures.immediateFuture(null), partitionNumbers, loader, disposer);
    }

    private PartitionedConsumption(int consumersCount, ListenableFuture<?> activator, Iterable<Integer> partitionNumbers, IntFunction<ListenableFuture<T>> loader, IntConsumer disposer) {
        Preconditions.checkArgument((consumersCount > 0 ? 1 : 0) != 0, (Object)"consumersCount must be positive");
        this.consumersCount = consumersCount;
        this.partitions = this.createPartitions(activator, partitionNumbers, loader, disposer);
    }

    private List<Partition<T>> createPartitions(ListenableFuture<?> activator, Iterable<Integer> partitionNumbers, IntFunction<ListenableFuture<T>> loader, IntConsumer disposer) {
        Objects.requireNonNull(partitionNumbers, "partitionNumbers is null");
        Objects.requireNonNull(loader, "loader is null");
        Objects.requireNonNull(disposer, "disposer is null");
        ImmutableList.Builder partitions = ImmutableList.builder();
        ListenableFuture<?> partitionActivator = activator;
        for (Integer partitionNumber : partitionNumbers) {
            Partition<T> partition = new Partition<T>(this.consumersCount, partitionNumber, loader, partitionActivator, disposer);
            partitions.add(partition);
            partitionActivator = partition.released;
        }
        return partitions.build();
    }

    Iterator<Partition<T>> beginConsumption() {
        final ArrayDeque partitions = new ArrayDeque(Objects.requireNonNull(this.partitions, "partitions is already null"));
        if (this.consumed.incrementAndGet() >= this.consumersCount) {
            this.partitions = null;
        }
        return new AbstractIterator<Partition<T>>(){

            protected Partition<T> computeNext() {
                Partition next = (Partition)partitions.poll();
                if (next != null) {
                    return next;
                }
                return (Partition)this.endOfData();
            }
        };
    }

    public static class Partition<T> {
        private final int partitionNumber;
        private final SettableFuture<?> requested;
        private final ListenableFuture<T> loaded;
        private final SettableFuture<?> released;
        @GuardedBy(value="this")
        private int pendingReleases;

        public Partition(int consumersCount, int partitionNumber, IntFunction<ListenableFuture<T>> loader, ListenableFuture<?> previousReleased, IntConsumer disposer) {
            this.partitionNumber = partitionNumber;
            this.requested = SettableFuture.create();
            this.loaded = Futures.transformAsync((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.requested, previousReleased}), ignored -> (ListenableFuture)loader.apply(partitionNumber), (Executor)MoreExecutors.directExecutor());
            this.released = SettableFuture.create();
            this.released.addListener(() -> disposer.accept(partitionNumber), MoreExecutors.directExecutor());
            this.pendingReleases = consumersCount;
        }

        public int number() {
            return this.partitionNumber;
        }

        public ListenableFuture<T> load() {
            this.requested.set(null);
            return this.loaded;
        }

        public synchronized void release() {
            Preconditions.checkState((boolean)this.loaded.isDone());
            --this.pendingReleases;
            Preconditions.checkState((this.pendingReleases >= 0 ? 1 : 0) != 0);
            if (this.pendingReleases == 0) {
                this.released.set(null);
            }
        }
    }
}

