/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import io.trino.operator.CompletedWork;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.util.Objects;

public class InputPageProjection
implements PageProjection {
    private final Type type;
    private final InputChannels inputChannels;

    public InputPageProjection(int inputChannel, Type type) {
        this.type = type;
        this.inputChannels = new InputChannels(inputChannel);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        Block block = Objects.requireNonNull(page, "page is null").getBlock(0);
        Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        block = selectedPositions.isList() ? block.copyPositions(selectedPositions.getPositions(), selectedPositions.getOffset(), selectedPositions.size()) : block.getRegion(selectedPositions.getOffset(), selectedPositions.size());
        return new CompletedWork<Block>(block);
    }
}

