/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import io.trino.operator.project.InputChannels;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;

public interface PageFilter {
    public boolean isDeterministic();

    public InputChannels getInputChannels();

    public SelectedPositions filter(ConnectorSession var1, Page var2);

    public static SelectedPositions positionsArrayToSelectedPositions(boolean[] selectedPositions, int size) {
        int selectedCount = 0;
        for (int i = 0; i < size; ++i) {
            boolean selectedPosition = selectedPositions[i];
            if (!selectedPosition) continue;
            ++selectedCount;
        }
        if (selectedCount == 0 || selectedCount == size) {
            return SelectedPositions.positionsRange(0, selectedCount);
        }
        int[] positions = new int[selectedCount];
        int index = 0;
        for (int position = 0; position < size; ++position) {
            if (!selectedPositions[position]) continue;
            positions[index] = position;
            ++index;
        }
        return SelectedPositions.positionsList(positions, 0, selectedCount);
    }
}

