/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionInvoker;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ChoicesScalarFunctionImplementation
implements ScalarFunctionImplementation {
    private final ScalarFunctionAdapter functionAdapter = new ScalarFunctionAdapter(ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);
    private final FunctionBinding functionBinding;
    private final List<ScalarImplementationChoice> choices;

    public ChoicesScalarFunctionImplementation(FunctionBinding functionBinding, InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, MethodHandle methodHandle) {
        this(functionBinding, returnConvention, argumentConventions, (List<Class<?>>)ImmutableList.of(), methodHandle, Optional.empty());
    }

    public ChoicesScalarFunctionImplementation(FunctionBinding functionBinding, InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this(functionBinding, returnConvention, argumentConventions, (List<Class<?>>)ImmutableList.of(), methodHandle, instanceFactory);
    }

    public ChoicesScalarFunctionImplementation(FunctionBinding functionBinding, InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<Class<?>> lambdaInterfaces, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this(functionBinding, (List<ScalarImplementationChoice>)ImmutableList.of((Object)new ScalarImplementationChoice(returnConvention, argumentConventions, lambdaInterfaces, methodHandle, instanceFactory)));
    }

    public ChoicesScalarFunctionImplementation(FunctionBinding functionBinding, List<ScalarImplementationChoice> choices) {
        this.functionBinding = functionBinding;
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"choices is an empty list");
        this.choices = ImmutableList.copyOf(choices);
    }

    @VisibleForTesting
    public List<ScalarImplementationChoice> getChoices() {
        return this.choices;
    }

    @Override
    public FunctionInvoker getScalarFunctionInvoker(InvocationConvention invocationConvention) {
        ArrayList<ScalarImplementationChoice> choices = new ArrayList<ScalarImplementationChoice>();
        for (ScalarImplementationChoice choice : this.choices) {
            InvocationConvention callingConvention = choice.getInvocationConvention();
            if (!this.functionAdapter.canAdapt(callingConvention, invocationConvention)) continue;
            choices.add(choice);
        }
        if (choices.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function implementation for (%s) cannot be adapted to convention (%s)", this.functionBinding.getBoundSignature(), invocationConvention));
        }
        ScalarImplementationChoice bestChoice = Collections.max(choices, Comparator.comparingInt(ScalarImplementationChoice::getScore));
        MethodHandle methodHandle = this.functionAdapter.adapt(bestChoice.getMethodHandle(), this.functionBinding.getBoundSignature().getArgumentTypes(), bestChoice.getInvocationConvention(), invocationConvention);
        return new FunctionInvoker(methodHandle, bestChoice.getInstanceFactory(), bestChoice.getLambdaInterfaces());
    }

    public static class ScalarImplementationChoice {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> instanceFactory;
        private final InvocationConvention invocationConvention;
        private final List<Class<?>> lambdaInterfaces;
        private final int score;

        public ScalarImplementationChoice(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<Class<?>> lambdaInterfaces, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            if (instanceFactory.isPresent()) {
                TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
                Preconditions.checkArgument((boolean)instanceFactory.get().type().parameterList().isEmpty(), (Object)"instanceFactory should have no parameter");
                Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
            }
            List<Class<?>> parameterList = methodHandle.type().parameterList();
            boolean hasSession = false;
            if (parameterList.contains(ConnectorSession.class)) {
                Preconditions.checkArgument((parameterList.stream().filter(ConnectorSession.class::equals).count() == 1L ? 1 : 0) != 0, (Object)"function implementation should have exactly one ConnectorSession parameter");
                if (instanceFactory.isEmpty()) {
                    Preconditions.checkArgument((parameterList.get(0) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the first argument when instanceFactory is not present");
                } else {
                    Preconditions.checkArgument((parameterList.get(1) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the second argument when instanceFactory is present");
                }
                hasSession = true;
            }
            this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
            this.invocationConvention = new InvocationConvention(argumentConventions, returnConvention, hasSession, instanceFactory.isPresent());
            Preconditions.checkArgument((lambdaInterfaces.size() <= argumentConventions.size() ? 1 : 0) != 0);
            this.score = ScalarImplementationChoice.computeScore(this.invocationConvention);
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getInstanceFactory() {
            return this.instanceFactory;
        }

        public List<Class<?>> getLambdaInterfaces() {
            return this.lambdaInterfaces;
        }

        public InvocationConvention getInvocationConvention() {
            return this.invocationConvention;
        }

        public int getScore() {
            return this.score;
        }

        private static int computeScore(InvocationConvention callingConvention) {
            int score = 0;
            for (InvocationConvention.InvocationArgumentConvention argument : callingConvention.getArgumentConventions()) {
                if (argument == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                    ++score;
                    continue;
                }
                if (argument != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
                score += 1000;
            }
            return score;
        }
    }
}

