/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;

public final class SessionFunctions {
    private SessionFunctions() {
    }

    @ScalarFunction(value="$current_user", hidden=true)
    @Description(value="Current user")
    @SqlType(value="varchar")
    public static Slice currentUser(ConnectorSession session) {
        return Slices.utf8Slice((String)session.getUser());
    }

    @ScalarFunction(value="$current_path", hidden=true)
    @Description(value="Retrieve current path")
    @SqlType(value="varchar")
    public static Slice currentPath(ConnectorSession session) {
        return Slices.utf8Slice((String)((FullConnectorSession)session).getSession().getPath().toString());
    }

    @ScalarFunction(value="$current_catalog", hidden=true)
    @Description(value="Current catalog")
    @SqlType(value="varchar")
    public static Slice currentCatalog(ConnectorSession session) {
        return ((FullConnectorSession)session).getSession().getCatalog().map(Slices::utf8Slice).orElse(null);
    }

    @ScalarFunction(value="$current_schema", hidden=true)
    @Description(value="Current schema")
    @SqlType(value="varchar")
    public static Slice currentSchema(ConnectorSession session) {
        return ((FullConnectorSession)session).getSession().getSchema().map(Slices::utf8Slice).orElse(null);
    }
}

