/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.airlift.slice.Slices;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.PhysicalValuePointer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class LabelEvaluator {
    private final long matchNumber;
    private final int patternStart;
    private final int partitionStart;
    private final int partitionEnd;
    private final List<Evaluation> evaluations;
    private final WindowIndex windowIndex;

    public LabelEvaluator(long matchNumber, int patternStart, int partitionStart, int partitionEnd, List<Evaluation> evaluations, WindowIndex windowIndex) {
        this.matchNumber = matchNumber;
        this.patternStart = patternStart;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.evaluations = Objects.requireNonNull(evaluations, "evaluations is null");
        this.windowIndex = Objects.requireNonNull(windowIndex, "windowIndex is null");
    }

    public int getInputLength() {
        return this.partitionEnd - this.patternStart;
    }

    public boolean isMatchingAtPartitionStart() {
        return this.patternStart == this.partitionStart;
    }

    public boolean evaluateLabel(int label, ArrayView matchedLabels) {
        Evaluation evaluation = this.evaluations.get(label);
        return evaluation.test(label, matchedLabels, this.partitionStart, this.partitionEnd, this.patternStart, this.matchNumber, this.windowIndex);
    }

    public static class EvaluationSupplier {
        private final Supplier<PageProjection> projection;
        private final List<PhysicalValuePointer> expectedLayout;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public EvaluationSupplier(Supplier<PageProjection> projection, List<PhysicalValuePointer> expectedLayout, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Evaluation get() {
            return new Evaluation(this.projection.get(), this.expectedLayout, this.labelNames, this.session);
        }
    }

    public static class Evaluation {
        private final PageProjection projection;
        private final List<PhysicalValuePointer> expectedLayout;
        private final List<String> labelNames;
        private final ConnectorSession session;

        public Evaluation(PageProjection projection, List<PhysicalValuePointer> expectedLayout, List<String> labelNames, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.expectedLayout = Objects.requireNonNull(expectedLayout, "expectedLayout is null");
            this.labelNames = Objects.requireNonNull(labelNames, "labelNames is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public boolean test(int label, ArrayView matchedLabels, int partitionStart, int partitionEnd, int patternStart, long matchNumber, WindowIndex windowIndex) {
            Block[] blocks = new Block[this.expectedLayout.size()];
            for (int i = 0; i < this.expectedLayout.size(); ++i) {
                PhysicalValuePointer pointer = this.expectedLayout.get(i);
                int channel = pointer.getSourceChannel();
                if (channel == -2) {
                    blocks[i] = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)matchNumber);
                    continue;
                }
                int position = pointer.getLogicalIndexNavigation().resolvePosition(matchedLabels, label, partitionStart, partitionEnd, patternStart);
                if (position >= 0) {
                    if (channel == -1) {
                        VarcharType type = VarcharType.VARCHAR;
                        if (position < patternStart || position > patternStart + matchedLabels.length()) {
                            blocks[i] = Utils.nativeValueToBlock((Type)type, null);
                            continue;
                        }
                        if (position == patternStart + matchedLabels.length()) {
                            blocks[i] = Utils.nativeValueToBlock((Type)type, (Object)Slices.utf8Slice((String)this.labelNames.get(label)));
                            continue;
                        }
                        blocks[i] = Utils.nativeValueToBlock((Type)type, (Object)Slices.utf8Slice((String)this.labelNames.get(matchedLabels.get(position - patternStart))));
                        continue;
                    }
                    blocks[i] = windowIndex.getSingleValueBlock(channel, position - partitionStart);
                    continue;
                }
                blocks[i] = Utils.nativeValueToBlock((Type)pointer.getType(), null);
            }
            Page page = new Page(1, blocks);
            Work<Block> work = this.projection.project(this.session, new DriverYieldSignal(), this.projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
            boolean done = false;
            while (!done) {
                done = work.process();
            }
            Block result = work.getResult();
            return BooleanType.BOOLEAN.getBoolean(result, 0);
        }
    }
}

