/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import com.google.common.base.Preconditions;
import io.trino.operator.window.matcher.ArrayView;
import java.util.Objects;
import java.util.Set;

public class LogicalIndexNavigation {
    private final Set<Integer> labels;
    private final boolean last;
    private final boolean running;
    private final int logicalOffset;
    private final int physicalOffset;

    public LogicalIndexNavigation(Set<Integer> labels, boolean last, boolean running, int logicalOffset, int physicalOffset) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.last = last;
        this.running = running;
        Preconditions.checkArgument((logicalOffset >= 0 ? 1 : 0) != 0, (String)"logical offset must be >= 0, actual: ", (int)logicalOffset);
        this.logicalOffset = logicalOffset;
        this.physicalOffset = physicalOffset;
    }

    public int resolvePosition(ArrayView matchedLabels, int newLabel, int partitionStart, int partitionEnd, int patternStart) {
        int relativePosition = this.last ? this.findLastAndBackwards(matchedLabels, newLabel) : this.findFirstAndForward(matchedLabels, newLabel);
        return this.adjustPosition(relativePosition, patternStart, partitionStart, partitionEnd);
    }

    private int findLastAndBackwards(ArrayView matchedLabels, int newLabel) {
        int position = matchedLabels.length();
        int found = 0;
        if (this.labels.isEmpty() || this.labels.contains(newLabel)) {
            ++found;
        }
        while (found <= this.logicalOffset && position > 0) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(--position))) continue;
            ++found;
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }

    private int findFirstAndForward(ArrayView matchedLabels, int newLabel) {
        int position = -1;
        int found = 0;
        while (found <= this.logicalOffset && position < matchedLabels.length() - 1) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(++position))) continue;
            ++found;
        }
        if (found <= this.logicalOffset) {
            ++position;
            if (this.labels.isEmpty() || this.labels.contains(newLabel)) {
                ++found;
            }
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }

    private int adjustPosition(int relativePosition, int patternStart, int partitionStart, int partitionEnd) {
        if (relativePosition == -1) {
            return -1;
        }
        int start = relativePosition + patternStart;
        int target = start + this.physicalOffset;
        if (target < partitionStart || target >= partitionEnd) {
            return -1;
        }
        return target;
    }

    public int resolvePosition(int currentRow, ArrayView matchedLabels, int partitionStart, int partitionEnd, int patternStart) {
        int relativePosition;
        Preconditions.checkArgument((currentRow >= patternStart && currentRow < patternStart + matchedLabels.length() ? 1 : 0) != 0, (Object)"current row is out of bounds of the match");
        if (this.last) {
            int searchStart = this.running ? currentRow - patternStart : matchedLabels.length() - 1;
            relativePosition = this.findLastAndBackwards(searchStart, matchedLabels);
        } else {
            relativePosition = this.findFirstAndForward(matchedLabels);
        }
        return this.adjustPosition(relativePosition, patternStart, partitionStart, partitionEnd);
    }

    private int findLastAndBackwards(int searchStart, ArrayView matchedLabels) {
        int position = searchStart + 1;
        int found = 0;
        while (found <= this.logicalOffset && position > 0) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(--position))) continue;
            ++found;
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }

    private int findFirstAndForward(ArrayView matchedLabels) {
        int position = -1;
        int found = 0;
        while (found <= this.logicalOffset && position < matchedLabels.length() - 1) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(++position))) continue;
            ++found;
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }
}

