/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.reflect.TypeToken;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.SerializedPage;
import io.trino.sql.analyzer.FeaturesConfig;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/X-trino-pages"})
public class PagesResponseWriter
implements MessageBodyWriter<List<SerializedPage>> {
    public static final int SERIALIZED_PAGES_MAGIC = -22745087;
    private static final MediaType TRINO_PAGES_TYPE = MediaType.valueOf((String)"application/X-trino-pages");
    private static final Type LIST_GENERIC_TOKEN;
    private final boolean dataIntegrityVerificationEnabled;

    @Inject
    public PagesResponseWriter(FeaturesConfig featuresConfig) {
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.dataIntegrityVerificationEnabled = featuresConfig.getExchangeDataIntegrityVerification() != FeaturesConfig.DataIntegrityVerification.NONE;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && TypeToken.of((Type)genericType).resolveType(LIST_GENERIC_TOKEN).getRawType().equals(SerializedPage.class) && mediaType.isCompatible(TRINO_PAGES_TYPE);
    }

    public long getSize(List<SerializedPage> serializedPages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<SerializedPage> serializedPages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output) throws IOException, WebApplicationException {
        block2: {
            try {
                OutputStreamSliceOutput sliceOutput = new OutputStreamSliceOutput(output);
                sliceOutput.writeInt(-22745087);
                sliceOutput.writeLong(this.dataIntegrityVerificationEnabled ? PagesSerdeUtil.calculateChecksum(serializedPages) : 81985529216486895L);
                sliceOutput.writeInt(serializedPages.size());
                PagesSerdeUtil.writeSerializedPages((SliceOutput)sliceOutput, serializedPages);
                sliceOutput.flush();
            }
            catch (UncheckedIOException e) {
                if (e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
    }

    static {
        try {
            LIST_GENERIC_TOKEN = List.class.getMethod("get", Integer.TYPE).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

