/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import io.trino.server.ServerConfig;
import io.trino.spi.QueryId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;

public class QueryInfoUrlFactory {
    private final Optional<String> queryInfoUrlTemplate;

    @Inject
    public QueryInfoUrlFactory(ServerConfig serverConfig) {
        this.queryInfoUrlTemplate = serverConfig.getQueryInfoUrlTemplate();
        this.queryInfoUrlTemplate.ifPresent(template -> {
            try {
                new URI(template.replace("${QUERY_ID}", "query_id_value"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid query info URL template: " + template, e);
            }
        });
    }

    public Optional<URI> getQueryInfoUrl(QueryId queryId) {
        return this.queryInfoUrlTemplate.map(template -> template.replace("${QUERY_ID}", queryId.toString())).map(URI::create);
    }
}

