/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.oauth2.ChallengeFailedException;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public interface OAuth2Client {
    public URI getAuthorizationUri(String var1, URI var2, Optional<String> var3);

    public AccessToken getAccessToken(String var1, URI var2) throws ChallengeFailedException;

    public static class AccessToken {
        private final String accessToken;
        private final Optional<Instant> validUntil;
        private final Optional<String> idToken;

        public AccessToken(String accessToken, Optional<Instant> validUntil, Optional<String> idToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken is null");
            this.validUntil = Objects.requireNonNull(validUntil, "validUntil is null");
            this.idToken = Objects.requireNonNull(idToken, "idToken is null");
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Optional<Instant> getValidUntil() {
            return this.validUntil;
        }

        public Optional<String> getIdToken() {
            return this.idToken;
        }
    }
}

