/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.github.scribejava.apis.openid.OpenIdJsonTokenExtractor;
import com.github.scribejava.apis.openid.OpenIdOAuth2AccessToken;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.common.collect.ImmutableMap;
import io.airlift.http.client.HttpClient;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.ForOAuth2;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.ScribeHttpClient;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ScribeJavaOAuth2Client
implements OAuth2Client {
    private final DynamicCallbackOAuth2Service service;
    private final Optional<String> audience;

    @Inject
    public ScribeJavaOAuth2Client(OAuth2Config config, @ForOAuth2 HttpClient httpClient) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        this.service = new DynamicCallbackOAuth2Service(config, httpClient);
        this.audience = config.getAudience();
    }

    @Override
    public URI getAuthorizationUri(String state, URI callbackUri, Optional<String> nonceHash) {
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        parameters.put((Object)"redirect_uri", (Object)callbackUri.toString());
        parameters.put((Object)"state", (Object)state);
        this.audience.ifPresent(audience -> parameters.put((Object)"audience", audience));
        nonceHash.ifPresent(n -> parameters.put((Object)"nonce", n));
        return URI.create(this.service.getAuthorizationUrl((Map)parameters.build()));
    }

    @Override
    public OAuth2Client.AccessToken getAccessToken(String code, URI callbackUri) throws ChallengeFailedException {
        OpenIdOAuth2AccessToken accessToken = (OpenIdOAuth2AccessToken)this.service.getAccessToken(code, callbackUri.toString());
        Optional<Instant> validUntil = Optional.ofNullable(accessToken.getExpiresIn()).map(expiresSeconds -> Instant.now().plusSeconds(expiresSeconds.intValue()));
        Optional<String> idToken = Optional.ofNullable(accessToken.getOpenIdToken());
        return new OAuth2Client.AccessToken(accessToken.getAccessToken(), validUntil, idToken);
    }

    static class DynamicCallbackOAuth2Service
    extends OAuth20Service {
        public DynamicCallbackOAuth2Service(OAuth2Config config, HttpClient httpClient) {
            super((DefaultApi20)new OAuth2Api(config.getTokenUrl(), config.getAuthUrl()), config.getClientId(), config.getClientSecret(), null, String.join((CharSequence)" ", config.getScopes()), "code", null, null, null, (com.github.scribejava.core.httpclient.HttpClient)new ScribeHttpClient(httpClient));
        }

        public OAuth2AccessToken getAccessToken(String code, String callbackUrl) throws ChallengeFailedException {
            try {
                OAuthRequest request = this.createAccessTokenRequest(AccessTokenRequestParams.create((String)code));
                request.addParameter("redirect_uri", callbackUrl);
                return this.sendAccessTokenRequestSync(request);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ChallengeFailedException("Interrupted while fetching access token", e);
            }
            catch (Exception e) {
                throw new ChallengeFailedException("Error while fetching access token", e);
            }
        }

        private static class OAuth2Api
        extends DefaultApi20 {
            private final String accessTokenEndpoint;
            private final String authorizationBaseUrl;

            public OAuth2Api(String accessTokenEndpoint, String authorizationBaseUrl) {
                this.accessTokenEndpoint = Objects.requireNonNull(accessTokenEndpoint, "accessTokenEndpoint is null");
                this.authorizationBaseUrl = Objects.requireNonNull(authorizationBaseUrl, "authorizationBaseUrl is null");
            }

            public String getAccessTokenEndpoint() {
                return this.accessTokenEndpoint;
            }

            protected String getAuthorizationBaseUrl() {
                return this.authorizationBaseUrl;
            }

            public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
                return OpenIdJsonTokenExtractor.instance();
            }
        }
    }
}

