/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.event.client.EventModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import io.trino.connector.CatalogName;
import io.trino.connector.ConnectorManager;
import io.trino.cost.StatsCalculator;
import io.trino.dispatcher.DispatchManager;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.SqlQueryManager;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskManager;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.LocalMemoryManager;
import io.trino.metadata.AllNodes;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlManager;
import io.trino.security.GroupProviderManager;
import io.trino.server.GracefulShutdownHandler;
import io.trino.server.PluginManager;
import io.trino.server.ServerMainModule;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.ShutdownAction;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.ServerSecurityModule;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.SystemAccessControl;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.testing.ProcedureTester;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingWarningCollectorModule;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class TestingTrinoServer
implements Closeable {
    private final Injector injector;
    private final Path baseDataDir;
    private final boolean preserveData;
    private final LifeCycleManager lifeCycleManager;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final TestingHttpServer server;
    private final CatalogManager catalogManager;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final TestingAccessControlManager accessControl;
    private final TestingGroupProvider groupProvider;
    private final ProcedureTester procedureTester;
    private final Optional<InternalResourceGroupManager<?>> resourceGroupManager;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ClusterMemoryManager clusterMemoryManager;
    private final LocalMemoryManager localMemoryManager;
    private final InternalNodeManager nodeManager;
    private final ServiceSelectorManager serviceSelectorManager;
    private final Announcer announcer;
    private final DispatchManager dispatchManager;
    private final SqlQueryManager queryManager;
    private final TaskManager taskManager;
    private final GracefulShutdownHandler gracefulShutdownHandler;
    private final ShutdownAction shutdownAction;
    private final MBeanServer mBeanServer;
    private final boolean coordinator;

    public static TestingTrinoServer create() {
        return TestingTrinoServer.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private TestingTrinoServer(boolean coordinator, Map<String, String> properties, Optional<String> environment, Optional<URI> discoveryUri, Module additionalModule, Optional<Path> baseDataDir, List<SystemAccessControl> systemAccessControls, List<EventListener> eventListeners) {
        this.coordinator = coordinator;
        this.baseDataDir = baseDataDir.orElseGet(TestingTrinoServer::tempDirectory);
        this.preserveData = baseDataDir.isPresent();
        properties = new HashMap<String, String>(properties);
        String coordinatorPort = properties.remove("http-server.http.port");
        if (coordinatorPort == null) {
            coordinatorPort = "0";
        }
        ImmutableMap.Builder serverProperties = ImmutableMap.builder().putAll(properties).put((Object)"coordinator", (Object)String.valueOf(coordinator)).put((Object)"task.concurrency", (Object)"4").put((Object)"task.max-worker-threads", (Object)"4").put((Object)"exchange.client-threads", (Object)"4");
        if (coordinator) {
            serverProperties.put((Object)"failure-detector.enabled", (Object)"false");
        }
        ImmutableList.Builder modules = ImmutableList.builder().add((Object)new TestingNodeModule(environment)).add((Object)new TestingHttpServerModule(Integer.parseInt(coordinator ? coordinatorPort : "0"))).add((Object)new JsonModule()).add((Object)new JaxrsModule()).add((Object)new MBeanModule()).add((Object)new TestingJmxModule()).add((Object)new EventModule()).add((Object)new TraceTokenModule()).add((Object)new ServerSecurityModule()).add((Object)new ServerMainModule("testversion")).add((Object)new TestingWarningCollectorModule()).add(binder -> {
            binder.bind(EventListenerConfig.class).in(Scopes.SINGLETON);
            binder.bind(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(TestingGroupProvider.class).in(Scopes.SINGLETON);
            binder.bind(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControlManager.class).to(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(EventListenerManager.class).to(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(GroupProviderManager.class).in(Scopes.SINGLETON);
            binder.bind(GroupProvider.class).to(TestingGroupProvider.class).in(Scopes.SINGLETON);
            binder.bind(AccessControl.class).to(AccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(ShutdownAction.class).to(TestShutdownAction.class).in(Scopes.SINGLETON);
            binder.bind(GracefulShutdownHandler.class).in(Scopes.SINGLETON);
            binder.bind(ProcedureTester.class).in(Scopes.SINGLETON);
        });
        if (discoveryUri.isPresent()) {
            Objects.requireNonNull(environment, "environment required when discoveryUri is present");
            serverProperties.put((Object)"discovery.uri", (Object)discoveryUri.get().toString());
            modules.add((Object)new DiscoveryModule());
        } else {
            modules.add((Object)new TestingDiscoveryModule());
        }
        modules.add((Object)additionalModule);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        HashMap optionalProperties = new HashMap();
        environment.ifPresent(env -> optionalProperties.put("node.environment", env));
        this.injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties((Map)serverProperties.build()).setOptionalConfigurationProperties(optionalProperties).quiet().initialize();
        ((Announcer)this.injector.getInstance(Announcer.class)).start();
        this.lifeCycleManager = (LifeCycleManager)this.injector.getInstance(LifeCycleManager.class);
        this.pluginManager = (PluginManager)this.injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)this.injector.getInstance(ConnectorManager.class);
        this.server = (TestingHttpServer)this.injector.getInstance(TestingHttpServer.class);
        this.catalogManager = (CatalogManager)this.injector.getInstance(CatalogManager.class);
        this.transactionManager = (TransactionManager)this.injector.getInstance(TransactionManager.class);
        this.metadata = (Metadata)this.injector.getInstance(Metadata.class);
        this.accessControl = (TestingAccessControlManager)this.injector.getInstance(TestingAccessControlManager.class);
        this.groupProvider = (TestingGroupProvider)this.injector.getInstance(TestingGroupProvider.class);
        this.procedureTester = (ProcedureTester)this.injector.getInstance(ProcedureTester.class);
        this.splitManager = (SplitManager)this.injector.getInstance(SplitManager.class);
        this.pageSourceManager = (PageSourceManager)this.injector.getInstance(PageSourceManager.class);
        if (coordinator) {
            this.dispatchManager = (DispatchManager)this.injector.getInstance(DispatchManager.class);
            this.queryManager = (SqlQueryManager)this.injector.getInstance(QueryManager.class);
            this.resourceGroupManager = Optional.of((InternalResourceGroupManager)this.injector.getInstance(InternalResourceGroupManager.class));
            this.sessionPropertyDefaults = (SessionPropertyDefaults)this.injector.getInstance(SessionPropertyDefaults.class);
            this.nodePartitioningManager = (NodePartitioningManager)this.injector.getInstance(NodePartitioningManager.class);
            this.clusterMemoryManager = (ClusterMemoryManager)this.injector.getInstance(ClusterMemoryManager.class);
            this.statsCalculator = (StatsCalculator)this.injector.getInstance(StatsCalculator.class);
            ((CertificateAuthenticatorManager)this.injector.getInstance(CertificateAuthenticatorManager.class)).useDefaultAuthenticator();
        } else {
            this.dispatchManager = null;
            this.queryManager = null;
            this.resourceGroupManager = Optional.empty();
            this.sessionPropertyDefaults = null;
            this.nodePartitioningManager = null;
            this.clusterMemoryManager = null;
            this.statsCalculator = null;
        }
        this.localMemoryManager = (LocalMemoryManager)this.injector.getInstance(LocalMemoryManager.class);
        this.nodeManager = (InternalNodeManager)this.injector.getInstance(InternalNodeManager.class);
        this.serviceSelectorManager = (ServiceSelectorManager)this.injector.getInstance(ServiceSelectorManager.class);
        this.gracefulShutdownHandler = (GracefulShutdownHandler)this.injector.getInstance(GracefulShutdownHandler.class);
        this.taskManager = (TaskManager)this.injector.getInstance(TaskManager.class);
        this.shutdownAction = (ShutdownAction)this.injector.getInstance(ShutdownAction.class);
        this.mBeanServer = (MBeanServer)this.injector.getInstance(MBeanServer.class);
        this.announcer = (Announcer)this.injector.getInstance(Announcer.class);
        this.accessControl.setSystemAccessControls(systemAccessControls);
        EventListenerManager eventListenerManager = (EventListenerManager)this.injector.getInstance(EventListenerManager.class);
        eventListeners.forEach(eventListenerManager::addEventListener);
        this.announcer.forceAnnounce();
        this.refreshNodes();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (Files.isDirectory(this.baseDataDir, new LinkOption[0]) && !this.preserveData) {
                    MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                }
            });
            closer.register(() -> {
                if (this.lifeCycleManager != null) {
                    this.lifeCycleManager.stop();
                }
            });
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin, plugin.getClass()::getClassLoader);
    }

    public DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.queryManager.getQueryPlan(queryId);
    }

    public QueryInfo getFullQueryInfo(QueryId queryId) {
        return this.queryManager.getFullQueryInfo(queryId);
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.queryManager.addFinalQueryInfoListener(queryId, stateChangeListener);
    }

    public CatalogName createCatalog(String catalogName, String connectorName) {
        return this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public CatalogName createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        CatalogName catalog = this.connectorManager.createCatalog(catalogName, connectorName, properties);
        TestingTrinoServer.updateConnectorIdAnnouncement(this.announcer, catalog, this.nodeManager);
        return catalog;
    }

    public Path getBaseDataDir() {
        return this.baseDataDir;
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    public URI getHttpsBaseUrl() {
        return this.server.getHttpServerInfo().getHttpsUri();
    }

    public URI resolve(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    public HostAndPort getAddress() {
        return HostAndPort.fromParts((String)this.getBaseUrl().getHost(), (int)this.getBaseUrl().getPort());
    }

    public HostAndPort getHttpsAddress() {
        URI httpsUri = this.server.getHttpServerInfo().getHttpsUri();
        return HostAndPort.fromParts((String)httpsUri.getHost(), (int)httpsUri.getPort());
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public StatsCalculator getStatsCalculator() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.statsCalculator;
    }

    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public TestingGroupProvider getGroupProvider() {
        return this.groupProvider;
    }

    public ProcedureTester getProcedureTester() {
        return this.procedureTester;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public Optional<InternalResourceGroupManager<?>> getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    public SessionPropertyDefaults getSessionPropertyDefaults() {
        return this.sessionPropertyDefaults;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public LocalMemoryManager getLocalMemoryManager() {
        return this.localMemoryManager;
    }

    public ClusterMemoryManager getClusterMemoryManager() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.clusterMemoryManager;
    }

    public MBeanServer getMbeanServer() {
        return this.mBeanServer;
    }

    public GracefulShutdownHandler getGracefulShutdownHandler() {
        return this.gracefulShutdownHandler;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ShutdownAction getShutdownAction() {
        return this.shutdownAction;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public final AllNodes refreshNodes() {
        this.serviceSelectorManager.forceRefresh();
        this.nodeManager.refreshNodes();
        return this.nodeManager.getAllNodes();
    }

    public void waitForNodeRefresh(Duration timeout) throws InterruptedException, TimeoutException {
        Instant start = Instant.now();
        while (this.refreshNodes().getActiveNodes().size() < 1) {
            if (Duration.between(start, Instant.now()).compareTo(timeout) > 0) {
                throw new TimeoutException("Timed out while waiting for the node to refresh");
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    public Set<InternalNode> getActiveNodesWithConnector(CatalogName catalogName) {
        return this.nodeManager.getActiveConnectorNodes(catalogName);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    private static void updateConnectorIdAnnouncement(Announcer announcer, CatalogName catalogName, InternalNodeManager nodeManager) {
        ServiceAnnouncement announcement = TestingTrinoServer.getTrinoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        String property = Strings.nullToEmpty((String)((String)properties.get("connectorIds")));
        LinkedHashSet<String> connectorIds = new LinkedHashSet<String>(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property));
        connectorIds.add(catalogName.toString());
        properties.put("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
        nodeManager.refreshNodes();
    }

    private static ServiceAnnouncement getTrinoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("trino")) continue;
            return announcement;
        }
        throw new RuntimeException("Trino announcement not found: " + announcements);
    }

    private static Path tempDirectory() {
        try {
            return Files.createTempDirectory("TrinoTest", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Builder {
        private boolean coordinator = true;
        private Map<String, String> properties = ImmutableMap.of();
        private Optional<String> environment = Optional.empty();
        private Optional<URI> discoveryUri = Optional.empty();
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private List<SystemAccessControl> systemAccessControls = ImmutableList.of();
        private List<EventListener> eventListeners = ImmutableList.of();

        public Builder setCoordinator(boolean coordinator) {
            this.coordinator = coordinator;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = Optional.of(environment);
            return this;
        }

        public Builder setDiscoveryUri(URI discoveryUri) {
            this.discoveryUri = Optional.of(discoveryUri);
            return this;
        }

        public Builder setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModule is null");
            return this;
        }

        public Builder setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this;
        }

        public Builder setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
            this.systemAccessControls = ImmutableList.copyOf((Collection)Objects.requireNonNull(systemAccessControls, "systemAccessControls is null"));
            return this;
        }

        public Builder setEventListeners(List<EventListener> eventListeners) {
            this.eventListeners = ImmutableList.copyOf((Collection)Objects.requireNonNull(eventListeners, "eventListeners is null"));
            return this;
        }

        public TestingTrinoServer build() {
            return new TestingTrinoServer(this.coordinator, this.properties, this.environment, this.discoveryUri, this.additionalModule, this.baseDataDir, this.systemAccessControls, this.eventListeners);
        }
    }

    public static class TestShutdownAction
    implements ShutdownAction {
        private final CountDownLatch shutdownCalled = new CountDownLatch(1);
        @GuardedBy(value="this")
        private boolean isWorkerShutdown;

        @Override
        public synchronized void onShutdown() {
            this.isWorkerShutdown = true;
            this.shutdownCalled.countDown();
        }

        public void waitForShutdownComplete(long millis) throws InterruptedException {
            this.shutdownCalled.await(millis, TimeUnit.MILLISECONDS);
        }

        public synchronized boolean isWorkerShutdown() {
            return this.isWorkerShutdown;
        }
    }
}

