/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.QueryManagerConfig;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableLayoutHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.split.BufferingSplitSource;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SplitManager {
    private final ConcurrentMap<CatalogName, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<CatalogName, ConnectorSplitManager>();
    private final int minScheduleSplitBatchSize;
    private final Metadata metadata;

    @Inject
    public SplitManager(QueryManagerConfig config, Metadata metadata) {
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
        this.metadata = metadata;
    }

    public void addConnectorSplitManager(CatalogName catalogName, ConnectorSplitManager connectorSplitManager) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(connectorSplitManager, "connectorSplitManager is null");
        Preconditions.checkState((this.splitManagers.putIfAbsent(catalogName, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeConnectorSplitManager(CatalogName catalogName) {
        this.splitManagers.remove(catalogName);
    }

    public SplitSource getSplits(Session session, TableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        ConnectorSplitSource source;
        CatalogName catalogName = table.getCatalogName();
        ConnectorSplitManager splitManager = this.getConnectorSplitManager(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (this.metadata.usesLegacyTableLayouts(session, table)) {
            ConnectorTableLayoutHandle layout = table.getLayout().orElseGet(() -> this.metadata.getLayout(session, table, Constraint.alwaysTrue(), Optional.empty()).get().getNewTableHandle().getLayout().get());
            source = splitManager.getSplits(table.getTransaction(), connectorSession, layout, splitSchedulingStrategy);
        } else {
            source = splitManager.getSplits(table.getTransaction(), connectorSession, table.getConnectorHandle(), splitSchedulingStrategy, dynamicFilter);
        }
        SplitSource splitSource = new ConnectorAwareSplitSource(catalogName, source);
        if (this.minScheduleSplitBatchSize > 1) {
            splitSource = new BufferingSplitSource(splitSource, this.minScheduleSplitBatchSize);
        }
        return splitSource;
    }

    private ConnectorSplitManager getConnectorSplitManager(CatalogName catalogName) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(catalogName);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object)catalogName);
        return result;
    }
}

