/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.execution.Column;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.NewTableLayout;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableSchema;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.ViewAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCodeSupplier;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParsingUtil;
import io.trino.sql.SqlPath;
import io.trino.sql.analyzer.AggregationAnalyzer;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.OutputColumn;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.ScopeReferenceExtractor;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.WindowFunctionValidator;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Cube;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.ExcludedPattern;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.Rollup;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetOperation;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Use;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;
import io.trino.sql.util.AstUtils;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import io.trino.util.MoreLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StatementAnalyzer {
    private static final Set<String> WINDOW_VALUE_FUNCTIONS = ImmutableSet.of((Object)"lead", (Object)"lag", (Object)"first_value", (Object)"last_value", (Object)"nth_value");
    private final Analysis analysis;
    private final Metadata metadata;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final SqlParser sqlParser;
    private final GroupProvider groupProvider;
    private final AccessControl accessControl;
    private final WarningCollector warningCollector;
    private final CorrelationSupport correlationSupport;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, GroupProvider groupProvider, AccessControl accessControl, Session session, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeCoercion = new TypeCoercion(metadata::getType);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
    }

    public Scope analyze(Node node, Scope outerQueryScope) {
        return this.analyze(node, Optional.of(outerQueryScope));
    }

    public Scope analyze(Node node, Optional<Scope> outerQueryScope) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.empty()).process(node, Optional.empty());
    }

    public Scope analyzeForUpdate(Table table, Optional<Scope> outerQueryScope, UpdateKind updateKind) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.of(updateKind)).process((Node)table, Optional.empty());
    }

    private Session createViewSession(Optional<String> catalog, Optional<String> schema, Identity identity, SqlPath path) {
        return Session.builder(this.metadata.getSessionPropertyManager()).setQueryId(this.session.getQueryId()).setTransactionId(this.session.getTransactionId().orElse(null)).setIdentity(identity).setSource(this.session.getSource().orElse(null)).setCatalog(catalog.orElse(null)).setSchema(schema.orElse(null)).setPath(path).setTimeZoneKey(this.session.getTimeZoneKey()).setLocale(this.session.getLocale()).setRemoteUserAddress(this.session.getRemoteUserAddress().orElse(null)).setUserAgent(this.session.getUserAgent().orElse(null)).setClientInfo(this.session.getClientInfo().orElse(null)).setStart(this.session.getStart()).build();
    }

    private static boolean hasScopeAsLocalParent(Scope root, Scope parent) {
        Scope scope = root;
        while (scope.getLocalParent().isPresent()) {
            if (!(scope = scope.getLocalParent().get()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    private class Visitor
    extends AstVisitor<Scope, Optional<Scope>> {
        private final Optional<Scope> outerQueryScope;
        private final WarningCollector warningCollector;
        private final Optional<UpdateKind> updateKind;

        private Visitor(Optional<Scope> outerQueryScope, WarningCollector warningCollector, Optional<UpdateKind> updateKind) {
            this.outerQueryScope = Objects.requireNonNull(outerQueryScope, "outerQueryScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.updateKind = Objects.requireNonNull(updateKind, "updateKind is null");
        }

        public Scope process(Node node, Optional<Scope> scope) {
            Scope returnScope = (Scope)super.process(node, scope);
            Preconditions.checkState((boolean)returnScope.getOuterQueryParent().equals(this.outerQueryScope), (Object)"result scope should have outer query scope equal with parameter outer query scope");
            if (scope.isPresent()) {
                Preconditions.checkState((boolean)StatementAnalyzer.hasScopeAsLocalParent(returnScope, scope.get()), (Object)"return scope should have context scope as one of its ancestors");
            }
            return returnScope;
        }

        private Scope process(Node node, Scope scope) {
            return this.process(node, Optional.of(scope));
        }

        protected Scope visitNode(Node node, Optional<Scope> context) {
            throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
        }

        protected Scope visitUse(Use node, Optional<Scope> scope) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
        }

        protected Scope visitInsert(Insert insert, Optional<Scope> scope) {
            List insertColumns;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)insert, insert.getTarget());
            if (StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, targetTable).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into materialized views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, targetTable).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
            }
            Scope queryScope = StatementAnalyzer.this.analyze((Node)insert.getQuery(), this.createScope(scope));
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (targetTableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)insert, "Table '%s' does not exist", targetTable);
            }
            StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.toSecurityContext(), targetTable);
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), targetTable).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Insert into table with a row filter is not supported", new Object[0]);
            }
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, targetTableHandle.get());
            List columns = (List)tableSchema.getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
            for (ColumnSchema column2 : columns) {
                if (StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.toSecurityContext(), targetTable, column2.getName(), column2.getType()).isEmpty()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Insert into table with column masks is not supported", new Object[0]);
            }
            List tableColumns = (List)columns.stream().map(ColumnSchema::getName).collect(ImmutableList.toImmutableList());
            Optional<NewTableLayout> newTableLayout = StatementAnalyzer.this.metadata.getInsertLayout(StatementAnalyzer.this.session, targetTableHandle.get());
            newTableLayout.ifPresent(layout -> {
                if (!ImmutableSet.copyOf((Collection)tableColumns).containsAll(layout.getPartitionColumns())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
                }
            });
            if (insert.getColumns().isPresent()) {
                insertColumns = (List)((List)insert.getColumns().get()).stream().map(Identifier::getValue).map(column -> column.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
                HashSet<String> columnNames = new HashSet<String>();
                for (String insertColumn2 : insertColumns) {
                    if (!tableColumns.contains(insertColumn2)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)insert, "Insert column name does not exist in target table: %s", insertColumn2);
                    }
                    if (columnNames.add(insertColumn2)) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", insertColumn2);
                }
            } else {
                insertColumns = tableColumns;
            }
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle.get());
            StatementAnalyzer.this.analysis.setInsert(new Analysis.Insert(targetTableHandle.get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList()), newTableLayout));
            List tableTypes = (List)insertColumns.stream().map(insertColumn -> tableSchema.getColumn((String)insertColumn).getType()).collect(ImmutableList.toImmutableList());
            List queryTypes = (List)queryScope.getRelationType().getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            if (!this.typesMatchForInsert(tableTypes, queryTypes)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)insert, "Insert query has mismatched column types: Table: [%s], Query: [%s]", Joiner.on((String)", ").join((Iterable)tableTypes), Joiner.on((String)", ").join((Iterable)queryTypes));
            }
            Stream columnStream = Streams.zip(insertColumns.stream(), tableTypes.stream().map(Object::toString), Column::new);
            StatementAnalyzer.this.analysis.setUpdateType("INSERT", targetTable, Optional.empty(), Optional.of((List)Streams.zip((Stream)columnStream, queryScope.getRelationType().getVisibleFields().stream(), (column, field) -> new OutputColumn((Column)column, StatementAnalyzer.this.analysis.getSourceColumns((Field)field))).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)insert, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitRefreshMaterializedView(RefreshMaterializedView refreshMaterializedView, Optional<Scope> scope) {
            QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView, refreshMaterializedView.getName());
            Optional<ConnectorMaterializedViewDefinition> optionalView = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, name);
            if (optionalView.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Materialized view '%s' does not exist", name);
            }
            StatementAnalyzer.this.accessControl.checkCanRefreshMaterializedView(StatementAnalyzer.this.session.toSecurityContext(), name);
            Optional<QualifiedName> storageName = this.getMaterializedViewStorageTableName(optionalView.get());
            if (storageName.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Storage Table '%s' for materialized view '%s' does not exist", storageName, name);
            }
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView, storageName.get());
            this.checkStorageTableNotRedirected(targetTable);
            Query query = this.parseView(optionalView.get().getOriginalSql(), name, (Node)refreshMaterializedView);
            Scope queryScope = this.process((Node)query, scope);
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (targetTableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Table '%s' does not exist", targetTable);
            }
            StatementAnalyzer.this.analysis.setSkipMaterializedViewRefresh(StatementAnalyzer.this.metadata.getMaterializedViewFreshness(StatementAnalyzer.this.session, name).isMaterializedViewFresh());
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, targetTableHandle.get());
            List insertColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle.get());
            StatementAnalyzer.this.analysis.setRefreshMaterializedView(new Analysis.RefreshMaterializedViewAnalysis(name, targetTableHandle.get(), query, (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList())));
            List tableTypes = (List)insertColumns.stream().map(insertColumn -> tableMetadata.getColumn((String)insertColumn).getType()).collect(ImmutableList.toImmutableList());
            List queryTypes = (List)queryScope.getRelationType().getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            if (!this.typesMatchForInsert(tableTypes, queryTypes)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)refreshMaterializedView, "Insert query has mismatched column types: Table: [" + Joiner.on((String)", ").join((Iterable)tableTypes) + "], Query: [" + Joiner.on((String)", ").join((Iterable)queryTypes) + "]", new Object[0]);
            }
            Stream columns = Streams.zip(insertColumns.stream(), tableTypes.stream().map(Object::toString), Column::new);
            StatementAnalyzer.this.analysis.setUpdateType("REFRESH MATERIALIZED VIEW", targetTable, Optional.empty(), Optional.of((List)Streams.zip((Stream)columns, queryScope.getRelationType().getVisibleFields().stream(), (column, field) -> new OutputColumn((Column)column, StatementAnalyzer.this.analysis.getSourceColumns((Field)field))).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)refreshMaterializedView, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private boolean typesMatchForInsert(List<Type> tableTypes, List<Type> queryTypes) {
            if (tableTypes.size() != queryTypes.size()) {
                return false;
            }
            for (int i = 0; i < tableTypes.size(); ++i) {
                if (!(this.hasNestedBoundedCharacterType(tableTypes.get(i)) ? !StatementAnalyzer.this.typeCoercion.canCoerce(queryTypes.get(i), tableTypes.get(i)) : !StatementAnalyzer.this.typeCoercion.isCompatible(queryTypes.get(i), tableTypes.get(i)))) continue;
                return false;
            }
            return true;
        }

        private boolean hasNestedBoundedCharacterType(Type type) {
            if (type instanceof ArrayType) {
                return this.hasBoundedCharacterType(((ArrayType)type).getElementType());
            }
            if (type instanceof MapType) {
                return this.hasBoundedCharacterType(((MapType)type).getKeyType()) || this.hasBoundedCharacterType(((MapType)type).getValueType());
            }
            if (type instanceof RowType) {
                for (Type fieldType : type.getTypeParameters()) {
                    if (!this.hasBoundedCharacterType(fieldType)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasBoundedCharacterType(Type type) {
            return type instanceof CharType || type instanceof VarcharType && !((VarcharType)type).isUnbounded() || this.hasNestedBoundedCharacterType(type);
        }

        protected Scope visitDelete(Delete node, Optional<Scope> scope) {
            Table table = node.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
            }
            TableHandle handle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.session.toSecurityContext(), tableName);
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), tableName).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Delete from table with row filter", new Object[0]);
            }
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, handle);
            for (ColumnMetadata tableColumn : tableMetadata.getColumns()) {
                if (StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.toSecurityContext(), tableName, tableColumn.getName(), tableColumn.getType()).isEmpty()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Delete from table with column mask", new Object[0]);
            }
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope tableScope = analyzer.analyzeForUpdate(table, scope, UpdateKind.DELETE);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tableScope, (Expression)where));
            StatementAnalyzer.this.analysis.setUpdateType("DELETE", tableName, Optional.of(table), Optional.empty());
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitAnalyze(Analyze node, Optional<Scope> scope) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getTableName());
            StatementAnalyzer.this.analysis.setUpdateType("ANALYZE", tableName, Optional.empty(), Optional.empty());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Analyzing views is not supported", new Object[0]);
            }
            this.validateProperties(node.getProperties(), scope);
            CatalogName catalogName = StatementAnalyzer.this.metadata.getCatalogHandle(StatementAnalyzer.this.session, tableName.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + tableName.getCatalogName()));
            Map<String, Object> analyzeProperties = StatementAnalyzer.this.metadata.getAnalyzePropertyManager().getProperties(catalogName, catalogName.getCatalogName(), NodeUtils.mapFromProperties(node.getProperties()), StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis.getParameters());
            TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandleForStatisticsCollection(StatementAnalyzer.this.session, tableName, analyzeProperties).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.builder().putAll((Object)tableName, StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle).keySet()).build());
            try {
                StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.toSecurityContext(), tableName);
            }
            catch (AccessDeniedException exception) {
                throw new AccessDeniedException(String.format("Cannot ANALYZE (missing insert privilege) table %s", tableName));
            }
            StatementAnalyzer.this.analysis.setAnalyzeTarget(tableHandle);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateTableAsSelect(CreateTableAsSelect node, Optional<Scope> scope) {
            NewTableLayout layout;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (targetTableHandle.isPresent()) {
                if (node.isNotExists()) {
                    StatementAnalyzer.this.analysis.setCreate(new Analysis.Create(Optional.of(targetTable), Optional.empty(), Optional.empty(), node.isWithData(), true));
                    StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE", targetTable, Optional.empty(), Optional.of(ImmutableList.of()));
                    return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
            }
            this.validateProperties(node.getProperties(), scope);
            StatementAnalyzer.this.accessControl.checkCanCreateTable(StatementAnalyzer.this.session.toSecurityContext(), targetTable);
            Scope queryScope = StatementAnalyzer.this.analyze((Node)node.getQuery(), this.createScope(scope));
            ImmutableList.Builder columns = ImmutableList.builder();
            ImmutableList.Builder outputColumns = ImmutableList.builder();
            if (node.getColumnAliases().isPresent()) {
                this.validateColumnAliases((List)node.getColumnAliases().get(), queryScope.getRelationType().getVisibleFieldCount());
                int aliasPosition = 0;
                for (Field field2 : queryScope.getRelationType().getVisibleFields()) {
                    if (field2.getType().equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown at position %s", queryScope.getRelationType().indexOf(field2) + 1);
                    }
                    String columnName = ((Identifier)((List)node.getColumnAliases().get()).get(aliasPosition)).getValue();
                    columns.add((Object)new ColumnMetadata(columnName, field2.getType()));
                    outputColumns.add((Object)new OutputColumn(new Column(columnName, field2.getType().toString()), StatementAnalyzer.this.analysis.getSourceColumns(field2)));
                    ++aliasPosition;
                }
            } else {
                this.validateColumns((Statement)node, queryScope.getRelationType());
                columns.addAll((Iterable)queryScope.getRelationType().getVisibleFields().stream().map(field -> new ColumnMetadata(field.getName().get(), field.getType())).collect(ImmutableList.toImmutableList()));
                queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).forEach(arg_0 -> ((ImmutableList.Builder)outputColumns).add(arg_0));
            }
            CatalogName catalogName = StatementAnalyzer.this.metadata.getCatalogHandle(StatementAnalyzer.this.session, targetTable.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + targetTable.getCatalogName()));
            Map<String, Object> properties = StatementAnalyzer.this.metadata.getTablePropertyManager().getProperties(catalogName, targetTable.getCatalogName(), NodeUtils.mapFromProperties(node.getProperties()), StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis.getParameters());
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(targetTable.asSchemaTableName(), (List)columns.build(), properties, node.getComment());
            Optional<NewTableLayout> newTableLayout = StatementAnalyzer.this.metadata.getNewTableLayout(StatementAnalyzer.this.session, targetTable.getCatalogName(), tableMetadata);
            Set columnNames = (Set)columns.build().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (newTableLayout.isPresent() && !columnNames.containsAll((layout = newTableLayout.get()).getPartitionColumns())) {
                if (layout.getLayout().getPartitioning().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
                }
                newTableLayout = Optional.empty();
            }
            StatementAnalyzer.this.analysis.setCreate(new Analysis.Create(Optional.of(targetTable), Optional.of(tableMetadata), newTableLayout, node.isWithData(), false));
            StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE", targetTable, Optional.empty(), Optional.of(outputColumns.build()));
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateView(CreateView node, Optional<Scope> scope) {
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.toSecurityContext(), viewName);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            StatementAnalyzer.this.analysis.setUpdateType("CREATE VIEW", viewName, Optional.empty(), Optional.of((List)queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSession(SetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitResetSession(ResetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAddColumn(AddColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateSchema(CreateSchema node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropSchema(DropSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameSchema(RenameSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSchemaAuthorization(SetSchemaAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateTable(CreateTable node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitProperty(Property node, Optional<Scope> scope) {
            ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe()).analyze(node.getValue(), this.createScope(scope));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropTable(DropTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameTable(RenameTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitComment(Comment node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameColumn(RenameColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropColumn(DropColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetTableAuthorization(SetTableAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameView(RenameView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetViewAuthorization(SetViewAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropView(DropView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitStartTransaction(StartTransaction node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCommit(Commit node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRollback(Rollback node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitPrepare(Prepare node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDeallocate(Deallocate node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitExecute(Execute node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitGrant(Grant node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRevoke(Revoke node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCall(Call node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateMaterializedView(CreateMaterializedView node, Optional<Scope> scope) {
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            if (node.isReplace() && node.isNotExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "'CREATE OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together", new Object[0]);
            }
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            StatementAnalyzer.this.accessControl.checkCanCreateMaterializedView(StatementAnalyzer.this.session.toSecurityContext(), viewName);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            StatementAnalyzer.this.analysis.setUpdateType("CREATE MATERIALIZED VIEW", viewName, Optional.empty(), Optional.of((List)queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropMaterializedView(DropMaterializedView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        private void validateProperties(List<Property> properties, Optional<Scope> scope) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Property property : properties) {
                if (propertyNames.add(property.getName().getValue())) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY, (Node)property, "Duplicate property: %s", property.getName().getValue());
            }
            for (Property property : properties) {
                this.process((Node)property, scope);
            }
        }

        private void validateColumns(Statement node, RelationType descriptor) {
            HashSet<String> names = new HashSet<String>();
            for (Field field : descriptor.getVisibleFields()) {
                Optional<String> fieldName = field.getName();
                if (fieldName.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_NAME, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1);
                }
                if (!names.add(fieldName.get())) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName.get());
                }
                if (!field.getType().equals((Object)UnknownType.UNKNOWN)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", fieldName.get());
            }
        }

        private void validateColumnAliases(List<Identifier> columnAliases, int sourceColumnSize) {
            this.validateColumnAliasesCount(columnAliases, sourceColumnSize);
            HashSet<String> names = new HashSet<String>();
            for (Identifier identifier : columnAliases) {
                if (names.contains(identifier.getValue().toLowerCase(Locale.ENGLISH))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)identifier, "Column name '%s' specified more than once", identifier.getValue());
                }
                names.add(identifier.getValue().toLowerCase(Locale.ENGLISH));
            }
        }

        private void validateColumnAliasesCount(List<Identifier> columnAliases, int sourceColumnSize) {
            if (columnAliases.size() != sourceColumnSize) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)columnAliases.get(0), "Column alias list has %s entries but relation has %s columns", columnAliases.size(), sourceColumnSize);
            }
        }

        protected Scope visitExplain(Explain node, Optional<Scope> scope) {
            Preconditions.checkState((boolean)node.isAnalyze(), (Object)"Non analyze explain should be rewritten to Query");
            if (node.getOptions().stream().anyMatch(option -> !option.equals((Object)new ExplainType(ExplainType.Type.DISTRIBUTED)))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "EXPLAIN ANALYZE only supports TYPE DISTRIBUTED option", new Object[0]);
            }
            this.process((Node)node.getStatement(), scope);
            StatementAnalyzer.this.analysis.resetUpdateType();
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("Query Plan", (Type)VarcharType.VARCHAR));
        }

        protected Scope visitQuery(Query node, Optional<Scope> scope) {
            boolean requiresOrderBy;
            Scope withScope = this.analyzeWith(node, scope);
            Scope queryBodyScope = this.process((Node)node.getQueryBody(), withScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            if (node.getOrderBy().isPresent()) {
                orderByExpressions = this.analyzeOrderBy((Node)node, NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()), queryBodyScope);
                if (queryBodyScope.getOuterQueryParent().isPresent() && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy((OrderBy)node.getOrderBy().get());
                    this.warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get(), queryBodyScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit((Node)node.getLimit().get(), queryBodyScope)) && node.getOrderBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)node.getLimit().get(), "FETCH FIRST WITH TIES clause requires ORDER BY", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSelectExpressions((Node)node, (List)this.descriptorToFields(queryBodyScope).stream().map(expression -> new Analysis.SelectExpression((Expression)expression, Optional.empty())).collect(ImmutableList.toImmutableList()));
            Scope queryScope = Scope.builder().withParent(withScope).withRelationType(RelationId.of((Node)node), queryBodyScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, queryScope);
            return queryScope;
        }

        protected Scope visitUnnest(Unnest node, Optional<Scope> scope) {
            ImmutableMap.Builder mappings = ImmutableMap.builder();
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (Expression expression : node.getExpressions()) {
                ArrayList<Field> expressionOutputs = new ArrayList<Field>();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, this.createScope(scope));
                Type expressionType = expressionAnalysis.getType(expression);
                if (expressionType instanceof ArrayType) {
                    Type elementType = ((ArrayType)expressionType).getElementType();
                    if (elementType instanceof RowType) {
                        ((RowType)elementType).getFields().stream().map(field -> Field.newUnqualified(field.getName(), field.getType())).forEach(expressionOutputs::add);
                    } else {
                        expressionOutputs.add(Field.newUnqualified(Optional.empty(), elementType));
                    }
                } else if (expressionType instanceof MapType) {
                    expressionOutputs.add(Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                    expressionOutputs.add(Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                } else {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
                }
                outputFields.addAll(expressionOutputs);
                mappings.put((Object)NodeRef.of((Node)expression), expressionOutputs);
            }
            Optional<Field> ordinalityField = Optional.empty();
            if (node.isWithOrdinality()) {
                ordinalityField = Optional.of(Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
            }
            ordinalityField.ifPresent(arg_0 -> ((ImmutableList.Builder)outputFields).add(arg_0));
            StatementAnalyzer.this.analysis.setUnnest(node, new Analysis.UnnestAnalysis((Map<NodeRef<Expression>, List<Field>>)mappings.build(), ordinalityField));
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        protected Scope visitLateral(Lateral node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        private Optional<QualifiedName> getMaterializedViewStorageTableName(ConnectorMaterializedViewDefinition viewDefinition) {
            if (viewDefinition.getStorageTable().isEmpty()) {
                return Optional.empty();
            }
            CatalogSchemaTableName catalogSchemaTableName = (CatalogSchemaTableName)viewDefinition.getStorageTable().get();
            SchemaTableName schemaTableName = catalogSchemaTableName.getSchemaTableName();
            return Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(catalogSchemaTableName.getCatalogName(), true), (Object)new Identifier(schemaTableName.getSchemaName(), true), (Object)new Identifier(schemaTableName.getTableName(), true))));
        }

        protected Scope visitTable(Table table, Optional<Scope> scope) {
            QualifiedObjectName name;
            Optional<ConnectorMaterializedViewDefinition> optionalMaterializedView;
            if (table.getName().getPrefix().isEmpty()) {
                Optional<WithQuery> withQuery = this.createScope(scope).getNamedQuery(table.getName().getSuffix());
                if (withQuery.isPresent()) {
                    return this.createScopeForCommonTableExpression(table, scope, withQuery.get());
                }
                Optional<Scope> expandableBaseScope = StatementAnalyzer.this.analysis.getExpandableBaseScope((Node)table);
                if (expandableBaseScope.isPresent()) {
                    Scope baseScope = expandableBaseScope.get();
                    Scope resultScope = this.scopeBuilder(scope).withRelationType(baseScope.getRelationId(), baseScope.getRelationType()).build();
                    StatementAnalyzer.this.analysis.setScope((Node)table, resultScope);
                    return resultScope;
                }
            }
            if ((optionalMaterializedView = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName()))).isPresent()) {
                if (StatementAnalyzer.this.metadata.getMaterializedViewFreshness(StatementAnalyzer.this.session, name).isMaterializedViewFresh()) {
                    Optional<QualifiedName> storageName = this.getMaterializedViewStorageTableName(optionalMaterializedView.get());
                    if (storageName.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "Materialized view '%s' is fresh but does not have storage table name", name);
                    }
                    QualifiedObjectName storageTableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, storageName.get());
                    this.checkStorageTableNotRedirected(storageTableName);
                    Optional<TableHandle> tableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, storageTableName);
                    if (tableHandle.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "Storage table '%s' does not exist", storageTableName);
                    }
                    return this.createScopeForMaterializedView(table, name, scope, optionalMaterializedView.get(), tableHandle);
                }
                return this.createScopeForMaterializedView(table, name, scope, optionalMaterializedView.get(), Optional.empty());
            }
            Optional<ConnectorViewDefinition> optionalView = StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, name);
            if (optionalView.isPresent()) {
                StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), name);
                return this.createScopeForView(table, name, scope, optionalView.get());
            }
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, name);
            Optional<TableHandle> tableHandle = redirection.getTableHandle();
            QualifiedObjectName targetTableName = redirection.getRedirectedTableName().orElse(name);
            StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), targetTableName);
            if (tableHandle.isEmpty()) {
                if (StatementAnalyzer.this.metadata.getCatalogHandle(StatementAnalyzer.this.session, targetTableName.getCatalogName()).isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)table, "Catalog '%s' does not exist", targetTableName.getCatalogName());
                }
                if (!StatementAnalyzer.this.metadata.schemaExists(StatementAnalyzer.this.session, new CatalogSchemaName(targetTableName.getCatalogName(), targetTableName.getSchemaName()))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)table, "Schema '%s' does not exist", targetTableName.getSchemaName());
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", targetTableName);
            }
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, tableHandle.get());
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle.get());
            ImmutableList.Builder fields = ImmutableList.builder();
            fields.addAll(this.analyzeTableOutputFields(table, targetTableName, tableSchema, columnHandles));
            if (this.updateKind.isPresent()) {
                ColumnHandle rowIdColumnHandle;
                switch (this.updateKind.get()) {
                    case DELETE: {
                        rowIdColumnHandle = StatementAnalyzer.this.metadata.getDeleteRowIdColumnHandle(StatementAnalyzer.this.session, tableHandle.get());
                        break;
                    }
                    case UPDATE: {
                        List<ColumnMetadata> updatedColumnMetadata = StatementAnalyzer.this.analysis.getUpdatedColumns().orElseThrow(() -> new VerifyException("updated columns not set"));
                        Set updatedColumnNames = (Set)updatedColumnMetadata.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
                        List updatedColumns = (List)columnHandles.entrySet().stream().filter(entry -> updatedColumnNames.contains(entry.getKey())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
                        rowIdColumnHandle = StatementAnalyzer.this.metadata.getUpdateRowIdColumnHandle(StatementAnalyzer.this.session, tableHandle.get(), updatedColumns);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown UpdateKind " + (Object)((Object)this.updateKind.get()));
                    }
                }
                Type type = StatementAnalyzer.this.metadata.getColumnMetadata(StatementAnalyzer.this.session, tableHandle.get(), rowIdColumnHandle).getType();
                Field field = Field.newUnqualified(Optional.empty(), type);
                fields.add((Object)field);
                StatementAnalyzer.this.analysis.setColumn(field, rowIdColumnHandle);
            }
            ImmutableList outputFields = fields.build();
            this.analyzeFiltersAndMasks(table, targetTableName, tableHandle, (List<Field>)outputFields, StatementAnalyzer.this.session.getIdentity().getUser());
            Scope tableScope = this.createAndAssignScope((Node)table, scope, (List<Field>)outputFields);
            if (this.updateKind.isPresent()) {
                FieldReference reference = new FieldReference(outputFields.size() - 1);
                this.analyzeExpression((Expression)reference, tableScope);
                StatementAnalyzer.this.analysis.setRowIdField(table, reference);
            }
            return tableScope;
        }

        private void checkStorageTableNotRedirected(QualifiedObjectName source) {
            StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, source).getRedirectedTableName().ifPresent(name -> {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Redirection of materialized view storage table '%s' to '%s' is not supported", source, name));
            });
        }

        private void analyzeFiltersAndMasks(Table table, QualifiedObjectName name, Optional<TableHandle> tableHandle, List<Field> fields, String authorization) {
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
            ImmutableMap.Builder columnMasks = ImmutableMap.builder();
            for (Field field : fields) {
                List<ViewExpression> masks;
                if (!field.getName().isPresent() || (masks = StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.toSecurityContext(), name, field.getName().get(), field.getType())).isEmpty() || !this.checkCanSelectFromColumn(name, field.getName().orElseThrow())) continue;
                columnMasks.put((Object)field, masks);
                masks.forEach(mask -> this.analyzeColumnMask(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, field, accessControlScope, (ViewExpression)mask));
            }
            List<ViewExpression> filters = StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), name);
            filters.forEach(filter -> this.analyzeRowFilter(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, accessControlScope, (ViewExpression)filter));
            StatementAnalyzer.this.analysis.registerTable(table, tableHandle, name, filters, (Map<Field, List<ViewExpression>>)columnMasks.build(), authorization, accessControlScope);
        }

        private boolean checkCanSelectFromColumn(QualifiedObjectName name, String column) {
            try {
                StatementAnalyzer.this.accessControl.checkCanSelectFromColumns(StatementAnalyzer.this.session.toSecurityContext(), name, (Set<String>)ImmutableSet.of((Object)column));
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        }

        private Scope createScopeForCommonTableExpression(Table table, Optional<Scope> scope, WithQuery withQuery) {
            ImmutableList fields;
            Query query = withQuery.getQuery();
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
            Optional columnNames = withQuery.getColumnNames();
            if (columnNames.isPresent()) {
                Preconditions.checkState((((List)columnNames.get()).size() == queryDescriptor.getVisibleFieldCount() ? 1 : 0) != 0, (Object)"mismatched aliases");
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                Iterator aliases = ((List)columnNames.get()).iterator();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    fieldBuilder.add((Object)Field.newQualified(QualifiedName.of((String)table.getName().getSuffix()), Optional.of(((Identifier)aliases.next()).getValue()), inputField.getType(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased()));
                }
                fields = fieldBuilder.build();
            } else {
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    fieldBuilder.add((Object)Field.newQualified(QualifiedName.of((String)table.getName().getSuffix()), inputField.getName(), inputField.getType(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased()));
                }
                fields = fieldBuilder.build();
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)fields);
        }

        private Scope createScopeForMaterializedView(Table table, QualifiedObjectName name, Optional<Scope> scope, ConnectorMaterializedViewDefinition view, Optional<TableHandle> storageTable) {
            return this.createScopeForView(table, name, scope, view.getOriginalSql(), view.getCatalog(), view.getSchema(), Optional.of(view.getOwner()), this.translateMaterializedViewColumns(view.getColumns()), storageTable);
        }

        private List<ConnectorViewDefinition.ViewColumn> translateMaterializedViewColumns(List<ConnectorMaterializedViewDefinition.Column> materializedViewColumns) {
            ArrayList<ConnectorViewDefinition.ViewColumn> viewColumns = new ArrayList<ConnectorViewDefinition.ViewColumn>();
            for (ConnectorMaterializedViewDefinition.Column column : materializedViewColumns) {
                viewColumns.add(new ConnectorViewDefinition.ViewColumn(column.getName(), column.getType()));
            }
            return viewColumns;
        }

        private Scope createScopeForView(Table table, QualifiedObjectName name, Optional<Scope> scope, ConnectorViewDefinition view) {
            if (!view.isRunAsInvoker() && view.getOwner().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "Owner must be present in view '%s' with SECURITY DEFINER mode", name);
            }
            return this.createScopeForView(table, name, scope, view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getOwner(), view.getColumns(), Optional.empty());
        }

        private Scope createScopeForView(Table table, QualifiedObjectName name, Optional<Scope> scope, String originalSql, Optional<String> catalog, Optional<String> schema, Optional<String> owner, List<ConnectorViewDefinition.ViewColumn> columns, Optional<TableHandle> storageTable) {
            QualifiedObjectName viewNameFromStatement;
            CreateView viewStatement;
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (statement instanceof CreateView) {
                viewStatement = (CreateView)statement;
                viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive view", new Object[0]);
                }
            }
            if (statement instanceof CreateMaterializedView) {
                viewStatement = (CreateMaterializedView)statement;
                viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive materialized view", new Object[0]);
                }
            }
            if (StatementAnalyzer.this.analysis.hasTableInView(table)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "View is recursive", new Object[0]);
            }
            Query query = this.parseView(originalSql, name, (Node)table);
            StatementAnalyzer.this.analysis.registerTableForView(table);
            RelationType descriptor = this.analyzeView(query, name, catalog, schema, owner, table);
            StatementAnalyzer.this.analysis.unregisterTableForView();
            this.checkViewStaleness(columns, descriptor.getVisibleFields(), name, (Node)table).ifPresent(explanation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale or in invalid state: %s", name, explanation);
            });
            List<Field> outputFields = (List<Field>)columns.stream().map(column -> Field.newQualified(table.getName(), Optional.of(column.getName()), this.getViewColumnType((ConnectorViewDefinition.ViewColumn)column, name, (Node)table), false, Optional.of(name), Optional.of(column.getName()), false)).collect(ImmutableList.toImmutableList());
            if (storageTable.isPresent()) {
                outputFields = this.analyzeStorageTable(table, outputFields, storageTable.get());
                this.analyzeFiltersAndMasks(table, name, storageTable, outputFields, StatementAnalyzer.this.session.getIdentity().getUser());
                return this.createAndAssignScope((Node)table, scope, outputFields);
            }
            this.analyzeFiltersAndMasks(table, name, storageTable, outputFields, StatementAnalyzer.this.session.getIdentity().getUser());
            outputFields.forEach(field -> StatementAnalyzer.this.analysis.addSourceColumns((Field)field, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(name, field.getName().orElseThrow()))));
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            StatementAnalyzer.this.analysis.addRelationCoercion((Relation)table, (Type[])outputFields.stream().map(Field::getType).toArray(Type[]::new));
            return this.createAndAssignScope((Node)table, scope, outputFields);
        }

        private List<Field> analyzeStorageTable(Table table, List<Field> viewFields, TableHandle storageTable) {
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, storageTable);
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, storageTable);
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            this.checkStorageTableNotRedirected(tableName);
            List tableFields = (List)this.analyzeTableOutputFields(table, tableName, tableSchema, columnHandles).stream().filter(field -> !field.isHidden()).collect(ImmutableList.toImmutableList());
            if (tableFields.size() != viewFields.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "storage table column count (%s) does not match column count derived from the materialized view query analysis (%s)", tableFields.size(), viewFields.size());
            }
            for (int index = 0; index < tableFields.size(); ++index) {
                Field tableField = (Field)tableFields.get(index);
                Field viewField = viewFields.get(index);
                if (tableField.getName().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "a column of type %s projected from query view at position %s has no name", tableField.getType(), index);
                }
                String tableFieldName = tableField.getName().orElseThrow();
                String viewFieldName = viewField.getName().orElseThrow();
                if (!viewFieldName.equalsIgnoreCase(tableFieldName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "column [%s] of type %s projected from storage table at position %s has a different name from column [%s] of type %s stored in materialized view definition", tableFieldName, tableField.getType(), index, viewFieldName, viewField.getType());
                }
                if (tableField.getType().equals(viewField.getType())) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "column [%s] of type %s projected from storage table at position %s has a different type from column [%s] of type %s stored in view definition", tableFieldName, tableField.getType(), index, viewFieldName, viewField.getType());
            }
            return tableFields;
        }

        private List<Field> analyzeTableOutputFields(Table table, QualifiedObjectName tableName, TableSchema tableSchema, Map<String, ColumnHandle> columnHandles) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnSchema column : tableSchema.getColumns()) {
                Field field = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.isHidden(), Optional.of(tableName), Optional.of(column.getName()), false);
                fields.add((Object)field);
                ColumnHandle columnHandle = columnHandles.get(column.getName());
                Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object)field);
                StatementAnalyzer.this.analysis.setColumn(field, columnHandle);
                StatementAnalyzer.this.analysis.addSourceColumns(field, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(tableName, column.getName())));
            }
            return fields.build();
        }

        protected Scope visitPatternRecognitionRelation(PatternRecognitionRelation relation, Optional<Scope> scope) {
            ImmutableList outputFields;
            Field inputField2;
            Object label;
            Scope inputScope = this.process((Node)relation.getInput(), scope);
            HashSet inputNames = new HashSet();
            for (Field field : inputScope.getRelationType().getAllFields()) {
                field.getName().ifPresent(name -> {
                    if (!inputNames.add(name.toUpperCase(Locale.ENGLISH))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)relation.getInput(), "ambiguous column: %s in row pattern input relation", name);
                    }
                });
            }
            for (Expression expression2 : relation.getPartitionBy()) {
                this.validateAndGetInputField(expression2, inputScope);
                Type type = this.analyzeExpression(expression2, inputScope).getType(expression2);
                if (type.isComparable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression2, "%s is not comparable, and therefore cannot be used in PARTITION BY", type);
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(relation.getOrderBy())) {
                Expression expression3 = sortItem.getSortKey();
                this.validateAndGetInputField(expression3, inputScope);
                Type type = this.analyzeExpression(expression3, inputScope).getType(sortItem.getSortKey());
                if (type.isOrderable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortItem, "%s is not orderable, and therefore cannot be used in ORDER BY", type);
            }
            Set primaryLabels = (Set)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)relation.getPattern()), Identifier.class).stream().map(this::label).collect(ImmutableSet.toImmutableSet());
            List unionLabels = (List)relation.getSubsets().stream().map(SubsetDefinition::getName).map(this::label).collect(ImmutableList.toImmutableList());
            HashSet<String> unique = new HashSet<String>();
            for (SubsetDefinition subset : relation.getSubsets()) {
                label = this.label(subset.getName());
                if (primaryLabels.contains(label)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)subset.getName(), "union pattern variable name: %s is a duplicate of primary pattern variable name", subset.getName());
                }
                if (!unique.add((String)label)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)subset.getName(), "union pattern variable name: %s is declared twice", subset.getName());
                }
                for (Identifier element : subset.getIdentifiers()) {
                    if (primaryLabels.contains(this.label(element))) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)element, "subset element: %s is not a primary pattern variable", element);
                }
            }
            unique = new HashSet();
            for (VariableDefinition definition : relation.getVariableDefinitions()) {
                label = this.label(definition.getName());
                if (!primaryLabels.contains(label)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)definition.getName(), "defined variable: %s is not a primary pattern variable", definition.getName());
                }
                if (unique.add((String)label)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)definition.getName(), "pattern variable with name: %s is defined twice", definition.getName());
            }
            Sets.SetView undefinedLabels = Sets.difference((Set)primaryLabels, unique);
            StatementAnalyzer.this.analysis.setUndefinedLabels(relation, (Set<String>)undefinedLabels);
            ImmutableSet allLabels = ImmutableSet.builder().addAll((Iterable)primaryLabels).addAll((Iterable)unionLabels).build();
            for (Object variableDefinition : relation.getVariableDefinitions()) {
                Expression expression4 = variableDefinition.getExpression();
                ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)expression4), FunctionCall.class).stream().filter(functionCall -> functionCall.getProcessingMode().map(mode -> mode.getMode() == ProcessingMode.Mode.FINAL).orElse(false)).findFirst().ifPresent(functionCall -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)functionCall.getProcessingMode().get(), "FINAL semantics is not supported in DEFINE clause", new Object[0]);
                });
                ExpressionAnalysis expressionAnalysis = this.analyzePatternRecognitionExpression(expression4, inputScope, (Set<String>)allLabels);
                Type type = expressionAnalysis.getType(expression4);
                if (type.equals(BooleanType.BOOLEAN)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression4, "Expression defining a label must be boolean (actual type: %s)", type);
            }
            ImmutableMap.Builder measureTypesBuilder = ImmutableMap.builder();
            for (MeasureDefinition measureDefinition : relation.getMeasures()) {
                Expression expression5 = measureDefinition.getExpression();
                ExpressionAnalysis expressionAnalysis = this.analyzePatternRecognitionExpression(expression5, inputScope, (Set<String>)allLabels);
                measureTypesBuilder.put((Object)NodeRef.of((Node)expression5), (Object)expressionAnalysis.getType(expression5));
            }
            ImmutableMap measureTypes = measureTypesBuilder.build();
            relation.getPatternSearchMode().ifPresent(mode -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)mode, "Pattern search modifier: %s is not allowed in MATCH_RECOGNIZE clause", mode.getMode());
            });
            AstUtils.preOrder((Node)relation.getPattern()).filter(RangeQuantifier.class::isInstance).map(RangeQuantifier.class::cast).forEach(quantifier -> {
                Optional<Long> atLeast = quantifier.getAtLeast().map(LongLiteral::getValue);
                atLeast.ifPresent(value -> {
                    if (value < 0L) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier lower bound must be greater than or equal to 0", new Object[0]);
                    }
                    if (value > Integer.MAX_VALUE) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier lower bound must not exceed 2147483647", new Object[0]);
                    }
                });
                Optional<Long> atMost = quantifier.getAtMost().map(LongLiteral::getValue);
                atMost.ifPresent(value -> {
                    if (value < 1L) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier upper bound must be greater than or equal to 1", new Object[0]);
                    }
                    if (value > Integer.MAX_VALUE) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier upper bound must not exceed 2147483647", new Object[0]);
                    }
                });
                if (atLeast.isPresent() && atMost.isPresent() && atLeast.get() > atMost.get()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RANGE, (Node)quantifier, "Pattern quantifier lower bound must not exceed upper bound", new Object[0]);
                }
                StatementAnalyzer.this.analysis.setRange((RangeQuantifier)quantifier, new Analysis.Range(atLeast.map(Math::toIntExact), atMost.map(Math::toIntExact)));
            });
            if (relation.getRowsPerMatch().isPresent() && ((PatternRecognitionRelation.RowsPerMatch)relation.getRowsPerMatch().get()).isUnmatchedRows()) {
                AstUtils.preOrder((Node)relation.getPattern()).filter(ExcludedPattern.class::isInstance).findFirst().ifPresent(exclusion -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_PATTERN, exclusion, "Pattern exclusion syntax is not allowed when ALL ROWS PER MATCH WITH UNMATCHED ROWS is specified", new Object[0]);
                });
            }
            relation.getAfterMatchSkipTo().flatMap(SkipTo::getIdentifier).ifPresent(arg_0 -> this.lambda$visitPatternRecognitionRelation$36((Set)allLabels, arg_0));
            List expressions = (List)Streams.concat((Stream[])new Stream[]{relation.getMeasures().stream().map(MeasureDefinition::getExpression), relation.getVariableDefinitions().stream().map(VariableDefinition::getExpression)}).collect(ImmutableList.toImmutableList());
            expressions.forEach(expression -> AstUtils.preOrder((Node)expression).filter(PatternRecognitionRelation.class::isInstance).findFirst().ifPresent(nested -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION, nested, "nested row pattern recognition in row pattern recognition", new Object[0]);
            }));
            boolean oneRowPerMatch = relation.getRowsPerMatch().isEmpty() || ((PatternRecognitionRelation.RowsPerMatch)relation.getRowsPerMatch().get()).isOneRow();
            ImmutableSet.Builder inputFieldsOnOutputBuilder = ImmutableSet.builder();
            ImmutableList.Builder outputFieldsBuilder = ImmutableList.builder();
            for (Expression expression6 : relation.getPartitionBy()) {
                inputField2 = this.validateAndGetInputField(expression6, inputScope);
                outputFieldsBuilder.add((Object)this.unqualifiedVisible(inputField2));
                inputFieldsOnOutputBuilder.add((Object)inputField2);
            }
            if (!oneRowPerMatch) {
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(relation.getOrderBy())) {
                    inputField2 = this.validateAndGetInputField(sortItem.getSortKey(), inputScope);
                    outputFieldsBuilder.add((Object)this.unqualifiedVisible(inputField2));
                    inputFieldsOnOutputBuilder.add((Object)inputField2);
                }
            }
            for (MeasureDefinition measureDefinition : relation.getMeasures()) {
                outputFieldsBuilder.add((Object)Field.newUnqualified(measureDefinition.getName().getValue(), (Type)measureTypes.get(NodeRef.of((Node)measureDefinition.getExpression()))));
            }
            if (!oneRowPerMatch) {
                ImmutableSet inputFieldsOnOutput = inputFieldsOnOutputBuilder.build();
                for (Field inputField2 : inputScope.getRelationType().getAllFields()) {
                    if (inputFieldsOnOutput.contains(inputField2)) continue;
                    outputFieldsBuilder.add((Object)this.unqualified(inputField2));
                }
            }
            if ((outputFields = outputFieldsBuilder.build()).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_HAS_NO_COLUMNS, (Node)relation, "pattern recognition output table has no columns", new Object[0]);
            }
            return this.createAndAssignScope((Node)relation, scope, (List<Field>)outputFields);
        }

        private Field validateAndGetInputField(Expression expression, Scope inputScope) {
            QualifiedName qualifiedName;
            if (expression instanceof Identifier) {
                qualifiedName = QualifiedName.of((Iterable)ImmutableList.of((Object)((Identifier)expression)));
            } else if (expression instanceof DereferenceExpression) {
                qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)expression, "Expected column reference. Actual: " + expression, new Object[0]);
            }
            Optional<ResolvedField> field = inputScope.tryResolveField(expression, qualifiedName);
            if (field.isEmpty() || !field.get().isLocal()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)expression, "Column %s is not present in the input relation", expression);
            }
            return field.get().getField();
        }

        private Field unqualifiedVisible(Field field) {
            return new Field(Optional.empty(), field.getName(), field.getType(), false, field.getOriginTable(), field.getOriginColumnName(), field.isAliased());
        }

        private Field unqualified(Field field) {
            return new Field(Optional.empty(), field.getName(), field.getType(), field.isHidden(), field.getOriginTable(), field.getOriginColumnName(), field.isAliased());
        }

        private ExpressionAnalysis analyzePatternRecognitionExpression(Expression expression, Scope scope, Set<String> labels) {
            return ExpressionAnalyzer.analyzePatternRecognitionExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, labels);
        }

        private String label(Identifier identifier) {
            return identifier.getCanonicalValue();
        }

        protected Scope visitAliasedRelation(AliasedRelation relation, Optional<Scope> scope) {
            int totalColumns;
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            RelationType relationType = relationScope.getRelationType();
            if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
            }
            List aliases = null;
            if (relation.getColumnNames() != null) {
                aliases = relation.getColumnNames().stream().map(Identifier::getValue).collect(Collectors.toList());
            }
            RelationType descriptor = relationType.withAlias(relation.getAlias().getValue(), aliases);
            return this.createAndAssignScope((Node)relation, scope, descriptor);
        }

        protected Scope visitSampledRelation(SampledRelation relation, Optional<Scope> scope) {
            double samplePercentageValue;
            Expression samplePercentage = relation.getSamplePercentage();
            if (!SymbolsExtractor.extractNames(samplePercentage, StatementAnalyzer.this.analysis.getColumnReferences()).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)samplePercentage, "Sample percentage cannot contain column references", new Object[0]);
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.analyzeExpressions(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, TypeProvider.empty(), (Iterable<Expression>)ImmutableList.of((Object)samplePercentage), StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe()).getExpressionTypes();
            Type samplePercentageType = expressionTypes.get(NodeRef.of((Node)samplePercentage));
            if (!StatementAnalyzer.this.typeCoercion.canCoerce(samplePercentageType, (Type)DoubleType.DOUBLE)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)samplePercentage, "Sample percentage should be a numeric expression", new Object[0]);
            }
            ExpressionInterpreter samplePercentageEval = new ExpressionInterpreter(samplePercentage, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, expressionTypes);
            Object samplePercentageObject = samplePercentageEval.optimize(symbol -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)samplePercentage, "Sample percentage cannot contain column references", new Object[0]);
            });
            if (samplePercentageObject == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)samplePercentage, "Sample percentage cannot be NULL", new Object[0]);
            }
            if (samplePercentageType != DoubleType.DOUBLE) {
                ResolvedFunction coercion = StatementAnalyzer.this.metadata.getCoercion(samplePercentageType, (Type)DoubleType.DOUBLE);
                InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(StatementAnalyzer.this.metadata);
                samplePercentageObject = functionInvoker.invoke(coercion, StatementAnalyzer.this.session.toConnectorSession(), samplePercentageObject);
                Verify.verify((samplePercentageObject != null ? 1 : 0) != 0, (String)"Coercion from %s to %s returned null", (Object)samplePercentageType, (Object)DoubleType.DOUBLE);
            }
            if ((samplePercentageValue = ((Double)samplePercentageObject).doubleValue()) < 0.0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)samplePercentage, "Sample percentage must be greater than or equal to 0", new Object[0]);
            }
            if (samplePercentageValue > 100.0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)samplePercentage, "Sample percentage must be less than or equal to 100", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType());
        }

        protected Scope visitTableSubquery(TableSubquery node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitQuerySpecification(QuerySpecification node, Optional<Scope> scope) {
            boolean requiresOrderBy;
            Scope sourceScope = this.analyzeFrom(node, scope);
            this.analyzeWindowDefinitions(node, sourceScope);
            this.resolveFunctionCallWindows(node);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, sourceScope, (Expression)where));
            List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
            Analysis.GroupingSetAnalysis groupByAnalysis = this.analyzeGroupBy(node, sourceScope, outputExpressions);
            this.analyzeHaving(node, sourceScope);
            Scope outputScope = this.computeAndAssignOutputScope(node, scope, sourceScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            Optional<Object> orderByScope = Optional.empty();
            if (node.getOrderBy().isPresent()) {
                OrderBy orderBy = (OrderBy)node.getOrderBy().get();
                orderByScope = Optional.of(this.computeAndAssignOrderByScope(orderBy, sourceScope, outputScope));
                orderByExpressions = this.analyzeOrderBy((Node)node, orderBy.getSortItems(), (Scope)orderByScope.get());
                if (sourceScope.getOuterQueryParent().isPresent() && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(orderBy);
                    this.warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get(), outputScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit((Node)node.getLimit().get(), outputScope)) && node.getOrderBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)node.getLimit().get(), "FETCH FIRST WITH TIES clause requires ORDER BY", new Object[0]);
            }
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>();
            StatementAnalyzer.this.analysis.getSelectExpressions((Node)node).stream().map(Analysis.SelectExpression::getExpression).forEach(sourceExpressions::add);
            node.getHaving().ifPresent(sourceExpressions::add);
            for (WindowDefinition windowDefinition : node.getWindows()) {
                WindowSpecification window = windowDefinition.getWindow();
                sourceExpressions.addAll(window.getPartitionBy());
                NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).stream().map(SortItem::getSortKey).forEach(sourceExpressions::add);
                window.getFrame().map(WindowFrame::getStart).flatMap(FrameBound::getValue).ifPresent(sourceExpressions::add);
                window.getFrame().flatMap(WindowFrame::getEnd).flatMap(FrameBound::getValue).ifPresent(sourceExpressions::add);
            }
            this.analyzeGroupingOperations(node, sourceExpressions, orderByExpressions);
            this.analyzeAggregations(node, sourceScope, orderByScope, groupByAnalysis, sourceExpressions, orderByExpressions);
            this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
            if (StatementAnalyzer.this.analysis.isAggregation(node) && node.getOrderBy().isPresent()) {
                ImmutableList.Builder aggregates = ImmutableList.builder().addAll(groupByAnalysis.getOriginalExpressions()).addAll(ExpressionTreeUtils.extractAggregateFunctions(orderByExpressions, StatementAnalyzer.this.metadata)).addAll(ExpressionTreeUtils.extractExpressions(orderByExpressions, GroupingOperation.class));
                StatementAnalyzer.this.analysis.setOrderByAggregates((OrderBy)node.getOrderBy().get(), (List<Expression>)aggregates.build());
            }
            if (node.getOrderBy().isPresent() && node.getSelect().isDistinct()) {
                this.verifySelectDistinct(node, orderByExpressions, outputExpressions, sourceScope, (Scope)orderByScope.get());
            }
            return outputScope;
        }

        protected Scope visitSubqueryExpression(SubqueryExpression node, Optional<Scope> context) {
            return this.process((Node)node.getQuery(), context);
        }

        protected Scope visitSetOperation(SetOperation node, Optional<Scope> scope) {
            int i;
            Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
            List childrenTypes = (List)node.getRelations().stream().map(relation -> this.process((Node)relation, scope).getRelationType().withOnlyVisibleFields()).collect(ImmutableList.toImmutableList());
            String setOperationName = node.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            Type[] outputFieldTypes = (Type[])((RelationType)childrenTypes.get(0)).getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
            Type[] typeArray = childrenTypes.iterator();
            while (typeArray.hasNext()) {
                int outputFieldSize = outputFieldTypes.length;
                RelationType relationType = (RelationType)typeArray.next();
                int descFieldSize = relationType.getVisibleFields().size();
                if (outputFieldSize != descFieldSize) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s query has different number of fields: %d, %d", setOperationName, outputFieldSize, descFieldSize);
                }
                for (int i2 = 0; i2 < descFieldSize; ++i2) {
                    Type descFieldType = relationType.getFieldByIndex(i2).getType();
                    Optional<Type> commonSuperType = StatementAnalyzer.this.typeCoercion.getCommonSuperType(outputFieldTypes[i2], descFieldType);
                    if (commonSuperType.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "column %d in %s query has incompatible types: %s, %s", i2 + 1, setOperationName, outputFieldTypes[i2].getDisplayName(), descFieldType.getDisplayName());
                    }
                    outputFieldTypes[i2] = commonSuperType.get();
                }
            }
            if (node instanceof Intersect || node instanceof Except || node instanceof Union && node.isDistinct()) {
                for (Type type : outputFieldTypes) {
                    if (type.isComparable()) continue;
                    StringBuilder message = new StringBuilder(String.format("Type %s is not comparable and therefore cannot be used in ", type));
                    message.append(setOperationName);
                    if (node instanceof Union) {
                        message.append(" DISTINCT");
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, message.toString(), new Object[0]);
                }
            }
            Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
            RelationType firstDescriptor = (RelationType)childrenTypes.get(0);
            for (i = 0; i < outputFieldTypes.length; ++i) {
                Field oldField = firstDescriptor.getFieldByIndex(i);
                outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
            }
            block4: for (i = 0; i < node.getRelations().size(); ++i) {
                Relation relation2 = (Relation)node.getRelations().get(i);
                RelationType relationType = (RelationType)childrenTypes.get(i);
                for (int j = 0; j < relationType.getVisibleFields().size(); ++j) {
                    Type outputFieldType = outputFieldTypes[j];
                    Type descFieldType = relationType.getFieldByIndex(j).getType();
                    if (outputFieldType.equals(descFieldType)) continue;
                    StatementAnalyzer.this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                    continue block4;
                }
            }
            return this.createAndAssignScope((Node)node, scope, outputDescriptorFields);
        }

        protected Scope visitJoin(Join node, Optional<Scope> scope) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            JoinCriteria criteria = node.getCriteria().orElse(null);
            if (criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
            }
            Scope left = this.process((Node)node.getLeft(), scope);
            Scope right = this.process((Node)node.getRight(), this.isLateralRelation(node.getRight()) ? Optional.of(left) : scope);
            if (this.isLateralRelation(node.getRight())) {
                if (node.getType() == Join.Type.RIGHT || node.getType() == Join.Type.FULL) {
                    Stream<Expression> leftScopeReferences = ScopeReferenceExtractor.getReferencesToScope((Node)node.getRight(), StatementAnalyzer.this.analysis, left);
                    leftScopeReferences.findFirst().ifPresent(reference -> {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)reference, "LATERAL reference not allowed in %s JOIN", node.getType().name());
                    });
                }
                if (this.isUnnestRelation(node.getRight())) {
                    if (!(criteria == null || criteria instanceof JoinOn && ((JoinOn)criteria).getExpression().equals((Object)BooleanLiteral.TRUE_LITERAL))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)(criteria instanceof JoinOn ? ((JoinOn)criteria).getExpression() : node), "%s JOIN involving UNNEST is only supported with condition ON TRUE", node.getType().name());
                    }
                } else if (!(node.getType() != Join.Type.FULL || criteria instanceof JoinOn && ((JoinOn)criteria).getExpression().equals((Object)BooleanLiteral.TRUE_LITERAL))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)(criteria instanceof JoinOn ? ((JoinOn)criteria).getExpression() : node), "FULL JOIN involving LATERAL relation is only supported with condition ON TRUE", new Object[0]);
                }
            }
            if (criteria instanceof JoinUsing) {
                return this.analyzeJoinUsing(node, ((JoinUsing)criteria).getColumns(), scope, left, right);
            }
            Scope output = this.createAndAssignScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                return output;
            }
            if (criteria instanceof JoinOn) {
                expression = ((JoinOn)criteria).getExpression();
                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.metadata, expression, "JOIN clause");
                expressionAnalysis = this.analyzeExpression(expression, output, node.getType() == Join.Type.INNER ? CorrelationSupport.ALLOWED : CorrelationSupport.DISALLOWED);
                Type clauseType = expressionAnalysis.getType(expression);
                if (!clauseType.equals(BooleanType.BOOLEAN)) {
                    if (!clauseType.equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "JOIN ON clause must evaluate to a boolean: actual type %s", clauseType);
                    }
                    StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, false);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported join criteria: " + criteria.getClass().getName());
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            StatementAnalyzer.this.analysis.setJoinCriteria(node, expression);
            return output;
        }

        protected Scope visitUpdate(Update update, Optional<Scope> scope) {
            Table table = update.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating through views is not supported", new Object[0]);
            }
            TableHandle handle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, handle);
            List<ColumnMetadata> allColumns = tableMetadata.getColumns();
            Map columns = (Map)allColumns.stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, Function.identity()));
            for (Object assignment2 : update.getAssignments()) {
                String columnName = assignment2.getName().getValue();
                if (columns.containsKey(columnName)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)assignment2.getName(), "The UPDATE SET target column %s doesn't exist", columnName);
            }
            Set assignmentTargets = (Set)update.getAssignments().stream().map(assignment -> assignment.getName().getValue()).collect(ImmutableSet.toImmutableSet());
            StatementAnalyzer.this.accessControl.checkCanUpdateTableColumns(StatementAnalyzer.this.session.toSecurityContext(), tableName, assignmentTargets);
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), tableName).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating a table with a row filter is not supported", new Object[0]);
            }
            for (ColumnMetadata tableColumn : allColumns) {
                if (StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.toSecurityContext(), tableName, tableColumn.getName(), tableColumn.getType()).isEmpty()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating a table with column masks is not supported", new Object[0]);
            }
            List updatedColumns = (List)allColumns.stream().filter(column -> assignmentTargets.contains(column.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setUpdatedColumns(updatedColumns);
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope tableScope = analyzer.analyzeForUpdate(table, scope, UpdateKind.UPDATE);
            update.getWhere().ifPresent(where -> this.analyzeWhere((Node)update, tableScope, (Expression)where));
            ImmutableList.Builder analysesBuilder = ImmutableList.builder();
            ImmutableList.Builder expressionTypesBuilder = ImmutableList.builder();
            for (UpdateAssignment assignment3 : update.getAssignments()) {
                Expression expression = assignment3.getValue();
                ExpressionAnalysis analysis = this.analyzeExpression(expression, tableScope);
                analysesBuilder.add((Object)analysis);
                expressionTypesBuilder.add((Object)analysis.getType(expression));
            }
            ImmutableList analyses = analysesBuilder.build();
            ImmutableList expressionTypes = expressionTypesBuilder.build();
            List tableTypes = (List)update.getAssignments().stream().map(assignment -> Objects.requireNonNull((ColumnMetadata)columns.get(assignment.getName().getValue()))).map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
            if (!this.typesMatchForInsert(tableTypes, (List<Type>)expressionTypes)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)update, "UPDATE table column types don't match SET expressions: Table: [%s], Expressions: [%s]", Joiner.on((String)", ").join((Iterable)tableTypes), Joiner.on((String)", ").join((Iterable)expressionTypes));
            }
            for (int index = 0; index < expressionTypes.size(); ++index) {
                Expression expression = ((UpdateAssignment)update.getAssignments().get(index)).getValue();
                Type expressionType = (Type)expressionTypes.get(index);
                Type targetType = (Type)tableTypes.get(index);
                if (!targetType.equals(expressionType)) {
                    StatementAnalyzer.this.analysis.addCoercion(expression, targetType, StatementAnalyzer.this.typeCoercion.isTypeOnlyCoercion(expressionType, targetType));
                }
                StatementAnalyzer.this.analysis.recordSubqueries((Node)update, (ExpressionAnalysis)analyses.get(index));
            }
            StatementAnalyzer.this.analysis.setUpdateType("UPDATE", tableName, Optional.of(table), Optional.of((List)updatedColumns.stream().map(column -> new OutputColumn(new Column(column.getName(), column.getType().toString()), (Set<Analysis.SourceColumn>)ImmutableSet.of())).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)update, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitMerge(Merge merge, Optional<Scope> scope) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support merge");
        }

        private Scope analyzeJoinUsing(Join node, List<Identifier> columns, Optional<Scope> scope, Scope left, Scope right) {
            ArrayList<Field> joinFields = new ArrayList<Field>();
            ArrayList<Integer> leftJoinFields = new ArrayList<Integer>();
            ArrayList<Integer> rightJoinFields = new ArrayList<Integer>();
            HashSet<Identifier> seen = new HashSet<Identifier>();
            for (Identifier column : columns) {
                if (!seen.add(column)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)column, "Column '%s' appears multiple times in USING clause", column.getValue());
                }
                Optional<ResolvedField> leftField = left.tryResolveField((Expression)column);
                Optional<ResolvedField> rightField = right.tryResolveField((Expression)column);
                if (leftField.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)column, "Column '%s' is missing from left side of join", column.getValue());
                }
                if (rightField.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)column, "Column '%s' is missing from right side of join", column.getValue());
                }
                try {
                    StatementAnalyzer.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)leftField.get().getType(), (Object)rightField.get().getType()));
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)column, (Throwable)((Object)e), "%s", e.getMessage());
                }
                Optional<Type> type = StatementAnalyzer.this.typeCoercion.getCommonSuperType(leftField.get().getType(), rightField.get().getType());
                StatementAnalyzer.this.analysis.addTypes((Map<NodeRef<Expression>, Type>)ImmutableMap.of((Object)NodeRef.of((Node)column), (Object)type.get()));
                joinFields.add(Field.newUnqualified(column.getValue(), type.get()));
                leftJoinFields.add(leftField.get().getRelationFieldIndex());
                rightJoinFields.add(rightField.get().getRelationFieldIndex());
                this.recordColumnAccess(leftField.get().getField());
                this.recordColumnAccess(rightField.get().getField());
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.addAll(joinFields);
            ImmutableList.Builder leftFields = ImmutableList.builder();
            for (int i = 0; i < left.getRelationType().getAllFieldCount(); ++i) {
                if (leftJoinFields.contains(i)) continue;
                outputs.add((Object)left.getRelationType().getFieldByIndex(i));
                leftFields.add((Object)i);
            }
            ImmutableList.Builder rightFields = ImmutableList.builder();
            for (int i = 0; i < right.getRelationType().getAllFieldCount(); ++i) {
                if (rightJoinFields.contains(i)) continue;
                outputs.add((Object)right.getRelationType().getFieldByIndex(i));
                rightFields.add((Object)i);
            }
            StatementAnalyzer.this.analysis.setJoinUsing(node, new Analysis.JoinUsingAnalysis(leftJoinFields, rightJoinFields, (List<Integer>)leftFields.build(), (List<Integer>)rightFields.build()));
            return this.createAndAssignScope((Node)node, scope, new RelationType((List<Field>)outputs.build()));
        }

        private void recordColumnAccess(Field field) {
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.of((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get()));
            }
        }

        private boolean isLateralRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isLateralRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest || node instanceof Lateral;
        }

        private boolean isUnnestRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isUnnestRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest;
        }

        protected Scope visitValues(Values node, Optional<Scope> scope) {
            Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
            List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, this.createScope(scope)).getType((Expression)row)).map(type -> {
                if (type instanceof RowType) {
                    return type;
                }
                return RowType.anonymousRow((Type[])new Type[]{type});
            }).collect(ImmutableList.toImmutableList());
            int fieldCount = ((Type)rowTypes.get(0)).getTypeParameters().size();
            Type commonSuperType = (Type)rowTypes.get(0);
            for (Type rowType : rowTypes) {
                if (rowType.getTypeParameters().size() != fieldCount) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Values rows have mismatched sizes: %s vs %s", fieldCount, rowType.getTypeParameters().size());
                }
                Optional<Type> partialSuperType = StatementAnalyzer.this.typeCoercion.getCommonSuperType(rowType, commonSuperType);
                if (partialSuperType.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType);
                }
                commonSuperType = partialSuperType.get();
            }
            for (Expression row2 : node.getRows()) {
                Type actualType = StatementAnalyzer.this.analysis.getType(row2);
                if (row2 instanceof Row) {
                    for (int i = 0; i < actualType.getTypeParameters().size(); ++i) {
                        Type expectedItemType;
                        Expression item = (Expression)((Row)row2).getItems().get(i);
                        Type actualItemType = (Type)actualType.getTypeParameters().get(i);
                        if (actualItemType.equals(expectedItemType = (Type)commonSuperType.getTypeParameters().get(i))) continue;
                        StatementAnalyzer.this.analysis.addCoercion(item, expectedItemType, StatementAnalyzer.this.typeCoercion.isTypeOnlyCoercion(actualItemType, expectedItemType));
                    }
                    continue;
                }
                if (actualType instanceof RowType) {
                    if (actualType.equals(commonSuperType)) continue;
                    StatementAnalyzer.this.analysis.addCoercion(row2, commonSuperType, StatementAnalyzer.this.typeCoercion.isTypeOnlyCoercion(actualType, commonSuperType));
                    continue;
                }
                Type superType = (Type)Iterables.getOnlyElement((Iterable)commonSuperType.getTypeParameters());
                if (actualType.equals(superType)) continue;
                StatementAnalyzer.this.analysis.addCoercion(row2, superType, StatementAnalyzer.this.typeCoercion.isTypeOnlyCoercion(actualType, superType));
            }
            List fields = (List)commonSuperType.getTypeParameters().stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableList.toImmutableList());
            return this.createAndAssignScope((Node)node, scope, fields);
        }

        private void analyzeWindowDefinitions(QuerySpecification node, Scope scope) {
            for (WindowDefinition windowDefinition : node.getWindows()) {
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(windowDefinition.getName());
                if (StatementAnalyzer.this.analysis.getWindowDefinition(node, canonicalName) != null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_WINDOW_NAME, (Node)windowDefinition, "WINDOW name '%s' specified more than once", windowDefinition.getName());
                }
                Analysis.ResolvedWindow resolvedWindow = this.resolveWindowSpecification(node, (Window)windowDefinition.getWindow());
                this.analyzeWindow(node, resolvedWindow, scope, (Node)windowDefinition.getWindow());
                StatementAnalyzer.this.analysis.addWindowDefinition(node, canonicalName, resolvedWindow);
            }
        }

        private Analysis.ResolvedWindow resolveWindowSpecification(QuerySpecification querySpecification, Window window) {
            if (window instanceof WindowReference) {
                WindowReference windowReference = (WindowReference)window;
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(windowReference.getName());
                Analysis.ResolvedWindow referencedWindow = StatementAnalyzer.this.analysis.getWindowDefinition(querySpecification, canonicalName);
                if (referencedWindow == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)windowReference.getName(), "Cannot resolve WINDOW name " + windowReference.getName(), new Object[0]);
                }
                return new Analysis.ResolvedWindow(referencedWindow.getPartitionBy(), referencedWindow.getOrderBy(), referencedWindow.getFrame(), !referencedWindow.getPartitionBy().isEmpty(), referencedWindow.getOrderBy().isPresent(), referencedWindow.getFrame().isPresent());
            }
            WindowSpecification windowSpecification = (WindowSpecification)window;
            if (windowSpecification.getExistingWindowName().isPresent()) {
                Identifier referencedName = (Identifier)windowSpecification.getExistingWindowName().get();
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(referencedName);
                Analysis.ResolvedWindow referencedWindow = StatementAnalyzer.this.analysis.getWindowDefinition(querySpecification, canonicalName);
                if (referencedWindow == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)referencedName, "Cannot resolve WINDOW name " + referencedName, new Object[0]);
                }
                if (!windowSpecification.getPartitionBy().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARTITION_BY, (Node)windowSpecification.getPartitionBy().get(0), "WINDOW specification with named WINDOW reference cannot specify PARTITION BY", new Object[0]);
                }
                if (windowSpecification.getOrderBy().isPresent() && referencedWindow.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ORDER_BY, (Node)windowSpecification.getOrderBy().get(), "Cannot specify ORDER BY if referenced named WINDOW specifies ORDER BY", new Object[0]);
                }
                if (referencedWindow.getFrame().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)windowSpecification.getExistingWindowName().get(), "Cannot reference named WINDOW containing frame specification", new Object[0]);
                }
                Optional<OrderBy> orderBy = windowSpecification.getOrderBy();
                boolean orderByInherited = false;
                if (orderBy.isEmpty() && referencedWindow.getOrderBy().isPresent()) {
                    orderBy = referencedWindow.getOrderBy();
                    orderByInherited = true;
                }
                List<Expression> partitionBy = windowSpecification.getPartitionBy();
                boolean partitionByInherited = false;
                if (!referencedWindow.getPartitionBy().isEmpty()) {
                    partitionBy = referencedWindow.getPartitionBy();
                    partitionByInherited = true;
                }
                Optional<WindowFrame> windowFrame = windowSpecification.getFrame();
                boolean frameInherited = false;
                if (windowFrame.isEmpty() && referencedWindow.getFrame().isPresent()) {
                    windowFrame = referencedWindow.getFrame();
                    frameInherited = true;
                }
                return new Analysis.ResolvedWindow(partitionBy, orderBy, windowFrame, partitionByInherited, orderByInherited, frameInherited);
            }
            return new Analysis.ResolvedWindow(windowSpecification.getPartitionBy(), windowSpecification.getOrderBy(), windowSpecification.getFrame(), false, false, false);
        }

        private void analyzeWindow(QuerySpecification querySpecification, Analysis.ResolvedWindow window, Scope scope, Node originalNode) {
            ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeWindow(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport, window, originalNode);
            StatementAnalyzer.this.analysis.recordSubqueries((Node)querySpecification, expressionAnalysis);
        }

        private void resolveFunctionCallWindows(QuerySpecification querySpecification) {
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (SelectItem item : querySpecification.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    ((AllColumns)item).getTarget().ifPresent(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
                    continue;
                }
                if (!(item instanceof SingleColumn)) continue;
                expressions.add((Object)((SingleColumn)item).getExpression());
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(querySpecification.getOrderBy())) {
                expressions.add((Object)sortItem.getSortKey());
            }
            for (FunctionCall windowFunction : ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)expressions.build())) {
                Analysis.ResolvedWindow resolvedWindow = this.resolveWindowSpecification(querySpecification, (Window)windowFunction.getWindow().get());
                StatementAnalyzer.this.analysis.setWindow(windowFunction, resolvedWindow);
            }
        }

        private void analyzeWindowFunctions(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            StatementAnalyzer.this.analysis.setWindowFunctions(node, this.analyzeWindowFunctions(node, outputExpressions));
            if (node.getOrderBy().isPresent()) {
                StatementAnalyzer.this.analysis.setOrderByWindowFunctions((OrderBy)node.getOrderBy().get(), this.analyzeWindowFunctions(node, orderByExpressions));
            }
        }

        private List<FunctionCall> analyzeWindowFunctions(QuerySpecification node, List<Expression> expressions) {
            for (Expression expression : expressions) {
                new WindowFunctionValidator(StatementAnalyzer.this.metadata).process((Node)expression, StatementAnalyzer.this.analysis);
            }
            List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(expressions);
            for (FunctionCall windowFunction : windowFunctions) {
                if (windowFunction.getFilter().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "FILTER is not yet supported for window functions", new Object[0]);
                }
                if (windowFunction.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)windowFunction, "Window function with ORDER BY is not supported", new Object[0]);
                }
                List<FunctionCall> nestedWindowFunctions = ExpressionTreeUtils.extractWindowFunctions(windowFunction.getArguments());
                if (!nestedWindowFunctions.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)nestedWindowFunctions.get(0), "Cannot nest window functions inside window function arguments", new Object[0]);
                }
                if (windowFunction.isDistinct()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
                }
                Analysis.ResolvedWindow window = StatementAnalyzer.this.analysis.getWindow(windowFunction);
                String name = windowFunction.getName().toString().toLowerCase(Locale.ENGLISH);
                if (name.equals("lag") || name.equals("lead")) {
                    if (window.getOrderBy().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)windowFunction.getWindow().get(), "%s function requires an ORDER BY window clause", windowFunction.getName());
                    }
                    if (window.getFrame().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)window.getFrame().get(), "Cannot specify window frame for %s function", windowFunction.getName());
                    }
                }
                if (!WINDOW_VALUE_FUNCTIONS.contains(name) && windowFunction.getNullTreatment().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED, (Node)windowFunction, "Cannot specify null treatment clause for %s function", windowFunction.getName());
                }
                List<Type> argumentTypes = MoreLists.mappedCopy(windowFunction.getArguments(), StatementAnalyzer.this.analysis::getType);
                ResolvedFunction resolvedFunction = StatementAnalyzer.this.metadata.resolveFunction(windowFunction.getName(), TypeSignatureProvider.fromTypes(argumentTypes));
                FunctionKind kind = StatementAnalyzer.this.metadata.getFunctionMetadata(resolvedFunction).getKind();
                if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_WINDOW, (Node)node, "Not a window function: %s", windowFunction.getName());
            }
            return windowFunctions;
        }

        private void analyzeHaving(QuerySpecification node, Scope scope) {
            if (node.getHaving().isPresent()) {
                Expression predicate = (Expression)node.getHaving().get();
                List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate));
                if (!windowFunctions.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)windowFunctions.get(0), "HAVING clause cannot contain window functions", new Object[0]);
                }
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type predicateType = expressionAnalysis.getType(predicate);
                if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals((Object)UnknownType.UNKNOWN)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.setHaving(node, predicate);
            }
        }

        private void checkGroupingSetsCount(GroupBy node) {
            int crossProduct = 1;
            for (GroupingElement element : node.getGroupingElements()) {
                try {
                    int product;
                    if (element instanceof SimpleGroupBy) {
                        product = 1;
                    } else if (element instanceof Cube) {
                        int exponent = element.getExpressions().size();
                        if (exponent > 30) {
                            throw new ArithmeticException();
                        }
                        product = 1 << exponent;
                    } else if (element instanceof Rollup) {
                        product = element.getExpressions().size() + 1;
                    } else if (element instanceof GroupingSets) {
                        product = ((GroupingSets)element).getSets().size();
                    } else {
                        throw new UnsupportedOperationException("Unsupported grouping element type: " + element.getClass().getName());
                    }
                    crossProduct = Math.multiplyExact(crossProduct, product);
                }
                catch (ArithmeticException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has more than %s grouping sets but can contain at most %s", Integer.MAX_VALUE, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
                }
                if (crossProduct <= SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has %s grouping sets but can contain at most %s", crossProduct, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
            }
        }

        private Analysis.GroupingSetAnalysis analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
            if (node.getGroupBy().isPresent()) {
                ImmutableList.Builder cubes = ImmutableList.builder();
                ImmutableList.Builder rollups = ImmutableList.builder();
                ImmutableList.Builder sets = ImmutableList.builder();
                ImmutableList.Builder complexExpressions = ImmutableList.builder();
                ImmutableList.Builder groupingExpressions = ImmutableList.builder();
                this.checkGroupingSetsCount((GroupBy)node.getGroupBy().get());
                for (Object groupingElement : ((GroupBy)node.getGroupBy().get()).getGroupingElements()) {
                    if (groupingElement instanceof SimpleGroupBy) {
                        for (Expression column : groupingElement.getExpressions()) {
                            if (column instanceof LongLiteral) {
                                long ordinal = ((LongLiteral)column).getValue();
                                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)column, "GROUP BY position %s is not in select list", ordinal);
                                }
                                column = outputExpressions.get(Math.toIntExact(ordinal - 1L));
                            } else {
                                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.metadata, column, "GROUP BY clause");
                                this.analyzeExpression(column, scope);
                            }
                            ResolvedField field = StatementAnalyzer.this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)column));
                            if (field != null) {
                                sets.add((Object)ImmutableList.of((Object)ImmutableSet.of((Object)field.getFieldId())));
                            } else {
                                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, this.analyzeExpression(column, scope));
                                complexExpressions.add((Object)column);
                            }
                            groupingExpressions.add((Object)column);
                        }
                        continue;
                    }
                    for (Expression column : groupingElement.getExpressions()) {
                        this.analyzeExpression(column, scope);
                        if (!StatementAnalyzer.this.analysis.getColumnReferences().contains(NodeRef.of((Node)column))) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)column, "GROUP BY expression must be a column reference: %s", column);
                        }
                        groupingExpressions.add((Object)column);
                    }
                    if (groupingElement instanceof Cube) {
                        Set cube = (Set)groupingElement.getExpressions().stream().map(NodeRef::of).map(StatementAnalyzer.this.analysis.getColumnReferenceFields()::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet());
                        cubes.add((Object)cube);
                        continue;
                    }
                    if (groupingElement instanceof Rollup) {
                        List rollup = (List)groupingElement.getExpressions().stream().map(NodeRef::of).map(StatementAnalyzer.this.analysis.getColumnReferenceFields()::get).map(ResolvedField::getFieldId).collect(ImmutableList.toImmutableList());
                        rollups.add((Object)rollup);
                        continue;
                    }
                    if (!(groupingElement instanceof GroupingSets)) continue;
                    List groupingSets = (List)((GroupingSets)groupingElement).getSets().stream().map(set -> (ImmutableSet)set.stream().map(NodeRef::of).map(StatementAnalyzer.this.analysis.getColumnReferenceFields()::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
                    sets.add((Object)groupingSets);
                }
                ImmutableList expressions = groupingExpressions.build();
                for (Expression expression : expressions) {
                    Type type = StatementAnalyzer.this.analysis.getType(expression);
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
                }
                Analysis.GroupingSetAnalysis groupingSets = new Analysis.GroupingSetAnalysis((List<Expression>)expressions, (List<Set<FieldId>>)cubes.build(), (List<List<FieldId>>)rollups.build(), (List<List<Set<FieldId>>>)sets.build(), (List<Expression>)complexExpressions.build());
                StatementAnalyzer.this.analysis.setGroupingSets(node, groupingSets);
                return groupingSets;
            }
            Analysis.GroupingSetAnalysis result = new Analysis.GroupingSetAnalysis((List<Expression>)ImmutableList.of(), (List<Set<FieldId>>)ImmutableList.of(), (List<List<FieldId>>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
            if (this.hasAggregates(node) || node.getHaving().isPresent()) {
                StatementAnalyzer.this.analysis.setGroupingSets(node, result);
            }
            return result;
        }

        private boolean hasAggregates(QuerySpecification node) {
            ImmutableList toExtract = ImmutableList.builder().addAll((Iterable)node.getSelect().getSelectItems()).addAll(NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())).build();
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)toExtract, StatementAnalyzer.this.metadata);
            return !aggregates.isEmpty();
        }

        private Scope computeAndAssignOutputScope(QuerySpecification node, Optional<Scope> scope, Scope sourceScope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    AllColumns allColumns = (AllColumns)item;
                    List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                    Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = fields.get(i);
                        Optional<String> name = !allColumns.getAliases().isEmpty() ? Optional.of(((Identifier)allColumns.getAliases().get(i)).getCanonicalValue()) : field.getName();
                        Field newField = Field.newUnqualified(name, field.getType(), field.getOriginTable(), field.getOriginColumnName(), false);
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns(field));
                        outputFields.add((Object)newField);
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    List<Field> matchingFields;
                    SingleColumn column = (SingleColumn)item;
                    Expression expression = column.getExpression();
                    Optional<Identifier> field = column.getAlias();
                    Optional<QualifiedObjectName> originTable = Optional.empty();
                    Optional<String> originColumn = Optional.empty();
                    QualifiedName name = null;
                    if (expression instanceof Identifier) {
                        name = QualifiedName.of((String)((Identifier)expression).getValue());
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                    }
                    if (name != null && !(matchingFields = sourceScope.getRelationType().resolveFields(name)).isEmpty()) {
                        originTable = matchingFields.get(0).getOriginTable();
                        originColumn = matchingFields.get(0).getOriginColumnName();
                    }
                    if (field.isEmpty() && name != null) {
                        field = Optional.of((Identifier)Iterables.getLast((Iterable)name.getOriginalParts()));
                    }
                    Field newField = Field.newUnqualified(field.map(Identifier::getValue), StatementAnalyzer.this.analysis.getType(expression), originTable, originColumn, column.getAlias().isPresent());
                    if (originTable.isPresent()) {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(originTable.get(), originColumn.get())));
                    } else {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getExpressionSourceColumns(expression));
                    }
                    outputFields.add((Object)newField);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private Scope computeAndAssignOrderByScope(OrderBy node, Scope sourceScope, Scope outputScope) {
            Scope orderByScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            return orderByScope;
        }

        private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
            ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
            ImmutableList.Builder selectExpressionBuilder = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    this.analyzeSelectAllColumns((AllColumns)item, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                if (item instanceof SingleColumn) {
                    this.analyzeSelectSingleColumn((SingleColumn)item, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            StatementAnalyzer.this.analysis.setSelectExpressions((Node)node, (List<Analysis.SelectExpression>)selectExpressionBuilder.build());
            return outputExpressionBuilder.build();
        }

        private void analyzeSelectAllColumns(AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            if (allColumns.getTarget().isPresent()) {
                Expression expression = (Expression)allColumns.getTarget().get();
                QualifiedName prefix = ExpressionTreeUtils.asQualifiedName(expression);
                if (prefix != null) {
                    Optional<Scope.AsteriskedIdentifierChainBasis> identifierChainBasis = scope.resolveAsteriskedIdentifierChainBasis(prefix, allColumns);
                    if (identifierChainBasis.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)allColumns, "Unable to resolve reference %s", prefix);
                    }
                    if (identifierChainBasis.get().getBasisType() == Scope.BasisType.TABLE) {
                        RelationType relationType = identifierChainBasis.get().getRelationType().get();
                        List<Field> fields = relationType.resolveVisibleFieldsWithRelationPrefix(Optional.of(prefix));
                        if (fields.isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed from relation that has no columns", new Object[0]);
                        }
                        boolean local = scope.isLocalScope(identifierChainBasis.get().getScope().get());
                        this.analyzeAllColumnsFromTable(fields, allColumns, node, local ? scope : identifierChainBasis.get().getScope().get(), outputExpressionBuilder, selectExpressionBuilder, relationType, local);
                        return;
                    }
                }
                this.analyzeAllFieldsFromRowTypeExpression(expression, allColumns, node, scope, outputExpressionBuilder, selectExpressionBuilder);
            } else {
                if (!allColumns.getAliases().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)allColumns, "Column aliases not supported", new Object[0]);
                }
                List fields = (List)scope.getRelationType().getVisibleFields();
                if (fields.isEmpty()) {
                    if (node.getFrom().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed from relation that has no columns", new Object[0]);
                }
                this.analyzeAllColumnsFromTable(fields, allColumns, node, scope, outputExpressionBuilder, selectExpressionBuilder, scope.getRelationType(), true);
            }
        }

        private void analyzeAllColumnsFromTable(List<Field> fields, AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder, RelationType relationType, boolean local) {
            if (!allColumns.getAliases().isEmpty()) {
                this.validateColumnAliasesCount(allColumns.getAliases(), fields.size());
            }
            ImmutableList.Builder itemOutputFieldBuilder = ImmutableList.builder();
            for (int i = 0; i < fields.size(); ++i) {
                FieldReference fieldExpression;
                Field field = fields.get(i);
                if (local) {
                    fieldExpression = new FieldReference(relationType.indexOf(field));
                } else {
                    if (field.getName().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node.getSelect(), "SELECT * from outer scope table not supported with anonymous columns", new Object[0]);
                    }
                    Preconditions.checkState((boolean)field.getRelationAlias().isPresent(), (Object)"missing relation alias");
                    fieldExpression = new DereferenceExpression(DereferenceExpression.from((QualifiedName)field.getRelationAlias().get()), new Identifier(field.getName().get()));
                }
                this.analyzeExpression((Expression)fieldExpression, scope);
                outputExpressionBuilder.add((Object)fieldExpression);
                selectExpressionBuilder.add((Object)new Analysis.SelectExpression((Expression)fieldExpression, Optional.empty()));
                Optional<String> alias = field.getName();
                if (!allColumns.getAliases().isEmpty()) {
                    alias = Optional.of(((Identifier)allColumns.getAliases().get(i)).getValue());
                }
                Field newField = new Field(field.getRelationAlias(), alias, field.getType(), false, field.getOriginTable(), field.getOriginColumnName(), !allColumns.getAliases().isEmpty() || field.isAliased());
                itemOutputFieldBuilder.add((Object)newField);
                StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns(field));
                Type type = field.getType();
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type);
            }
            StatementAnalyzer.this.analysis.setSelectAllResultFields(allColumns, (List<Field>)itemOutputFieldBuilder.build());
        }

        private void analyzeAllFieldsFromRowTypeExpression(Expression expression, AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            ImmutableList.Builder itemOutputFieldBuilder = ImmutableList.builder();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            Type type = expressionAnalysis.getType(expression);
            if (!(type instanceof RowType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "expected expression of type Row", new Object[0]);
            }
            int referencedFieldsCount = ((RowType)type).getFields().size();
            if (!allColumns.getAliases().isEmpty()) {
                this.validateColumnAliasesCount(allColumns.getAliases(), referencedFieldsCount);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            ImmutableList.Builder unfoldedExpressionsBuilder = ImmutableList.builder();
            for (int i = 0; i < referencedFieldsCount; ++i) {
                SubscriptExpression outputExpression = new SubscriptExpression(expression, (Expression)new LongLiteral("" + (i + 1)));
                outputExpressionBuilder.add((Object)outputExpression);
                this.analyzeExpression((Expression)outputExpression, scope);
                unfoldedExpressionsBuilder.add((Object)outputExpression);
                Type outputExpressionType = (Type)type.getTypeParameters().get(i);
                if (node.getSelect().isDistinct() && !outputExpressionType.isComparable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type.getTypeParameters().get(i));
                }
                Optional<String> name = ((RowType.Field)((RowType)type).getFields().get(i)).getName();
                if (!allColumns.getAliases().isEmpty()) {
                    name = Optional.of(((Identifier)allColumns.getAliases().get(i)).getValue());
                }
                itemOutputFieldBuilder.add((Object)Field.newUnqualified(name, outputExpressionType));
            }
            selectExpressionBuilder.add((Object)new Analysis.SelectExpression(expression, Optional.of(unfoldedExpressionsBuilder.build())));
            StatementAnalyzer.this.analysis.setSelectAllResultFields(allColumns, (List<Field>)itemOutputFieldBuilder.build());
        }

        private void analyzeSelectSingleColumn(SingleColumn singleColumn, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            Expression expression = singleColumn.getExpression();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            outputExpressionBuilder.add((Object)expression);
            selectExpressionBuilder.add((Object)new Analysis.SelectExpression(expression, Optional.empty()));
            Type type = expressionAnalysis.getType(expression);
            if (node.getSelect().isDistinct() && !type.isComparable()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, expression);
            }
        }

        private void analyzeWhere(Node node, Scope scope, Expression predicate) {
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.metadata, predicate, "WHERE clause");
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN)) {
                if (!predicateType.equals((Object)UnknownType.UNKNOWN)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN, false);
            }
            StatementAnalyzer.this.analysis.setWhere(node, predicate);
        }

        private Scope analyzeFrom(QuerySpecification node, Optional<Scope> scope) {
            if (node.getFrom().isPresent()) {
                return this.process((Node)node.getFrom().get(), scope);
            }
            Scope result = this.createScope(scope);
            StatementAnalyzer.this.analysis.setImplicitFromScope(node, result);
            return result;
        }

        private void analyzeGroupingOperations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            boolean isGroupingOperationPresent;
            List<GroupingOperation> groupingOperations = ExpressionTreeUtils.extractExpressions(Iterables.concat(outputExpressions, orderByExpressions), GroupingOperation.class);
            boolean bl = isGroupingOperationPresent = !groupingOperations.isEmpty();
            if (isGroupingOperationPresent && node.getGroupBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_GROUP_BY, (Node)node, "A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setGroupingOperations(node, groupingOperations);
        }

        private void analyzeAggregations(QuerySpecification node, Scope sourceScope, Optional<Scope> orderByScope, Analysis.GroupingSetAnalysis groupByAnalysis, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            Preconditions.checkState((orderByExpressions.isEmpty() || orderByScope.isPresent() ? 1 : 0) != 0, (Object)"non-empty orderByExpressions list without orderByScope provided");
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(Iterables.concat(outputExpressions, orderByExpressions), StatementAnalyzer.this.metadata);
            StatementAnalyzer.this.analysis.setAggregates(node, aggregates);
            if (StatementAnalyzer.this.analysis.isAggregation(node)) {
                ImmutableList distinctGroupingColumns = ImmutableSet.copyOf(groupByAnalysis.getOriginalExpressions()).asList();
                for (Expression expression : outputExpressions) {
                    AggregationAnalyzer.verifySourceAggregations((List<Expression>)distinctGroupingColumns, sourceScope, expression, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis);
                }
                for (Expression expression : orderByExpressions) {
                    AggregationAnalyzer.verifyOrderByAggregations((List<Expression>)distinctGroupingColumns, sourceScope, orderByScope.get(), expression, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis);
                }
            }
        }

        private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<String> owner, Table node) {
            try {
                AccessControl viewAccessControl;
                Identity identity;
                if (owner.isPresent() && !owner.get().equals(StatementAnalyzer.this.session.getIdentity().getUser())) {
                    identity = Identity.forUser((String)owner.get()).withGroups(StatementAnalyzer.this.groupProvider.getGroups(owner.get())).build();
                    viewAccessControl = new ViewAccessControl(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity());
                } else {
                    identity = StatementAnalyzer.this.session.getIdentity();
                    viewAccessControl = StatementAnalyzer.this.accessControl;
                }
                Session viewSession = StatementAnalyzer.this.createViewSession(catalog, schema, identity, StatementAnalyzer.this.session.getPath());
                StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.groupProvider, viewAccessControl, viewSession, this.warningCollector, CorrelationSupport.ALLOWED);
                Scope queryScope = analyzer.analyze((Node)query, Scope.create());
                return queryScope.getRelationType().withAlias(name.getObjectName(), null);
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)node, e, "Failed analyzing stored view '%s': %s", name, e.getMessage());
            }
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                return (Query)StatementAnalyzer.this.sqlParser.createStatement(view, ParsingUtil.createParsingOptions(StatementAnalyzer.this.session));
            }
            catch (ParsingException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, node, e, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private Optional<String> checkViewStaleness(List<ConnectorViewDefinition.ViewColumn> columns, Collection<Field> fields, QualifiedObjectName name, Node node) {
            if (columns.size() != fields.size()) {
                return Optional.of(String.format("stored view column count (%s) does not match column count derived from the view query analysis (%s)", columns.size(), fields.size()));
            }
            ImmutableList fieldList = ImmutableList.copyOf(fields);
            for (int i = 0; i < columns.size(); ++i) {
                ConnectorViewDefinition.ViewColumn column = columns.get(i);
                Type type = this.getViewColumnType(column, name, node);
                Field field = (Field)fieldList.get(i);
                if (field.getName().isEmpty()) {
                    return Optional.of(String.format("a column of type %s projected from query view at position %s has no name", field.getType(), i));
                }
                String fieldName = field.getName().orElseThrow();
                if (!column.getName().equalsIgnoreCase(fieldName)) {
                    return Optional.of(String.format("column [%s] of type %s projected from query view at position %s has a different name from column [%s] of type %s stored in view definition", fieldName, field.getType(), i, column.getName(), type));
                }
                if (StatementAnalyzer.this.typeCoercion.canCoerce(field.getType(), type)) continue;
                return Optional.of(String.format("column [%s] of type %s projected from query view at position %s cannot be coerced to column [%s] of type %s stored in view definition", fieldName, field.getType(), i, column.getName(), type));
            }
            return Optional.empty();
        }

        private Type getViewColumnType(ConnectorViewDefinition.ViewColumn column, QualifiedObjectName name, Node node) {
            try {
                return StatementAnalyzer.this.metadata.getType(column.getType());
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, node, e, "Unknown type '%s' for column '%s' in view: %s", column.getType(), column.getName(), name);
            }
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, correlationSupport);
        }

        private void analyzeRowFilter(String currentIdentity, Table table, QualifiedObjectName name, Scope scope, ViewExpression filter) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            if (StatementAnalyzer.this.analysis.hasRowFilter(name, currentIdentity)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Row filter for '%s' is recursive", name), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(filter.getExpression(), ParsingUtil.createParsingOptions(StatementAnalyzer.this.session));
            }
            catch (ParsingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid row filter for '%s': %s", name, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForRowFiltering(name, currentIdentity);
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.metadata, expression, String.format("Row filter for '%s'", name));
            try {
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.createViewSession(filter.getCatalog(), filter.getSchema(), Identity.forUser((String)filter.getIdentity()).build(), StatementAnalyzer.this.session.getPath()), StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid row filter for '%s': %s", name, e.getRawMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForRowFiltering(name, currentIdentity);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals(BooleanType.BOOLEAN)) {
                TypeCoercion coercion = new TypeCoercion(StatementAnalyzer.this.metadata::getType);
                if (!coercion.canCoerce(actualType, (Type)BooleanType.BOOLEAN)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation((Node)table), String.format("Expected row filter for '%s' to be of type BOOLEAN, but was %s", name, actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, coercion.isTypeOnlyCoercion(actualType, (Type)BooleanType.BOOLEAN));
            }
            StatementAnalyzer.this.analysis.addRowFilter(table, expression);
        }

        private void analyzeColumnMask(String currentIdentity, Table table, QualifiedObjectName tableName, Field field, Scope scope, ViewExpression mask) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            String column = field.getName().get();
            if (StatementAnalyzer.this.analysis.hasColumnMask(tableName, column, currentIdentity)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Column mask for '%s.%s' is recursive", tableName, column), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(mask.getExpression(), ParsingUtil.createParsingOptions(StatementAnalyzer.this.session));
            }
            catch (ParsingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid column mask for '%s.%s': %s", tableName, column, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForColumnMasking(tableName, column, currentIdentity);
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.metadata, expression, String.format("Column mask for '%s.%s'", table.getName(), column));
            try {
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.createViewSession(mask.getCatalog(), mask.getSchema(), Identity.forUser((String)mask.getIdentity()).build(), StatementAnalyzer.this.session.getPath()), StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid column mask for '%s.%s': %s", tableName, column, e.getRawMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForColumnMasking(tableName, column, currentIdentity);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type expectedType = field.getType();
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals(expectedType)) {
                TypeCoercion coercion = new TypeCoercion(StatementAnalyzer.this.metadata::getType);
                if (!coercion.canCoerce(actualType, field.getType())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation((Node)table), String.format("Expected column mask for '%s.%s' to be of type %s, but was %s", tableName, column, field.getType(), actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, expectedType, false);
            }
            StatementAnalyzer.this.analysis.addColumnMask(table, column, expression);
        }

        private List<Expression> descriptorToFields(Scope scope) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
                FieldReference expression = new FieldReference(fieldIndex);
                builder.add((Object)expression);
                this.analyzeExpression((Expression)expression, scope);
            }
            return builder.build();
        }

        private Scope analyzeWith(Query node, Optional<Scope> scope) {
            if (node.getWith().isEmpty()) {
                return this.createScope(scope);
            }
            With with = (With)node.getWith().get();
            Scope.Builder withScopeBuilder = this.scopeBuilder(scope);
            for (WithQuery withQuery : with.getQueries()) {
                String name = withQuery.getName().getValue().toLowerCase(Locale.ENGLISH);
                if (withScopeBuilder.containsNamedQuery(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_NAMED_QUERY, (Node)withQuery, "WITH query name '%s' specified more than once", name);
                }
                boolean isRecursive = false;
                if (with.isRecursive()) {
                    List<Node> recursiveReferences;
                    AstUtils.preOrder((Node)withQuery.getQuery()).filter(PatternRecognitionRelation.class::isInstance).findFirst().ifPresent(nested -> {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION, nested, "nested row pattern recognition in recursive query", new Object[0]);
                    });
                    isRecursive = this.tryProcessRecursiveQuery(withQuery, name, withScopeBuilder);
                    if (!isRecursive && !(recursiveReferences = this.findReferences((Node)withQuery.getQuery(), withQuery.getName())).isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, recursiveReferences.get(0), "recursive reference not allowed in this context", new Object[0]);
                    }
                }
                if (isRecursive) continue;
                Query query = withQuery.getQuery();
                this.process((Node)query, withScopeBuilder.build());
                if (withQuery.getColumnNames().isPresent()) {
                    this.validateColumnAliases((List)withQuery.getColumnNames().get(), StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query).getVisibleFieldCount());
                }
                withScopeBuilder.withNamedQuery(name, withQuery);
            }
            Scope withScope = withScopeBuilder.build();
            StatementAnalyzer.this.analysis.setScope((Node)with, withScope);
            return withScope;
        }

        private boolean tryProcessRecursiveQuery(WithQuery withQuery, String name, Scope.Builder withScopeBuilder) {
            if (withQuery.getColumnNames().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_ALIASES, (Node)withQuery, "missing column aliases in recursive WITH query", new Object[0]);
            }
            AstUtils.preOrder((Node)withQuery.getQuery()).filter(child -> child instanceof With && ((With)child).isRecursive()).findFirst().ifPresent(child -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_RECURSIVE, child, "nested recursive WITH query", new Object[0]);
            });
            if (!(withQuery.getQuery().getQueryBody() instanceof Union)) {
                return false;
            }
            Union union = (Union)withQuery.getQuery().getQueryBody();
            if (union.getRelations().size() != 2) {
                return false;
            }
            Relation anchor = (Relation)union.getRelations().get(0);
            Relation step = (Relation)union.getRelations().get(1);
            List<Node> anchorReferences = this.findReferences((Node)anchor, withQuery.getName());
            if (!anchorReferences.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, anchorReferences.get(0), "WITH table name is referenced in the base relation of recursion", new Object[0]);
            }
            List<Node> stepReferences = this.findReferences((Node)step, withQuery.getName());
            if (stepReferences.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.get(1), "multiple recursive references in the step relation of recursion", new Object[0]);
            }
            if (stepReferences.size() != 1) {
                return false;
            }
            Relation specification = step;
            while (specification instanceof TableSubquery) {
                Query query = ((TableSubquery)specification).getQuery();
                query.getLimit().ifPresent(limit -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LIMIT_CLAUSE, limit, "FETCH FIRST / LIMIT clause in the step relation of recursion", new Object[0]);
                });
                specification = query.getQueryBody();
            }
            if (!(specification instanceof QuerySpecification) || ((QuerySpecification)specification).getFrom().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.get(0), "recursive reference outside of FROM clause of the step relation of recursion", new Object[0]);
            }
            Relation from = (Relation)((QuerySpecification)specification).getFrom().get();
            List<Node> fromReferences = this.findReferences((Node)from, withQuery.getName());
            if (fromReferences.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.get(0), "recursive reference outside of FROM clause of the step relation of recursion", new Object[0]);
            }
            withQuery.getQuery().getWith().ifPresent(innerWith -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)innerWith, "immediate WITH clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getOrderBy().ifPresent(orderBy -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)orderBy, "immediate ORDER BY clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getOffset().ifPresent(offset -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)offset, "immediate OFFSET clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getLimit().ifPresent(limit -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LIMIT_CLAUSE, limit, "immediate FETCH FIRST / LIMIT clause in recursive query", new Object[0]);
            });
            this.validateFromClauseOfRecursiveTerm(from, withQuery.getName());
            Scope parentScope = withScopeBuilder.build();
            Scope anchorScope = this.process((Node)anchor, parentScope);
            Scope aliasedAnchorScope = this.setAliases(anchorScope, withQuery.getName(), (List)withQuery.getColumnNames().get());
            Node recursiveReference = fromReferences.get(0);
            StatementAnalyzer.this.analysis.setExpandableBaseScope(recursiveReference, aliasedAnchorScope);
            Scope stepScope = this.process((Node)step, parentScope);
            RelationType anchorType = aliasedAnchorScope.getRelationType().withOnlyVisibleFields();
            RelationType stepType = stepScope.getRelationType().withOnlyVisibleFields();
            if (anchorType.getVisibleFieldCount() != stepType.getVisibleFieldCount()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)step, "base and step relations of recursion have different number of fields: %s, %s", anchorType.getVisibleFieldCount(), stepType.getVisibleFieldCount());
            }
            List anchorFieldTypes = (List)anchorType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            List stepFieldTypes = (List)stepType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < anchorFieldTypes.size(); ++i) {
                if (StatementAnalyzer.this.typeCoercion.canCoerce((Type)stepFieldTypes.get(i), (Type)anchorFieldTypes.get(i))) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)step, "recursion step relation output type (%s) is not coercible to recursion base relation output type (%s) at column %s", stepFieldTypes.get(i), anchorFieldTypes.get(i), i + 1);
            }
            if (!anchorFieldTypes.equals(stepFieldTypes)) {
                StatementAnalyzer.this.analysis.addRelationCoercion(step, (Type[])anchorFieldTypes.toArray(Type[]::new));
            }
            StatementAnalyzer.this.analysis.setScope((Node)withQuery.getQuery(), aliasedAnchorScope);
            StatementAnalyzer.this.analysis.registerExpandableQuery(withQuery.getQuery(), recursiveReference);
            withScopeBuilder.withNamedQuery(name, withQuery);
            return true;
        }

        private List<Node> findReferences(Node node, Identifier name) {
            Stream<Node> allReferences = AstUtils.preOrder((Node)node).filter(this.isTableWithName(name));
            Set shadowedReferences = (Set)AstUtils.preOrder((Node)node).filter(this.isQueryWithNameShadowed(name)).flatMap(query -> AstUtils.preOrder((Node)query).filter(this.isTableWithName(name))).collect(ImmutableSet.toImmutableSet());
            return (List)allReferences.filter(reference -> !shadowedReferences.contains(reference)).collect(ImmutableList.toImmutableList());
        }

        private Predicate<Node> isTableWithName(Identifier name) {
            return node -> {
                if (!(node instanceof Table)) {
                    return false;
                }
                Table table = (Table)node;
                QualifiedName tableName = table.getName();
                return tableName.getPrefix().isEmpty() && tableName.hasSuffix(QualifiedName.of((String)name.getValue()));
            };
        }

        private Predicate<Node> isQueryWithNameShadowed(Identifier name) {
            return node -> {
                if (!(node instanceof Query)) {
                    return false;
                }
                Query query = (Query)node;
                if (query.getWith().isEmpty()) {
                    return false;
                }
                return ((With)query.getWith().get()).getQueries().stream().map(WithQuery::getName).map(Identifier::getValue).anyMatch(withQueryName -> withQueryName.equalsIgnoreCase(name.getValue()));
            };
        }

        private void validateFromClauseOfRecursiveTerm(Relation from, Identifier name) {
            AstUtils.preOrder((Node)from).filter(node -> node instanceof Join).forEach(node -> {
                Join join = (Join)node;
                Join.Type type = join.getType();
                if (type == Join.Type.LEFT || type == Join.Type.RIGHT || type == Join.Type.FULL) {
                    List<Node> leftRecursiveReferences = this.findReferences((Node)join.getLeft(), name);
                    List<Node> rightRecursiveReferences = this.findReferences((Node)join.getRight(), name);
                    if (!(leftRecursiveReferences.isEmpty() || type != Join.Type.RIGHT && type != Join.Type.FULL)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, leftRecursiveReferences.get(0), "recursive reference in left source of %s join", type);
                    }
                    if (!(rightRecursiveReferences.isEmpty() || type != Join.Type.LEFT && type != Join.Type.FULL)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, rightRecursiveReferences.get(0), "recursive reference in right source of %s join", type);
                    }
                }
            });
            AstUtils.preOrder((Node)from).filter(node -> node instanceof Intersect && !((Intersect)node).isDistinct()).forEach(node -> {
                Intersect intersect = (Intersect)node;
                intersect.getRelations().stream().flatMap(relation -> this.findReferences((Node)relation, name).stream()).findFirst().ifPresent(reference -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, reference, "recursive reference in INTERSECT ALL", new Object[0]);
                });
            });
            AstUtils.preOrder((Node)from).filter(node -> node instanceof Except).forEach(node -> {
                List<Node> leftRecursiveReferences;
                Except except = (Except)node;
                List<Node> rightRecursiveReferences = this.findReferences((Node)except.getRight(), name);
                if (!rightRecursiveReferences.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, rightRecursiveReferences.get(0), "recursive reference in right relation of EXCEPT %s", except.isDistinct() ? "DISTINCT" : "ALL");
                }
                if (!except.isDistinct() && !(leftRecursiveReferences = this.findReferences((Node)except.getLeft(), name)).isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, leftRecursiveReferences.get(0), "recursive reference in left relation of EXCEPT ALL", new Object[0]);
                }
            });
        }

        private Scope setAliases(Scope scope, Identifier tableName, List<Identifier> columnNames) {
            RelationType oldDescriptor = scope.getRelationType();
            this.validateColumnAliases(columnNames, oldDescriptor.getVisibleFieldCount());
            RelationType newDescriptor = oldDescriptor.withAlias(tableName.getValue(), (List)columnNames.stream().map(Identifier::getValue).collect(ImmutableList.toImmutableList()));
            return scope.withRelationType(newDescriptor);
        }

        private void verifySelectDistinct(QuerySpecification node, List<Expression> orderByExpressions, List<Expression> outputExpressions, Scope sourceScope, Scope orderByScope) {
            Set<CanonicalizationAware<Identifier>> aliases = this.getAliases(node.getSelect());
            Set expressions = outputExpressions.stream().map(e -> ScopeAware.scopeAwareKey(e, StatementAnalyzer.this.analysis, sourceScope)).collect(Collectors.toSet());
            for (Expression expression : orderByExpressions) {
                if (expression instanceof FieldReference || expression instanceof Identifier && aliases.contains(CanonicalizationAware.canonicalizationAwareKey(expression)) || expressions.contains(ScopeAware.scopeAwareKey(expression, StatementAnalyzer.this.analysis, orderByScope))) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
            }
            for (Expression expression : orderByExpressions) {
                if (DeterminismEvaluator.isDeterministic(expression, this::getFunctionMetadata)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)expression, "Non deterministic ORDER BY expression is not supported with SELECT DISTINCT", new Object[0]);
            }
        }

        private Set<CanonicalizationAware<Identifier>> getAliases(Select node) {
            ImmutableSet.Builder aliases = ImmutableSet.builder();
            for (SelectItem item : node.getSelectItems()) {
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    Optional alias = column.getAlias();
                    if (alias.isPresent()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)alias.get()));
                        continue;
                    }
                    if (column.getExpression() instanceof Identifier) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)column.getExpression()));
                        continue;
                    }
                    if (!(column.getExpression() instanceof DereferenceExpression)) continue;
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey(((DereferenceExpression)column.getExpression()).getField()));
                    continue;
                }
                if (!(item instanceof AllColumns)) continue;
                AllColumns allColumns = (AllColumns)item;
                List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = fields.get(i);
                    if (!allColumns.getAliases().isEmpty()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)allColumns.getAliases().get(i)));
                        continue;
                    }
                    if (!field.getName().isPresent()) continue;
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey(new Identifier(field.getName().get())));
                }
            }
            return aliases.build();
        }

        private FunctionMetadata getFunctionMetadata(FunctionCall functionCall) {
            ResolvedFunction resolvedFunction = StatementAnalyzer.this.analysis.getResolvedFunction(functionCall);
            Verify.verify((resolvedFunction != null ? 1 : 0) != 0, (String)"function has not been analyzed yet: %s", (Object)functionCall);
            return StatementAnalyzer.this.metadata.getFunctionMetadata(resolvedFunction);
        }

        private List<Expression> analyzeOrderBy(Node node, List<SortItem> sortItems, Scope orderByScope) {
            ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
            for (SortItem item : sortItems) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)orderByScope.getRelationType().getVisibleFieldCount()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    expression = new FieldReference(Math.toIntExact(ordinal - 1L));
                }
                ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.groupProvider, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, orderByScope, StatementAnalyzer.this.analysis, expression, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                Type type = StatementAnalyzer.this.analysis.getType(expression);
                if (!type.isOrderable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                }
                orderByFieldsBuilder.add((Object)expression);
            }
            return orderByFieldsBuilder.build();
        }

        private void analyzeOffset(Offset node, Scope scope) {
            long rowCount;
            if (node.getRowCount() instanceof LongLiteral) {
                rowCount = ((LongLiteral)node.getRowCount()).getValue();
            } else {
                Preconditions.checkState((boolean)(node.getRowCount() instanceof Parameter), (Object)("unexpected OFFSET rowCount: " + node.getRowCount().getClass().getSimpleName()));
                OptionalLong providedValue = this.analyzeParameterAsRowCount((Parameter)node.getRowCount(), scope, "OFFSET");
                rowCount = providedValue.orElse(0L);
            }
            if (rowCount < 0L) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "OFFSET row count must be greater or equal to 0 (actual value: %s)", rowCount);
            }
            StatementAnalyzer.this.analysis.setOffset(node, rowCount);
        }

        private boolean analyzeLimit(Node node, Scope scope) {
            Preconditions.checkState((node instanceof FetchFirst || node instanceof Limit ? 1 : 0) != 0, (String)"Invalid limit node type. Expected: FetchFirst or Limit. Actual: %s", (Object)node.getClass().getName());
            if (node instanceof FetchFirst) {
                return this.analyzeLimit((FetchFirst)node, scope);
            }
            return this.analyzeLimit((Limit)node, scope);
        }

        private boolean analyzeLimit(FetchFirst node, Scope scope) {
            long rowCount = 1L;
            if (node.getRowCount().isPresent()) {
                Expression count = (Expression)node.getRowCount().get();
                if (count instanceof LongLiteral) {
                    rowCount = ((LongLiteral)count).getValue();
                } else {
                    Preconditions.checkState((boolean)(count instanceof Parameter), (Object)("unexpected FETCH FIRST rowCount: " + count.getClass().getSimpleName()));
                    OptionalLong providedValue = this.analyzeParameterAsRowCount((Parameter)count, scope, "FETCH FIRST");
                    if (providedValue.isPresent()) {
                        rowCount = providedValue.getAsLong();
                    }
                }
            }
            if (rowCount <= 0L) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "FETCH FIRST row count must be positive (actual value: %s)", rowCount);
            }
            StatementAnalyzer.this.analysis.setLimit((Node)node, rowCount);
            return node.isWithTies();
        }

        private boolean analyzeLimit(Limit node, Scope scope) {
            OptionalLong rowCount;
            if (node.getRowCount() instanceof AllRows) {
                rowCount = OptionalLong.empty();
            } else if (node.getRowCount() instanceof LongLiteral) {
                rowCount = OptionalLong.of(((LongLiteral)node.getRowCount()).getValue());
            } else {
                Preconditions.checkState((boolean)(node.getRowCount() instanceof Parameter), (Object)("unexpected LIMIT rowCount: " + node.getRowCount().getClass().getSimpleName()));
                rowCount = this.analyzeParameterAsRowCount((Parameter)node.getRowCount(), scope, "LIMIT");
            }
            rowCount.ifPresent(count -> {
                if (count < 0L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "LIMIT row count must be greater or equal to 0 (actual value: %s)", count);
                }
            });
            StatementAnalyzer.this.analysis.setLimit((Node)node, rowCount);
            return false;
        }

        private OptionalLong analyzeParameterAsRowCount(Parameter parameter, Scope scope, String context) {
            Object value;
            if (StatementAnalyzer.this.analysis.isDescribe()) {
                this.analyzeExpression((Expression)parameter, scope);
                StatementAnalyzer.this.analysis.addCoercion((Expression)parameter, (Type)BigintType.BIGINT, false);
                return OptionalLong.empty();
            }
            this.analyzeExpression((Expression)parameter, scope);
            Expression providedValue = StatementAnalyzer.this.analysis.getParameters().get(NodeRef.of((Node)parameter));
            try {
                value = ExpressionInterpreter.evaluateConstantExpression(providedValue, (Type)BigintType.BIGINT, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis.getParameters());
            }
            catch (VerifyException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)parameter, "Non constant parameter value for %s: %s", context, providedValue);
            }
            if (value == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)parameter, "Parameter value provided for %s is NULL: %s", context, providedValue);
            }
            return OptionalLong.of((Long)value);
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope) {
            return this.createAndAssignScope(node, parentScope, Collections.emptyList());
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, Field ... fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, List<Field> fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, RelationType relationType) {
            Scope scope = this.scopeBuilder(parentScope).withRelationType(RelationId.of(node), relationType).build();
            StatementAnalyzer.this.analysis.setScope(node, scope);
            return scope;
        }

        private Scope createScope(Optional<Scope> parentScope) {
            return this.scopeBuilder(parentScope).build();
        }

        private Scope.Builder scopeBuilder(Optional<Scope> parentScope) {
            Scope.Builder scopeBuilder = Scope.builder();
            if (parentScope.isPresent()) {
                scopeBuilder.withParent(parentScope.get());
            } else {
                this.outerQueryScope.ifPresent(scopeBuilder::withOuterQueryParent);
            }
            return scopeBuilder;
        }

        private OutputColumn createOutputColumn(Field field) {
            return new OutputColumn(new Column(field.getName().orElseThrow(), field.getType().toString()), StatementAnalyzer.this.analysis.getSourceColumns(field));
        }

        private /* synthetic */ void lambda$visitPatternRecognitionRelation$36(Set allLabels, Identifier identifier) {
            String label = this.label(identifier);
            if (!allLabels.contains(label)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)identifier, "%s is not a primary or union pattern variable", identifier);
            }
        }
    }

    private static enum UpdateKind {
        DELETE,
        UPDATE;

    }
}

