/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.Variable;
import io.trino.sql.gen.Binding;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class CachedInstanceBinder {
    private final ClassDefinition classDefinition;
    private final CallSiteBinder callSiteBinder;
    private final Map<FieldDefinition, MethodHandle> initializers = new HashMap<FieldDefinition, MethodHandle>();
    private int nextId;

    public CachedInstanceBinder(ClassDefinition classDefinition, CallSiteBinder callSiteBinder) {
        this.classDefinition = Objects.requireNonNull(classDefinition, "classDefinition is null");
        this.callSiteBinder = Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public FieldDefinition getCachedInstance(MethodHandle methodHandle) {
        FieldDefinition field = this.classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "__cachedInstance" + this.nextId, (Class)methodHandle.type().returnType());
        this.initializers.put(field, methodHandle);
        ++this.nextId;
        return field;
    }

    public void generateInitializations(Variable thisVariable, BytecodeBlock block) {
        for (Map.Entry<FieldDefinition, MethodHandle> entry : this.initializers.entrySet()) {
            Binding binding = this.callSiteBinder.bind(entry.getValue());
            block.append((BytecodeNode)thisVariable).append((BytecodeNode)BytecodeUtils.invoke(binding, "instanceFieldConstructor")).putField(entry.getKey());
        }
    }
}

