/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.control.SwitchStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.JumpInstruction;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.Binding;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.util.FastutilSetHelper;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InCodeGenerator
implements BytecodeGenerator {
    private final RowExpression valueExpression;
    private final List<RowExpression> testExpressions;
    private final ResolvedFunction resolvedEqualsFunction;
    private final ResolvedFunction resolvedHashCodeFunction;
    private final ResolvedFunction resolvedIsIndeterminate;

    public InCodeGenerator(SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.getArguments().size() >= 2 ? 1 : 0) != 0, (Object)"At least two arguments are required");
        this.valueExpression = specialForm.getArguments().get(0);
        this.testExpressions = specialForm.getArguments().subList(1, specialForm.getArguments().size());
        Preconditions.checkArgument((specialForm.getFunctionDependencies().size() == 3 ? 1 : 0) != 0);
        this.resolvedEqualsFunction = specialForm.getOperatorDependency(OperatorType.EQUAL);
        this.resolvedHashCodeFunction = specialForm.getOperatorDependency(OperatorType.HASH_CODE);
        this.resolvedIsIndeterminate = specialForm.getOperatorDependency(OperatorType.INDETERMINATE);
    }

    @VisibleForTesting
    static SwitchGenerationCase checkSwitchGenerationCase(Type type, List<RowExpression> values) {
        if (type.getJavaType() != Long.TYPE && values.size() >= 8 || type.getJavaType() == Long.TYPE && values.size() >= 16) {
            return SwitchGenerationCase.SET_CONTAINS;
        }
        if (type.getJavaType() != Long.TYPE) {
            return SwitchGenerationCase.HASH_SWITCH;
        }
        for (RowExpression expression : values) {
            long longConstant;
            Object constant;
            if (!(expression instanceof ConstantExpression) || (constant = ((ConstantExpression)expression).getValue()) == null || (longConstant = ((Number)constant).longValue()) >= Integer.MIN_VALUE && longConstant <= Integer.MAX_VALUE) continue;
            return SwitchGenerationCase.HASH_SWITCH;
        }
        return SwitchGenerationCase.DIRECT_SWITCH;
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext) {
        BytecodeBlock switchBlock;
        Type type = this.valueExpression.getType();
        Class<Object> javaType = type.getJavaType();
        SwitchGenerationCase switchGenerationCase = InCodeGenerator.checkSwitchGenerationCase(type, this.testExpressions);
        MethodHandle equalsMethodHandle = generatorContext.getScalarFunctionInvoker(this.resolvedEqualsFunction, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        MethodHandle hashCodeMethodHandle = generatorContext.getScalarFunctionInvoker(this.resolvedHashCodeFunction, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        MethodHandle indeterminateMethodHandle = generatorContext.getScalarFunctionInvoker(this.resolvedIsIndeterminate, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (RowExpression testValue : this.testExpressions) {
            BytecodeNode testBytecode = generatorContext.generate(testValue);
            if (InCodeGenerator.isDeterminateConstant(testValue, indeterminateMethodHandle)) {
                ConstantExpression constant = (ConstantExpression)testValue;
                Object object = constant.getValue();
                switch (switchGenerationCase) {
                    case DIRECT_SWITCH: 
                    case SET_CONTAINS: {
                        constantValuesBuilder.add(object);
                        break;
                    }
                    case HASH_SWITCH: {
                        try {
                            int hashCode = Long.hashCode(hashCodeMethodHandle.invoke(object));
                            hashBucketsBuilder.put((Object)hashCode, (Object)testBytecode);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + object, throwable);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported switch generation case: " + switchGenerationCase);
                    }
                }
                continue;
            }
            defaultBucket.add((Object)testBytecode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        Scope scope = generatorContext.getScope();
        Variable value = scope.createTempVariable((Class)javaType);
        Variable expression = scope.createTempVariable(Integer.TYPE);
        SwitchStatement.SwitchBuilder switchBuilder = new SwitchStatement.SwitchBuilder().expression((BytecodeExpression)expression);
        switch (switchGenerationCase) {
            case DIRECT_SWITCH: {
                for (Object constantValue : constantValues) {
                    switchBuilder.addCase(Math.toIntExact((Long)constantValue), (BytecodeNode)JumpInstruction.jump((LabelNode)match));
                }
                switchBuilder.defaultCase((BytecodeNode)JumpInstruction.jump((LabelNode)defaultLabel));
                switchBlock = new BytecodeBlock().comment("lookupSwitch(<stackValue>))").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.invokeStatic(InCodeGenerator.class, (String)"isInteger", Boolean.TYPE, (BytecodeExpression[])new BytecodeExpression[]{value})).ifFalse((BytecodeNode)new BytecodeBlock().gotoLabel(defaultLabel))).append((BytecodeNode)expression.set(value.cast(Integer.TYPE))).append((BytecodeNode)switchBuilder.build());
                break;
            }
            case HASH_SWITCH: {
                for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                    Collection testValues = (Collection)bucket.getValue();
                    BytecodeBlock caseBlock = InCodeGenerator.buildInCase(generatorContext, scope, this.resolvedEqualsFunction, match, defaultLabel, value, testValues, false, this.resolvedIsIndeterminate);
                    switchBuilder.addCase(((Integer)bucket.getKey()).intValue(), (BytecodeNode)caseBlock);
                }
                switchBuilder.defaultCase((BytecodeNode)JumpInstruction.jump((LabelNode)defaultLabel));
                Binding hashCodeBinding = generatorContext.getCallSiteBinder().bind(hashCodeMethodHandle);
                switchBlock = new BytecodeBlock().comment("lookupSwitch(hashCode(<stackValue>))").getVariable(value).append((BytecodeNode)BytecodeUtils.invoke(hashCodeBinding, this.resolvedHashCodeFunction.getSignature())).invokeStatic(Long.class, "hashCode", Integer.TYPE, new Class[]{Long.TYPE}).putVariable(expression).append((BytecodeNode)switchBuilder.build());
                break;
            }
            case SET_CONTAINS: {
                Set<?> constantValuesSet = FastutilSetHelper.toFastutilHashSet(constantValues, type, hashCodeMethodHandle, equalsMethodHandle);
                Binding constant = generatorContext.getCallSiteBinder().bind(constantValuesSet, constantValuesSet.getClass());
                switchBlock = new BytecodeBlock().comment("inListSet.contains(<stackValue>)").append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().comment("value").getVariable(value).comment("set").append((BytecodeNode)BytecodeUtils.loadConstant(constant)).invokeStatic(FastutilSetHelper.class, "in", Boolean.TYPE, new Class[]{javaType.isPrimitive() ? javaType : Object.class, constantValuesSet.getClass()})).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)match)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported switch generation case: " + switchGenerationCase);
            }
        }
        BytecodeBlock defaultCaseBlock = InCodeGenerator.buildInCase(generatorContext, scope, this.resolvedEqualsFunction, match, noMatch, value, (Collection<BytecodeNode>)defaultBucket.build(), true, this.resolvedIsIndeterminate).setDescription("default");
        BytecodeBlock block = new BytecodeBlock().comment("IN").append(generatorContext.generate(this.valueExpression)).append(BytecodeUtils.ifWasNullPopAndGoto(scope, end, Boolean.TYPE, javaType)).putVariable(value).append((BytecodeNode)switchBlock).visitLabel(defaultLabel).append((BytecodeNode)defaultCaseBlock);
        BytecodeBlock matchBlock = new BytecodeBlock().setDescription("match").visitLabel(match).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse())).push(true).gotoLabel(end);
        block.append((BytecodeNode)matchBlock);
        BytecodeBlock noMatchBlock = new BytecodeBlock().setDescription("noMatch").visitLabel(noMatch).push(false).gotoLabel(end);
        block.append((BytecodeNode)noMatchBlock);
        block.visitLabel(end);
        return block;
    }

    public static boolean isInteger(long value) {
        return value == (long)((int)value);
    }

    private static BytecodeBlock buildInCase(BytecodeGeneratorContext generatorContext, Scope scope, ResolvedFunction equals, LabelNode matchLabel, LabelNode noMatchLabel, Variable value, Collection<BytecodeNode> testValues, boolean checkForNulls, ResolvedFunction isIndeterminateFunction) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = scope.createTempVariable(Boolean.TYPE);
        }
        BytecodeBlock caseBlock = new BytecodeBlock();
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull, false);
        }
        LabelNode elseLabel = new LabelNode("else");
        BytecodeBlock elseBlock = new BytecodeBlock().visitLabel(elseLabel);
        Variable wasNull = generatorContext.wasNull();
        if (checkForNulls) {
            if (testValues.isEmpty()) {
                elseBlock.append((BytecodeNode)new BytecodeBlock().append(generatorContext.generateCall(isIndeterminateFunction, (List<BytecodeNode>)ImmutableList.of((Object)value))).putVariable(wasNull));
            } else {
                elseBlock.append((BytecodeNode)wasNull.set((BytecodeExpression)caseWasNull));
            }
        }
        elseBlock.gotoLabel(noMatchLabel);
        BytecodeBlock elseNode = elseBlock;
        for (BytecodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement test = new IfStatement();
            BytecodeNode equalsCall = generatorContext.generateCall(equals, (List<BytecodeNode>)ImmutableList.of((Object)value, (Object)testNode));
            test.condition().visitLabel(testLabel).append(equalsCall);
            if (checkForNulls) {
                IfStatement wasNullCheck = new IfStatement("if wasNull, set caseWasNull to true, clear wasNull, pop boolean, and goto next test value", new Object[0]);
                wasNullCheck.condition((BytecodeNode)wasNull);
                wasNullCheck.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)caseWasNull.set(BytecodeExpressions.constantTrue())).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(Boolean.TYPE).gotoLabel(elseLabel));
                test.condition().append((BytecodeNode)wasNullCheck);
            }
            test.ifTrue().gotoLabel(matchLabel);
            test.ifFalse((BytecodeNode)elseNode);
            elseNode = test;
            elseLabel = testLabel;
        }
        caseBlock.append((BytecodeNode)elseNode);
        return caseBlock;
    }

    private static boolean isDeterminateConstant(RowExpression expression, MethodHandle isIndeterminateFunction) {
        if (!(expression instanceof ConstantExpression)) {
            return false;
        }
        ConstantExpression constantExpression = (ConstantExpression)expression;
        Object value = constantExpression.getValue();
        if (value == null) {
            return false;
        }
        try {
            return !isIndeterminateFunction.invoke(value);
        }
        catch (Throwable t) {
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    static enum SwitchGenerationCase {
        DIRECT_SWITCH,
        HASH_SWITCH,
        SET_CONTAINS;

    }
}

