/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.rowpattern.IrPatternAlternationOptimizer;
import io.trino.sql.planner.rowpattern.IrRowPatternFlattener;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;

public class OptimizeRowPattern
implements Rule<PatternRecognitionNode> {
    private static final Pattern<PatternRecognitionNode> PATTERN = Patterns.patternRecognition();

    @Override
    public Pattern<PatternRecognitionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
        IrRowPattern optimizedPattern = IrPatternAlternationOptimizer.optimize(IrRowPatternFlattener.optimize(node.getPattern()));
        if (optimizedPattern.equals(node.getPattern())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new PatternRecognitionNode(node.getId(), node.getSource(), node.getSpecification(), node.getHashSymbol(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix(), node.getMeasures(), node.getCommonBaseFrame(), node.getRowsPerMatch(), node.getSkipToLabel(), node.getSkipToPosition(), node.isInitial(), optimizedPattern, node.getSubsets(), node.getVariableDefinitions()));
    }
}

