/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.OperatorInputStats;
import io.trino.util.Mergeable;
import io.trino.util.MoreMaps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PlanNodeStats
implements Mergeable<PlanNodeStats> {
    private final PlanNodeId planNodeId;
    private final Duration planNodeScheduledTime;
    private final Duration planNodeCpuTime;
    private final long planNodeInputPositions;
    private final DataSize planNodeInputDataSize;
    private final long planNodeOutputPositions;
    private final DataSize planNodeOutputDataSize;
    private final DataSize planNodeSpilledDataSize;
    protected final Map<String, OperatorInputStats> operatorInputStats;

    PlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, long planNodeInputPositions, DataSize planNodeInputDataSize, long planNodeOutputPositions, DataSize planNodeOutputDataSize, DataSize planNodeSpilledDataSize, Map<String, OperatorInputStats> operatorInputStats) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.planNodeScheduledTime = Objects.requireNonNull(planNodeScheduledTime, "planNodeScheduledTime is null");
        this.planNodeCpuTime = Objects.requireNonNull(planNodeCpuTime, "planNodeCpuTime is null");
        this.planNodeInputPositions = planNodeInputPositions;
        this.planNodeInputDataSize = planNodeInputDataSize;
        this.planNodeOutputPositions = planNodeOutputPositions;
        this.planNodeOutputDataSize = planNodeOutputDataSize;
        this.planNodeSpilledDataSize = Objects.requireNonNull(planNodeSpilledDataSize, "planNodeSpilledDataSize is null");
        this.operatorInputStats = Objects.requireNonNull(operatorInputStats, "operatorInputStats is null");
    }

    private static double computedStdDev(double sumSquared, double sum, long n) {
        double average = sum / (double)n;
        double variance = (sumSquared - 2.0 * sum * average + average * average * (double)n) / (double)n;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public Duration getPlanNodeScheduledTime() {
        return this.planNodeScheduledTime;
    }

    public Duration getPlanNodeCpuTime() {
        return this.planNodeCpuTime;
    }

    public Set<String> getOperatorTypes() {
        return this.operatorInputStats.keySet();
    }

    public long getPlanNodeInputPositions() {
        return this.planNodeInputPositions;
    }

    public DataSize getPlanNodeInputDataSize() {
        return this.planNodeInputDataSize;
    }

    public long getPlanNodeOutputPositions() {
        return this.planNodeOutputPositions;
    }

    public DataSize getPlanNodeOutputDataSize() {
        return this.planNodeOutputDataSize;
    }

    public DataSize getPlanNodeSpilledDataSize() {
        return this.planNodeSpilledDataSize;
    }

    public Map<String, Double> getOperatorInputPositionsAverages() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (double)((OperatorInputStats)entry.getValue()).getInputPositions() / (double)this.operatorInputStats.get(entry.getKey()).getTotalDrivers()));
    }

    public Map<String, Double> getOperatorInputPositionsStdDevs() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PlanNodeStats.computedStdDev(((OperatorInputStats)entry.getValue()).getSumSquaredInputPositions(), ((OperatorInputStats)entry.getValue()).getInputPositions(), ((OperatorInputStats)entry.getValue()).getTotalDrivers())));
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals(other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
        this.checkMergeable(other);
        long planNodeInputPositions = this.planNodeInputPositions + other.planNodeInputPositions;
        DataSize planNodeInputDataSize = DataSize.succinctBytes((long)(this.planNodeInputDataSize.toBytes() + other.planNodeInputDataSize.toBytes()));
        long planNodeOutputPositions = this.planNodeOutputPositions + other.planNodeOutputPositions;
        DataSize planNodeOutputDataSize = DataSize.succinctBytes((long)(this.planNodeOutputDataSize.toBytes() + other.planNodeOutputDataSize.toBytes()));
        Map<String, OperatorInputStats> operatorInputStats = MoreMaps.mergeMaps(this.operatorInputStats, other.operatorInputStats, OperatorInputStats::merge);
        return new PlanNodeStats(this.planNodeId, new Duration((double)(this.planNodeScheduledTime.toMillis() + other.getPlanNodeScheduledTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeCpuTime.toMillis() + other.getPlanNodeCpuTime().toMillis()), TimeUnit.MILLISECONDS), planNodeInputPositions, planNodeInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, DataSize.succinctBytes((long)(this.planNodeSpilledDataSize.toBytes() + other.planNodeSpilledDataSize.toBytes())), operatorInputStats);
    }

    protected void checkMergeable(PlanNodeStats other) {
        Preconditions.checkArgument((this.getClass() == other.getClass() ? 1 : 0) != 0, (String)"Cannot merge stats %s and %s, make sure all worker nodes have consistent configuration", (Object)this, (Object)other);
    }
}

