/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.DescribeInputRewrite;
import io.trino.sql.rewrite.DescribeOutputRewrite;
import io.trino.sql.rewrite.ExplainRewrite;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.ShowStatsRewrite;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class StatementRewrite {
    private static final List<Rewrite> REWRITES = ImmutableList.of((Object)new DescribeInputRewrite(), (Object)new DescribeOutputRewrite(), (Object)new ShowQueriesRewrite(), (Object)new ShowStatsRewrite(), (Object)new ExplainRewrite());

    private StatementRewrite() {
    }

    public static Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
        for (Rewrite rewrite : REWRITES) {
            node = Objects.requireNonNull(rewrite.rewrite(session, metadata, parser, queryExplainer, node, parameters, parameterLookup, groupProvider, accessControl, warningCollector, statsCalculator), "Statement rewrite returned null");
        }
        return node;
    }

    static interface Rewrite {
        public Statement rewrite(Session var1, Metadata var2, SqlParser var3, Optional<QueryExplainer> var4, Statement var5, List<Expression> var6, Map<NodeRef<Parameter>, Expression> var7, GroupProvider var8, AccessControl var9, WarningCollector var10, StatsCalculator var11);
    }
}

