/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.client.Warning;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedRow;
import io.trino.type.JsonType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MaterializedResult
implements Iterable<MaterializedRow> {
    public static final int DEFAULT_PRECISION = 5;
    private final List<MaterializedRow> rows;
    private final List<Type> types;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Optional<String> updateType;
    private final OptionalLong updateCount;
    private final List<Warning> warnings;

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types) {
        this(rows, types, (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), OptionalLong.empty(), (List<Warning>)ImmutableList.of());
    }

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types, Map<String, String> setSessionProperties, Set<String> resetSessionProperties, Optional<String> updateType, OptionalLong updateCount, List<Warning> warnings) {
        this.rows = ImmutableList.copyOf((Collection)Objects.requireNonNull(rows, "rows is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.setSessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(setSessionProperties, "setSessionProperties is null"));
        this.resetSessionProperties = ImmutableSet.copyOf((Collection)Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null"));
        this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        this.updateCount = Objects.requireNonNull(updateCount, "updateCount is null");
        this.warnings = Objects.requireNonNull(warnings, "warnings is null");
    }

    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<MaterializedRow> iterator() {
        return this.rows.iterator();
    }

    public List<MaterializedRow> getMaterializedRows() {
        return this.rows;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    public OptionalLong getUpdateCount() {
        return this.updateCount;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedResult o = (MaterializedResult)obj;
        return Objects.equals(this.types, o.types) && Objects.equals(this.rows, o.rows) && Objects.equals(this.setSessionProperties, o.setSessionProperties) && Objects.equals(this.resetSessionProperties, o.resetSessionProperties) && Objects.equals(this.updateType, o.updateType) && Objects.equals(this.updateCount, o.updateCount);
    }

    public int hashCode() {
        return Objects.hash(this.rows, this.types, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.rows).add("types", this.types).add("setSessionProperties", this.setSessionProperties).add("resetSessionProperties", this.resetSessionProperties).add("updateType", this.updateType.orElse(null)).add("updateCount", this.updateCount.isPresent() ? Long.valueOf(this.updateCount.getAsLong()) : null).omitNullValues().toString();
    }

    public Stream<Object> getOnlyColumn() {
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return this.rows.stream().map(row -> row.getField(0));
    }

    public Set<Object> getOnlyColumnAsSet() {
        return this.getOnlyColumn().collect(Collectors.toSet());
    }

    public Object getOnlyValue() {
        Preconditions.checkState((this.rows.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one row");
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return this.rows.get(0).getField(0);
    }

    public Page toPage() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        for (MaterializedRow row : this.rows) {
            MaterializedResult.appendToPage(pageBuilder, row);
        }
        return pageBuilder.build();
    }

    private static void appendToPage(PageBuilder pageBuilder, MaterializedRow row) {
        for (int field = 0; field < row.getFieldCount(); ++field) {
            Type type = pageBuilder.getType(field);
            Object value = row.getField(field);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(field);
            MaterializedResult.writeValue(type, blockBuilder, value);
        }
        pageBuilder.declarePosition();
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Integer)value).intValue());
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Short)value).shortValue());
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Byte)value).byteValue());
        } else if (RealType.REAL.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(((Float)value).floatValue()));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (JsonType.JSON.equals(type)) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
        } else if (type instanceof VarcharType) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
        } else if (type instanceof CharType) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])value)));
        } else if (DateType.DATE.equals((Object)type)) {
            int days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, (long)days);
        } else if (type instanceof TimeType) {
            SqlTime time = (SqlTime)value;
            type.writeLong(blockBuilder, time.getPicos());
        } else if (type instanceof TimeWithTimeZoneType) {
            long nanos = Timestamps.roundDiv((long)((SqlTimeWithTimeZone)value).getPicos(), (long)1000L);
            int offsetMinutes = ((SqlTimeWithTimeZone)value).getOffsetMinutes();
            type.writeLong(blockBuilder, DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)offsetMinutes));
        } else if (type instanceof TimestampType) {
            long micros = ((SqlTimestamp)value).getEpochMicros();
            if (((TimestampType)type).getPrecision() <= 6) {
                type.writeLong(blockBuilder, micros);
            } else {
                type.writeObject(blockBuilder, (Object)new LongTimestamp(micros, ((SqlTimestamp)value).getPicosOfMicros()));
            }
        } else if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            long millisUtc = ((SqlTimestampWithTimeZone)value).getMillisUtc();
            TimeZoneKey timeZoneKey = ((SqlTimestampWithTimeZone)value).getTimeZoneKey();
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
        } else if (type instanceof ArrayType) {
            List list = (List)value;
            Type elementType = ((ArrayType)type).getElementType();
            BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object element : list) {
                MaterializedResult.writeValue(elementType, arrayBlockBuilder, element);
            }
            blockBuilder.closeEntry();
        } else if (type instanceof MapType) {
            Map map = (Map)value;
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : map.entrySet()) {
                MaterializedResult.writeValue(keyType, mapBlockBuilder, entry.getKey());
                MaterializedResult.writeValue(valueType, mapBlockBuilder, entry.getValue());
            }
            blockBuilder.closeEntry();
        } else if (type instanceof RowType) {
            List row = (List)value;
            List fieldTypes = type.getTypeParameters();
            BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
            for (int field = 0; field < row.size(); ++field) {
                MaterializedResult.writeValue((Type)fieldTypes.get(field), rowBlockBuilder, row.get(field));
            }
            blockBuilder.closeEntry();
        } else {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
    }

    public MaterializedResult toTestTypes() {
        return new MaterializedResult((List)this.rows.stream().map(MaterializedResult::convertToTestTypes).collect(ImmutableList.toImmutableList()), this.types, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount, this.warnings);
    }

    private static MaterializedRow convertToTestTypes(MaterializedRow trinoRow) {
        ArrayList<Object> convertedValues = new ArrayList<Object>();
        for (int field = 0; field < trinoRow.getFieldCount(); ++field) {
            Object convertedValue;
            Object trinoValue = trinoRow.getField(field);
            if (trinoValue instanceof SqlDate) {
                convertedValue = LocalDate.ofEpochDay(((SqlDate)trinoValue).getDays());
            } else if (trinoValue instanceof SqlTime) {
                convertedValue = DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)trinoValue.toString(), LocalTime::from);
            } else if (trinoValue instanceof SqlTimeWithTimeZone) {
                long nanos = Timestamps.roundDiv((long)((SqlTimeWithTimeZone)trinoValue).getPicos(), (long)1000L);
                int offsetMinutes = ((SqlTimeWithTimeZone)trinoValue).getOffsetMinutes();
                convertedValue = OffsetTime.of(LocalTime.ofNanoOfDay(nanos), ZoneOffset.ofTotalSeconds(offsetMinutes * 60));
            } else {
                convertedValue = trinoValue instanceof SqlTimestamp ? ((SqlTimestamp)trinoValue).toLocalDateTime() : (trinoValue instanceof SqlTimestampWithTimeZone ? ((SqlTimestampWithTimeZone)trinoValue).toZonedDateTime() : (trinoValue instanceof SqlDecimal ? ((SqlDecimal)trinoValue).toBigDecimal() : trinoValue));
            }
            convertedValues.add(convertedValue);
        }
        return new MaterializedRow(trinoRow.getPrecision(), convertedValues);
    }

    public static MaterializedResult materializeSourceDataStream(Session session, ConnectorPageSource pageSource, List<Type> types) {
        return MaterializedResult.materializeSourceDataStream(session.toConnectorSession(), pageSource, types);
    }

    public static MaterializedResult materializeSourceDataStream(ConnectorSession session, ConnectorPageSource pageSource, List<Type> types) {
        Builder builder = MaterializedResult.resultBuilder(session, types);
        while (!pageSource.isFinished()) {
            Page outputPage = pageSource.getNextPage();
            if (outputPage == null) continue;
            builder.page(outputPage);
        }
        return builder.build();
    }

    public static Builder resultBuilder(Session session, Type ... types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(Session session, Iterable<? extends Type> types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(ConnectorSession session, Type ... types) {
        return MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static Builder resultBuilder(ConnectorSession session, Iterable<? extends Type> types) {
        return new Builder(session, (List<Type>)ImmutableList.copyOf(types));
    }

    public static class Builder {
        private final ConnectorSession session;
        private final List<Type> types;
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();

        Builder(ConnectorSession session, List<Type> types) {
            this.session = session;
            this.types = ImmutableList.copyOf(types);
        }

        public synchronized Builder rows(List<MaterializedRow> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public synchronized Builder row(Object ... values) {
            this.rows.add((Object)new MaterializedRow(5, values));
            return this;
        }

        public synchronized Builder rows(Object[][] rows) {
            for (Object[] row : rows) {
                this.row(row);
            }
            return this;
        }

        public synchronized Builder pages(Iterable<Page> pages) {
            for (Page page : pages) {
                this.page(page);
            }
            return this;
        }

        public synchronized Builder page(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (int)this.types.size(), (int)page.getChannelCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, position));
                }
                values = Collections.unmodifiableList(values);
                this.rows.add((Object)new MaterializedRow(5, values));
            }
            return this;
        }

        public synchronized MaterializedResult build() {
            return new MaterializedResult((List<MaterializedRow>)this.rows.build(), this.types);
        }
    }
}

