/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class SingleAccessMethodCompiler {
    private SingleAccessMethodCompiler() {
    }

    public static <T> T compileSingleAccessMethod(String suggestedClassName, Class<T> interfaceType, MethodHandle methodHandle) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL, Access.SYNTHETIC}), CompilerUtils.makeClassName(suggestedClassName), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(interfaceType)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        Method method = SingleAccessMethodCompiler.getSingleAbstractMethod(interfaceType);
        Class<?>[] parameterTypes = method.getParameterTypes();
        MethodHandle adaptedMethodHandle = methodHandle.asType(MethodType.methodType(method.getReturnType(), parameterTypes));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters.add(Parameter.arg((String)("arg" + i), parameterTypes[i]));
        }
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), method.getName(), ParameterizedType.type(method.getReturnType()), parameters);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        BytecodeExpression invocation = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(adaptedMethodHandle).getBindingId()), (String)method.getName(), method.getReturnType(), parameters);
        if (method.getReturnType() != Void.TYPE) {
            invocation = invocation.ret();
        }
        methodDefinition.getBody().append((BytecodeNode)invocation);
        ClassLoader classLoader = SingleAccessMethodCompiler.class.getClassLoader();
        Class<T> newClass = CompilerUtils.defineClass(classDefinition, interfaceType, callSiteBinder.getBindings(), classLoader);
        try {
            return newClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Method getSingleAbstractMethod(Class<T> interfaceType) {
        List interfaceMethods = (List)Arrays.stream(interfaceType.getMethods()).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(SingleAccessMethodCompiler::notJavaObjectMethod).collect(ImmutableList.toImmutableList());
        if (interfaceMethods.size() != 1) {
            throw new IllegalArgumentException(interfaceType.getSimpleName() + "  does not have a single abstract method");
        }
        return (Method)interfaceMethods.get(0);
    }

    private static boolean notJavaObjectMethod(Method method) {
        return !SingleAccessMethodCompiler.methodMatches(method, "toString", String.class, new Class[0]) && !SingleAccessMethodCompiler.methodMatches(method, "hashCode", Integer.TYPE, new Class[0]) && !SingleAccessMethodCompiler.methodMatches(method, "equals", Boolean.TYPE, Object.class);
    }

    private static boolean methodMatches(Method method, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return method.getParameterCount() == parameterTypes.length && method.getReturnType() == returnType && name.equals(method.getName()) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }
}

