/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsAndCosts;
import io.trino.event.SplitMonitor;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.Lifespan;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SqlTask;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskSource;
import io.trino.execution.TestSqlTaskManager;
import io.trino.execution.TestingPageSourceProvider;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.index.IndexManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.ExchangeClientSupplier;
import io.trino.operator.OperatorFactories;
import io.trino.operator.PagesIndex;
import io.trino.operator.StageExecutionDescriptor;
import io.trino.operator.TrinoOperatorFactories;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.PageSourceProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSplit;
import io.trino.type.BlockTypeOperators;
import io.trino.util.FinalizerService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class TaskTestUtils {
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final CatalogName CONNECTOR_ID = TestingHandles.TEST_TABLE_HANDLE.getCatalogName();
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, TABLE_SCAN_NODE_ID, new Split(CONNECTOR_ID, (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
    public static final ImmutableList<TaskSource> EMPTY_SOURCES = ImmutableList.of();
    public static final Symbol SYMBOL = new Symbol("column");
    public static final PlanFragment PLAN_FRAGMENT = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)TableScanNode.newInstance((PlanNodeId)TABLE_SCAN_NODE_ID, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT)), (boolean)false, Optional.empty()), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)SYMBOL)).withBucketToPartition(Optional.of(new int[1])), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());

    private TaskTestUtils() {
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageSourceManager pageSourceManager = new PageSourceManager();
        pageSourceManager.addConnectorPageSourceProvider(CONNECTOR_ID, (ConnectorPageSourceProvider)new TestingPageSourceProvider());
        FinalizerService finalizerService = new FinalizerService();
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(finalizerService)));
        NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(nodeScheduler, blockTypeOperators);
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        return new LocalExecutionPlanner((Metadata)metadata, new TypeAnalyzer(new SqlParser(), (Metadata)metadata), Optional.empty(), (PageSourceProvider)pageSourceManager, new IndexManager(), nodePartitioningManager, new PageSinkManager(), (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler), pageFunctionCompiler, new JoinFilterFunctionCompiler((Metadata)metadata), new IndexJoinLookupStats(), new TaskManagerConfig(), (SpillerFactory)new GenericSpillerFactory((types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }), (types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (types, partitionFunction, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), new JoinCompiler(typeOperators), (OperatorFactories)new TrinoOperatorFactories(), new OrderingCompiler(typeOperators), new DynamicFilterConfig(), typeOperators, blockTypeOperators);
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<TaskSource> taskSources, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(PLAN_FRAGMENT), taskSources, outputBuffers, OptionalInt.empty(), (Map)ImmutableMap.of());
    }

    public static SplitMonitor createTestSplitMonitor() {
        return new SplitMonitor(new EventListenerManager(new EventListenerConfig()), new ObjectMapperProvider().get());
    }
}

