/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.CreateSchemaTask;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateSchemaTask {
    private static final String CATALOG_NAME = "catalog";
    private Session testSession;
    MockMetadata metadata;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        SchemaPropertyManager schemaPropertyManager = new SchemaPropertyManager();
        schemaPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of());
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(schemaPropertyManager, testCatalog.getConnectorCatalogName());
    }

    @Test
    public void testDuplicatedCreateSchema() {
        String schemaName = "test_db";
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)schemaName), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()))).withMessage("Schema already exists");
    }

    @Test
    public void testDuplicatedCreateSchemaIfNotExists() {
        String schemaName = "test_db";
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)schemaName), true, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final CatalogName catalogHandle;
        private final List<CatalogSchemaName> schemas;
        private final SchemaPropertyManager schemaPropertyManager;

        public MockMetadata(SchemaPropertyManager schemaPropertyManager, CatalogName catalogHandle) {
            this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.schemas = new CopyOnWriteArrayList<CatalogSchemaName>();
        }

        @Override
        public SchemaPropertyManager getSchemaPropertyManager() {
            return this.schemaPropertyManager;
        }

        @Override
        public boolean schemaExists(Session session, CatalogSchemaName schema) {
            return false;
        }

        @Override
        public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
            if (this.schemas.contains(schema)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Schema already exists");
            }
            this.schemas.add(schema);
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        public int getCreateSchemaCount() {
            return this.schemas.size();
        }
    }
}

