/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetRoleTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.SetRole;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetRoleTask {
    private static final String CATALOG_NAME = "foo";
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private ExecutorService executor;
    private SqlParser parser;

    @BeforeClass
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)CATALOG_NAME));
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-set-role-task-executor-%s"));
        this.parser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.metadata = null;
        this.accessControl = null;
        this.transactionManager = null;
        this.parser = null;
    }

    @Test
    public void testSetRole() {
        this.assertSetRole("SET ROLE ALL", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
        this.assertSetRole("SET ROLE bar", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("bar"))));
    }

    @Test
    public void testSetRoleInvalidCatalog() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("invalid", "SET ROLE foo")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND).hasMessage("Catalog does not exist: invalid");
    }

    private void assertSetRole(String statement, Map<String, SelectedRole> expected) {
        QueryStateMachine stateMachine = this.executeSetRole(CATALOG_NAME, statement);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Map)queryInfo.getSetRoles(), expected);
    }

    private QueryStateMachine executeSetRole(String catalog, String statement) {
        SetRole setRole = (SetRole)this.parser.createStatement(statement, new ParsingOptions());
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)statement, Optional.empty(), (Session)TestingSession.testSessionBuilder().setCatalog(catalog).build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
        new SetRoleTask().execute(setRole, this.transactionManager, this.metadata, this.accessControl, stateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
        return stateMachine;
    }
}

